/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.DQP;
import com.kubling.teiid.client.security.LogonResult;
import com.kubling.teiid.client.security.SessionToken;
import com.kubling.teiid.client.util.ResultsFuture;
import com.kubling.teiid.client.xa.XATransactionException;
import com.kubling.teiid.client.xa.XidImpl;
import com.kubling.teiid.jdbc.ConnectionImpl;
import com.kubling.teiid.jdbc.DatabaseMetaDataImpl;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.jdbc.TeiidDriver;
import com.kubling.teiid.jdbc.TeiidSQLException;
import com.kubling.teiid.net.ServerConnection;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestConnection {
    protected static final String STD_DATABASE_NAME = "QT_Ora9DS";
    protected static final int STD_DATABASE_VERSION = 1;
    static String serverUrl = "jdbc:teiid:QT_Ora9DS@mm://localhost:7001;version=1;user=metamatrixadmin;password=mm";

    public static ConnectionImpl getMMConnection() {
        return TestConnection.getMMConnection(serverUrl);
    }

    public static ConnectionImpl getMMConnection(String url) {
        ServerConnection mock = (ServerConnection)Mockito.mock(ServerConnection.class);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        try {
            Mockito.when((Object)dqp.start((XidImpl)Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).then(invocation -> ResultsFuture.NULL_FUTURE);
            Mockito.when((Object)dqp.rollback((XidImpl)Mockito.any())).then(invocation -> ResultsFuture.NULL_FUTURE);
            Mockito.when((Object)dqp.rollback()).then(invocation -> ResultsFuture.NULL_FUTURE);
        }
        catch (XATransactionException e) {
            throw new RuntimeException(e);
        }
        Properties props = new Properties();
        try {
            new InnerDriver(url).parseUrl(props);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Mockito.when((Object)((DQP)mock.getService(DQP.class))).thenReturn((Object)dqp);
        Mockito.when((Object)mock.getLogonResult()).thenReturn((Object)new LogonResult(new SessionToken(1L, "admin"), STD_DATABASE_NAME, "fake"));
        return new ConnectionImpl(mock, props, url);
    }

    @Test
    public void testGetMetaData() throws Exception {
        Assertions.assertNotNull((Object)TestConnection.getMMConnection().getMetaData());
    }

    @Test
    public void testNullSorts() throws Exception {
        DatabaseMetaDataImpl metadata = TestConnection.getMMConnection("jdbc:teiid:QT_Ora9DS@mm://localhost:7001;version=1;NullsAreSorted=AtEnd").getMetaData();
        Assertions.assertTrue((boolean)metadata.nullsAreSortedAtEnd());
        Assertions.assertFalse((boolean)metadata.nullsAreSortedLow());
        metadata = TestConnection.getMMConnection("jdbc:teiid:QT_Ora9DS@mm://localhost:7001;version=1").getMetaData();
        Assertions.assertFalse((boolean)metadata.nullsAreSortedAtEnd());
    }

    @Test
    public void testGetSchema() throws Exception {
        Assertions.assertEquals((Object)STD_DATABASE_NAME, (Object)TestConnection.getMMConnection().getVDBName(), (String)"Actual schema is not equal to the expected one. ");
    }

    @Test
    public void testNativeSql() throws Exception {
        String sql = "SELECT * FROM BQT1.SmallA";
        Assertions.assertEquals((Object)sql, (Object)TestConnection.getMMConnection().nativeSQL(sql), (String)"Actual schema is not equal to the expected one. ");
    }

    @Test
    public void testGetUserName2() throws Exception {
        Assertions.assertEquals((Object)"admin", (Object)TestConnection.getMMConnection().getUserName(), (String)"Actual userName is not equal to the expected one. ");
    }

    @Test
    public void testIsReadOnly() throws Exception {
        Assertions.assertEquals((Object)false, (Object)TestConnection.getMMConnection().isReadOnly());
    }

    @Test
    public void testSetReadOnly1() throws Exception {
        ConnectionImpl conn = TestConnection.getMMConnection();
        conn.setReadOnly(true);
        Assertions.assertEquals((Object)true, (Object)conn.isReadOnly());
    }

    @Test
    public void testSetReadOnly2() throws Exception {
        ConnectionImpl conn = TestConnection.getMMConnection();
        conn.setAutoCommit(false);
        conn.setReadOnly(true);
        conn.setInLocalTxn(true);
        try {
            conn.setReadOnly(false);
            Assertions.fail((String)"Error Expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultSpec() throws Exception {
        Assertions.assertEquals((Object)"true", (Object)(TestConnection.getMMConnection().getExecutionProperties().getProperty("useJDBC4ColumnNameAndLabelSemantics") == null ? "true" : "false"));
    }

    @Test
    public void testTurnOnSpec() throws Exception {
        Assertions.assertEquals((Object)"true", (Object)TestConnection.getMMConnection(serverUrl + ";useJDBC4ColumnNameAndLabelSemantics=true").getExecutionProperties().getProperty("useJDBC4ColumnNameAndLabelSemantics"));
    }

    @Test
    public void testTurnOffSpec() throws Exception {
        Assertions.assertEquals((Object)"false", (Object)TestConnection.getMMConnection(serverUrl + ";useJDBC4ColumnNameAndLabelSemantics=false").getExecutionProperties().getProperty("useJDBC4ColumnNameAndLabelSemantics"));
    }

    @Test
    public void testCreateArray() throws SQLException {
        java.sql.Array array = TestConnection.getMMConnection().createArrayOf("integer[]", (Object[])new Integer[]{3, 4});
        Assertions.assertEquals((Object)3, (Object)Array.get(array.getArray(), 0));
    }

    @Test
    public void testXACommit() throws Exception {
        ConnectionImpl conn = TestConnection.getMMConnection();
        conn.setAutoCommit(false);
        conn.setTransactionXid((XidImpl)Mockito.mock(XidImpl.class));
        try {
            conn.setAutoCommit(true);
            Assertions.fail((String)"Error Expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxOpenStatements() throws SQLException {
        ConnectionImpl conn = TestConnection.getMMConnection();
        for (int i = 0; i < 1000; ++i) {
            conn.createStatement();
        }
        try {
            conn.createStatement();
            Assertions.fail((String)"MaxOpenStatements not limited to required number.");
        }
        catch (TeiidSQLException ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)JDBCPlugin.Event.TEIID20036.name()));
        }
    }

    static class InnerDriver
    extends TeiidDriver {
        String iurl = null;

        public InnerDriver(String url) {
            this.iurl = url;
        }

        public void parseUrl(Properties props) throws SQLException {
            TeiidDriver.parseURL((String)this.iurl, (Properties)props);
        }
    }
}

