/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.core.types.ArrayImpl;
import com.kubling.teiid.jdbc.DataTypeTransformer;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialClob;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDataTypeTransformer {
    @Test
    public void testClobToStringConversion() throws Exception {
        SerialClob clob = new SerialClob("foo".toCharArray());
        String value = DataTypeTransformer.getString((Object)clob);
        Assertions.assertEquals((Object)"foo", (Object)value);
    }

    @Test
    public void testInvalidTransformation() throws Exception {
        try {
            DataTypeTransformer.getDate((Object)1);
            Assertions.fail((String)"exception expected");
        }
        catch (SQLException e) {
            Assertions.assertEquals((Object)"Unable to transform the column value 1 to a Date.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetDefaultShort() throws Exception {
        Assertions.assertEquals((int)0, (int)DataTypeTransformer.getShort(null));
    }

    @Test
    public void testGetDefaultByte() throws Exception {
        Assertions.assertEquals((int)0, (int)DataTypeTransformer.getByte(null));
    }

    @Test
    public void testGetString() throws Exception {
        Assertions.assertEquals((Object)"", (Object)DataTypeTransformer.getString((Object)new SerialClob(new char[0])));
    }

    @Test
    public void testGetArray() throws Exception {
        Assertions.assertEquals((Object)new ArrayImpl(new Object[]{1, 2}), (Object)DataTypeTransformer.getArray((Object)new int[]{1, 2}));
    }

    @Test
    public void testGetArray1() throws Exception {
        Assertions.assertEquals((Object)new ArrayImpl(new Object[]{1, 2}), (Object)DataTypeTransformer.getArray((Object)new Integer[]{1, 2}));
    }
}

