/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.jdbc.JDBCURL;
import com.kubling.teiid.jdbc.TeiidDriver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEmbeddedProfile {
    @Test
    public void testAcceptsURL() {
        Assertions.assertFalse((JDBCURL.ConnectionType.Embedded == JDBCURL.acceptsUrl((String)"jdbc:teiid:BQT@classpath:/dqp.properties;partialResultsMode=true") ? 1 : 0) != 0);
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Embedded, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:BQT"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Embedded, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:BQT!/path/foo.properties"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Embedded, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:BQT;"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Embedded, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:BQT;version=1;logFile=foo.txt"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Embedded, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:BQT.1;version=1;logFile=foo.txt"));
    }

    @Test
    public void testParseURL() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertEquals((int)2, (int)p.size());
    }

    @Test
    public void testParseURL2() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT;version=3", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assertions.assertTrue((boolean)p.getProperty("version").equals("3"));
        Assertions.assertEquals((int)4, (int)p.size());
    }

    @Test
    public void testParseURL3() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT;version=4;autoCommitTxn=ON;partialResultsMode=YES;", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("4"));
        Assertions.assertTrue((boolean)p.getProperty("version").equals("4"));
        Assertions.assertTrue((boolean)p.getProperty("autoCommitTxn").equals("ON"));
        Assertions.assertTrue((boolean)p.getProperty("partialResultsMode").equals("YES"));
        Assertions.assertEquals((int)6, (int)p.size());
    }

    @Test
    public void testParseURL4() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT;partialResultsMode=true", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("partialResultsMode").equals("true"));
        Assertions.assertEquals((int)3, (int)p.size());
    }

    @Test
    public void testParseURL5() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
    }

    @Test
    public void testParseURL55() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT;", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
    }

    @Test
    public void testParseURL6() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT;partialResultsMode=true;version=1", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("partialResultsMode").equals("true"));
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("1"));
        Assertions.assertEquals((int)5, (int)p.size());
    }

    @Test
    public void test() throws Exception {
        try {
            Class.forName("com.kubling.teiid.jdbc.TeiidDriver");
            DriverManager.getConnection("jdbc:teiid:Parts@invalidConfig.properties;version=1");
            Assertions.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

