/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.DQP;
import com.kubling.teiid.client.ResultsMessage;
import com.kubling.teiid.client.lob.LobChunk;
import com.kubling.teiid.client.util.ResultsFuture;
import com.kubling.teiid.core.TeiidProcessingException;
import com.kubling.teiid.core.types.XMLType;
import com.kubling.teiid.jdbc.ResultSetImpl;
import com.kubling.teiid.jdbc.StatementImpl;
import com.kubling.teiid.jdbc.TestAllResultsImpl;
import java.nio.charset.Charset;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestResultSet {
    private static final int BATCH_SIZE = 400;
    public static final int PROC_BATCH_SIZE = 100;

    @Test
    public void testNext1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertEquals((Integer)0, (Integer)cs.getRow());
        cs.close();
    }

    @Test
    public void testNext2() throws SQLException {
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(1000);
        ResultSetImpl cs = this.helpExecuteQuery();
        int i = 0;
        while (cs.next()) {
            Assertions.assertEquals(expected[i], (Object)cs.getCurrentRecord());
            Assertions.assertEquals((int)((i < 800 ? 400 : 200) - i % 400 - 1), (int)cs.available());
            ++i;
        }
        cs.close();
    }

    @Test
    public void testNextBeyondEnd_fetchEqualsCount() throws Exception {
        this.helpTestNextBeyondResultSet(1000, 1000);
    }

    @Test
    public void testNextBeyondEnd_fetchLessThanCount() throws Exception {
        this.helpTestNextBeyondResultSet(100, 1000);
    }

    @Test
    public void testNextBeyondEnd_fetchLessThanCount1() throws Exception {
        this.helpTestNextBeyondResultSet(100, 101);
    }

    @Test
    public void testNextBeyondEnd_fetchLessThanCountNonMultiple() throws Exception {
        this.helpTestNextBeyondResultSet(120, 1000);
    }

    @Test
    public void testNextBeyondEnd_fetchGreaterThanCount() throws Exception {
        this.helpTestNextBeyondResultSet(300, 100);
    }

    @Test
    public void testNextBeyondEnd_fetchGreaterThanCountNonMultiple() throws Exception {
        this.helpTestNextBeyondResultSet(310, 50);
    }

    @Test
    public void testNextBeyondEnd_fetchGreaterThanCountNonMultiple2() throws Exception {
        this.helpTestNextBeyondResultSet(300, 110);
    }

    @Test
    public void testNextBeyondEnd_fetchLessThanCount_ResultsBetweenFetchAndProcBatch() throws Exception {
        this.helpTestNextBeyondResultSet(30, 75);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helpTestNextBeyondResultSet(int fetchSize, int numRows) throws Exception {
        try (ResultSetImpl cs = this.helpExecuteQuery(fetchSize, numRows, 1004);){
            Object lastRowValue = null;
            for (int rowNum = 1; rowNum <= numRows; ++rowNum) {
                Assertions.assertEquals((Object)true, (Object)cs.next(), (String)"Should return true before end cs.next()");
            }
            lastRowValue = cs.getObject(1);
            for (int i = numRows + 1; i < numRows + 4; ++i) {
                Assertions.assertEquals((Object)false, (Object)cs.next(), (String)("Should return false when going past the end: " + i));
                Assertions.assertEquals((Object)true, (Object)cs.isAfterLast(), (String)("Is after last should be true: " + i));
            }
            cs.previous();
            Assertions.assertEquals((Object)true, (Object)cs.isLast(), (String)"Is last should be true");
            Assertions.assertEquals((Object)lastRowValue, (Object)cs.getObject(1), (String)"Not on last row");
        }
    }

    @Test
    public void testBidirection() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertNotNull((Object)cs);
        cs.absolute(290);
        Assertions.assertEquals((Object)290, cs.getCurrentRecord().get(0));
        cs.next();
        Assertions.assertEquals((Object)291, cs.getCurrentRecord().get(0));
        cs.next();
        Assertions.assertEquals((Object)292, cs.getCurrentRecord().get(0));
        cs.previous();
        Assertions.assertEquals((Object)291, cs.getCurrentRecord().get(0));
        cs.next();
        Assertions.assertEquals((Object)292, cs.getCurrentRecord().get(0));
        cs.close();
    }

    @Test
    public void testHasNext1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertEquals((Object)true, (Object)cs.hasNext());
        cs.close();
    }

    @Test
    public void testHasNext2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(100);
        Assertions.assertEquals((Object)true, (Object)cs.hasNext());
        cs.close();
    }

    @Test
    public void testHasNext3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        for (int i = 0; cs.next() && i != 289; ++i) {
        }
        Assertions.assertEquals((Object)true, (Object)cs.hasNext());
        cs.close();
    }

    @Test
    public void testHasNext4() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(1000);
        Assertions.assertTrue((!cs.hasNext() ? 1 : 0) != 0);
        cs.close();
    }

    @Test
    public void testPrevious1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(1000);
        while (cs.next()) {
        }
        Assertions.assertEquals((int)0, (int)cs.getRow());
        int i = 1000;
        while (cs.previous()) {
            Assertions.assertEquals(expected[i - 1], (Object)cs.getCurrentRecord());
            --i;
        }
        Assertions.assertEquals((int)0, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testPrevious2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(290);
        Assertions.assertTrue((boolean)cs.previous());
        Assertions.assertEquals((int)289, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testPrevious3() throws Exception {
        ResultSetImpl cs = this.helpExecuteQuery(600, 10000, 1004);
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(10000);
        while (cs.next()) {
        }
        Assertions.assertEquals((int)0, (int)cs.getRow());
        int i = 10000;
        while (cs.previous()) {
            Assertions.assertEquals(expected[i - 1], (Object)cs.getCurrentRecord());
            --i;
        }
        Assertions.assertEquals((int)0, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testPrevious4() throws Exception {
        ResultSetImpl cs = this.helpExecuteQuery(50, 1000, 1004);
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(1000);
        while (cs.next()) {
        }
        Assertions.assertEquals((int)0, (int)cs.getRow());
        int i = 1000;
        while (cs.previous()) {
            Assertions.assertEquals(expected[i - 1], (Object)cs.getCurrentRecord());
            --i;
        }
        Assertions.assertEquals((int)0, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testChangeDirection() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(291);
        cs.previous();
        Assertions.assertEquals((int)290, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testIsFirst() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assertions.assertTrue((boolean)cs.isFirst());
        cs.close();
    }

    @Test
    public void testIsLast1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assertions.assertTrue((!cs.isLast() ? 1 : 0) != 0);
        cs.close();
    }

    @Test
    public void testIsLast2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        for (int i = 0; cs.next() && i != 99; ++i) {
        }
        Assertions.assertTrue((!cs.isLast() ? 1 : 0) != 0);
        cs.close();
    }

    @Test
    public void testIsLast3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(1000);
        Assertions.assertTrue((boolean)cs.isLast());
        cs.close();
    }

    @Test
    public void testIsBeforeFirst() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertTrue((boolean)cs.isBeforeFirst());
        cs.close();
    }

    @Test
    public void testBeforeFirst() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assertions.assertEquals((int)1, (int)cs.getRow());
        cs.beforeFirst();
        Assertions.assertTrue((boolean)cs.isBeforeFirst());
        cs.close();
    }

    @Test
    public void testFirst() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assertions.assertEquals((int)2, (int)cs.getRow());
        cs.first();
        Assertions.assertEquals((int)1, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testAfterLast() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.afterLast();
        Assertions.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    @Test
    public void testIsAfterLast1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(1000);
        cs.next();
        Assertions.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    @Test
    public void testIsAfterLast2() throws Exception {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertTrue((!cs.isAfterLast() ? 1 : 0) != 0);
        cs.close();
    }

    @Test
    public void testAbsolute1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assertions.assertEquals((int)2, (int)cs.getRow());
        cs.absolute(1);
        Assertions.assertEquals((int)1, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assertions.assertEquals((int)2, (int)cs.getRow());
        cs.absolute(3);
        Assertions.assertEquals((int)3, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assertions.assertEquals((int)2, (int)cs.getRow());
        cs.absolute(100);
        Assertions.assertEquals((int)100, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute4() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assertions.assertEquals((int)2, (int)cs.getRow());
        cs.absolute(200);
        Assertions.assertEquals((int)200, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute5() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assertions.assertEquals((int)2, (int)cs.getRow());
        cs.absolute(-1);
        Assertions.assertEquals((int)1000, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute6() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(1005);
        Assertions.assertEquals((int)0, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testRelative1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(3);
        Assertions.assertEquals((int)3, (int)cs.getRow());
        cs.relative(137);
        Assertions.assertEquals((int)140, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testRelative2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(137);
        Assertions.assertEquals((int)137, (int)cs.getRow());
        cs.relative(-133);
        Assertions.assertEquals((int)4, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testRelative3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(137);
        Assertions.assertEquals((int)137, (int)cs.getRow());
        cs.relative(-37);
        Assertions.assertEquals((int)100, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testRelative4() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(237);
        Assertions.assertEquals((int)237, (int)cs.getRow());
        cs.relative(-200);
        Assertions.assertEquals((int)37, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testGetRow1() throws SQLException {
        int i;
        ResultSetImpl cs = this.helpExecuteQuery();
        for (i = 0; cs.next() && i != 102; ++i) {
        }
        Assertions.assertEquals((int)(i + 1), (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testGetRow2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assertions.assertEquals((int)1, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testGetRow3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        for (int i = 0; cs.next() && i != 99; ++i) {
        }
        Assertions.assertEquals((int)100, (int)cs.getRow());
        cs.close();
    }

    @Test
    public void testGetCurrentRecord() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(103);
        Assertions.assertEquals((Object)103, cs.getCurrentRecord().get(0));
        cs.close();
    }

    @Test
    public void testClose() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertEquals((Integer)0, (Integer)cs.getRow());
        cs.close();
    }

    @Test
    public void testGetMetaData() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        List<String> columnName = this.getBQTRSMetaData1a();
        List<Integer> columnType = this.getBQTRSMetaData1b();
        List<String> columnTypeName = this.getBQTRSMetaData1c();
        ResultSetMetaData rm = cs.getMetaData();
        Assertions.assertNotNull((Object)rm);
        for (int j = 1; j <= rm.getColumnCount(); ++j) {
            Assertions.assertEquals((Object)columnName.get(j - 1), (Object)rm.getColumnLabel(j));
            Assertions.assertEquals((Integer)columnType.get(j - 1), (Integer)rm.getColumnType(j));
            Assertions.assertEquals((Object)columnTypeName.get(j - 1), (Object)rm.getColumnTypeName(j));
        }
        cs.close();
    }

    @Test
    public void testFindColumn() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        ResultSetMetaData rm = cs.getMetaData();
        Assertions.assertNotNull((Object)rm);
        Assertions.assertEquals((int)1, (int)cs.findColumn("IntKey"));
        cs.close();
    }

    @Test
    public void testFindNonExistentColumn() throws SQLException {
        ResultSetImpl rs = this.helpExecuteQuery();
        rs.next();
        try {
            rs.findColumn("BOGUS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            rs.getObject("BOGUS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rs.close();
    }

    @Test
    public void testGetStatement() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertNotNull((Object)cs.getStatement());
        cs.close();
    }

    @Test
    public void testGetPlanDescription() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertNotNull((Object)cs);
        Assertions.assertNull((Object)cs.getStatement().getPlanDescription());
        cs.close();
    }

    @Test
    public void testGetObject2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assertions.assertEquals((Object)1, (Object)cs.getObject("IntKey"));
        cs.close();
    }

    @Test
    public void testGetWarnings() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertNull((Object)cs.getWarnings());
        cs.close();
    }

    @Test
    public void testGetCursorName() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assertions.assertNull((Object)cs.getCursorName());
        cs.close();
    }

    @Test
    public void testAllGetters() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assertions.assertEquals((int)1, (int)cs.getInt("IntKey"));
        Assertions.assertEquals((Object)"1", (Object)cs.getString("IntKey"), (String)" Actual value of getString() doesn't match with expected one. ");
        Assertions.assertEquals((Float)Float.valueOf(1.0f), (Float)Float.valueOf(cs.getFloat("IntKey")));
        Assertions.assertEquals((long)1L, (long)cs.getLong("IntKey"));
        Assertions.assertEquals((Double)1.0, (Double)cs.getDouble("IntKey"));
        Assertions.assertEquals((byte)1, (byte)cs.getByte("IntKey"));
    }

    @Test
    public void testWasNull() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assertions.assertNotNull((Object)cs.getObject("IntKey"));
        Assertions.assertFalse((boolean)cs.wasNull());
    }

    @Test
    public void testForwardOnly() throws Exception {
        ResultSetImpl cs = this.helpExecuteQuery(400, 1300, 1003);
        int i = 0;
        while (cs.next()) {
            if (++i <= 1200) {
                Assertions.assertNotNull((Object)cs.getPrefetch());
            } else {
                Assertions.assertNull((Object)cs.getPrefetch());
            }
            cs.getObject(1);
        }
        Assertions.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    @Test
    public void testForwardOnlyPrefetchSmallFetchSize() throws Exception {
        StatementImpl statement = TestResultSet.createMockStatement(1003);
        ResultSetImpl cs = TestAllResultsImpl.helpTestBatching(statement, 10, 128, 256, true);
        for (int i = 0; i < 256; ++i) {
            cs.next();
            cs.getObject(1);
        }
        ((DQP)Mockito.verify((Object)statement.getDQP(), (VerificationMode)Mockito.atMost((int)1))).processCursorRequest(0L, 11, 10);
        Assertions.assertFalse((boolean)cs.next());
        Assertions.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    @Test
    public void testOutputParameter() throws Exception {
        StatementImpl statement = TestResultSet.createMockStatement(1003);
        ResultsMessage resultsMsg = new ResultsMessage();
        resultsMsg.setResults(new List[]{Arrays.asList(1, null, null), Arrays.asList(null, 2, 3)});
        resultsMsg.setLastRow(2);
        resultsMsg.setFirstRow(1);
        resultsMsg.setFinalRow(2);
        resultsMsg.setColumnNames(new String[]{"x", "out1", "out2"});
        resultsMsg.setDataTypes(new String[]{"integer", "integer", "integer"});
        ResultSetImpl cs = new ResultSetImpl(resultsMsg, statement, null, 2);
        int count = 0;
        while (cs.next()) {
            cs.getObject(1);
            ++count;
        }
        Assertions.assertEquals((int)1, (int)count);
        Assertions.assertTrue((boolean)cs.isAfterLast());
        Assertions.assertEquals((Object)2, (Object)cs.getOutputParamValue(2));
        Assertions.assertEquals((Object)3, (Object)cs.getOutputParamValue(3));
    }

    @Test
    public void testXML() throws Exception {
        StatementImpl statement = TestResultSet.createMockStatement(1003);
        ResultsFuture future = new ResultsFuture();
        future.getResultsReceiver().receiveResults((Object)new LobChunk("<a/>".getBytes(Charset.forName("UTF-8")), true));
        XMLType result = new XMLType();
        Mockito.when((Object)statement.getDQP().requestNextLobChunk(0, 0L, result.getReferenceStreamId())).thenReturn((Object)future);
        ResultsMessage resultsMsg = new ResultsMessage();
        result.setEncoding("UTF-8");
        resultsMsg.setResults(new List[]{Arrays.asList(result)});
        resultsMsg.setLastRow(1);
        resultsMsg.setFirstRow(1);
        resultsMsg.setFinalRow(1);
        resultsMsg.setColumnNames(new String[]{"x"});
        resultsMsg.setDataTypes(new String[]{"xml"});
        ResultSetImpl cs = new ResultSetImpl(resultsMsg, statement);
        cs.next();
        Assertions.assertEquals((Object)"<a/>", (Object)cs.getString(1));
    }

    private ResultSetImpl helpExecuteQuery() {
        try {
            return this.helpExecuteQuery(400, 1000, 1004);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ResultSetImpl helpExecuteQuery(int fetchSize, int totalResults, int cursorType) throws SQLException, TeiidProcessingException {
        StatementImpl statement = TestResultSet.createMockStatement(cursorType, Mockito.withSettings().stubOnly());
        return TestAllResultsImpl.helpTestBatching(statement, fetchSize, Math.min(fetchSize, totalResults), totalResults);
    }

    static StatementImpl createMockStatement(int cursorType) throws SQLException {
        return TestResultSet.createMockStatement(cursorType, Mockito.withSettings());
    }

    static StatementImpl createMockStatement(int cursorType, MockSettings mockSetting) throws SQLException {
        StatementImpl statement = (StatementImpl)Mockito.mock(StatementImpl.class, (MockSettings)mockSetting);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        Mockito.when((Object)statement.getDQP()).thenReturn((Object)dqp);
        Mockito.when((Object)statement.getResultSetType()).thenReturn((Object)cursorType);
        TimeZone tz = TimeZone.getTimeZone("GMT-06:00");
        TimeZone serverTz = TimeZone.getTimeZone("GMT-05:00");
        Mockito.when((Object)statement.getDefaultCalendar()).thenReturn((Object)Calendar.getInstance(tz));
        Mockito.when((Object)statement.getServerTimeZone()).thenReturn((Object)serverTz);
        return statement;
    }

    private List<String> getBQTRSMetaData1a() {
        ArrayList<String> results = new ArrayList<String>();
        results.add("IntKey");
        return results;
    }

    private List<Integer> getBQTRSMetaData1b() {
        ArrayList<Integer> results = new ArrayList<Integer>();
        results.add(4);
        return results;
    }

    private List<String> getBQTRSMetaData1c() {
        ArrayList<String> results = new ArrayList<String>();
        results.add("integer");
        return results;
    }
}

