/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.DQP;
import com.kubling.teiid.client.RequestMessage;
import com.kubling.teiid.client.ResultsMessage;
import com.kubling.teiid.client.util.ResultsFuture;
import com.kubling.teiid.jdbc.ConnectionImpl;
import com.kubling.teiid.jdbc.ResultSetImpl;
import com.kubling.teiid.jdbc.StatementImpl;
import com.kubling.teiid.net.ServerConnection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStatement {
    @Test
    public void testBatchExecution() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)conn.getConnectionProps()).thenReturn((Object)new Properties());
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        ResultsFuture results = new ResultsFuture();
        Mockito.when((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.any())).thenReturn((Object)results);
        ResultsMessage rm = new ResultsMessage();
        rm.setResults(new List[]{Arrays.asList(1), Arrays.asList(2)});
        rm.setUpdateResult(true);
        results.getResultsReceiver().receiveResults((Object)rm);
        Mockito.when((Object)conn.getDQP()).thenReturn((Object)dqp);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        statement.clearBatch();
        statement.addBatch("delete from table");
        statement.addBatch("delete from table1");
        Assertions.assertTrue((boolean)Arrays.equals(new int[]{1, 2}, statement.executeBatch()));
    }

    @Test
    public void testWarnings() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)conn.getConnectionProps()).thenReturn((Object)new Properties());
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        ResultsFuture results = new ResultsFuture();
        Mockito.when((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.any())).thenReturn((Object)results);
        ResultsMessage rm = new ResultsMessage();
        rm.setResults(new List[]{Arrays.asList(1)});
        rm.setWarnings(Arrays.asList(new Throwable()));
        rm.setColumnNames(new String[]{"expr1"});
        rm.setDataTypes(new String[]{"string"});
        results.getResultsReceiver().receiveResults((Object)rm);
        Mockito.when((Object)conn.getDQP()).thenReturn((Object)dqp);
        StatementImpl statement = new StatementImpl(this, conn, 1003, 1007){

            protected TimeZone getServerTimeZone() throws SQLException {
                return null;
            }
        };
        statement.execute("select 'a'");
        Assertions.assertNotNull((Object)statement.getResultSet());
        SQLWarning warning = statement.getWarnings();
        Assertions.assertNotNull((Object)warning);
        Assertions.assertNull((Object)warning.getNextWarning());
    }

    @Test
    public void testGetMoreResults() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)conn.getConnectionProps()).thenReturn((Object)new Properties());
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        ResultsFuture results = new ResultsFuture();
        Mockito.when((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.any())).thenReturn((Object)results);
        ResultsMessage rm = new ResultsMessage();
        rm.setUpdateResult(true);
        rm.setColumnNames(new String[]{"expr1"});
        rm.setDataTypes(new String[]{"integer"});
        rm.setResults(new List[]{Arrays.asList(1)});
        results.getResultsReceiver().receiveResults((Object)rm);
        Mockito.when((Object)conn.getDQP()).thenReturn((Object)dqp);
        StatementImpl statement = new StatementImpl(this, conn, 1003, 1007){

            protected TimeZone getServerTimeZone() throws SQLException {
                return null;
            }
        };
        statement.execute("update x set a = b");
        Assertions.assertEquals((int)1, (int)statement.getUpdateCount());
        statement.getMoreResults(3);
        Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
        statement = new StatementImpl(this, conn, 1003, 1007){

            protected TimeZone getServerTimeZone() throws SQLException {
                return null;
            }
        };
        statement.execute("update x set a = b");
        Assertions.assertEquals((int)1, (int)statement.getUpdateCount());
        statement.getMoreResults();
        Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
    }

    @Test
    public void testSetStatement() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assertions.assertFalse((boolean)statement.execute("set foo bar"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setExecutionProperty("foo", "bar");
        Assertions.assertFalse((boolean)statement.execute("set foo 'b''ar' ; "));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setExecutionProperty("foo", "b'ar");
        Assertions.assertFalse((boolean)statement.execute("set \"foo\" 'b''a1r' ; "));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setExecutionProperty("foo", "b'a1r");
        Assertions.assertFalse((boolean)statement.execute("set \"foo\" = 'bar'; "));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setExecutionProperty("foo", "bar");
    }

    @Test
    public void testSetPayloadStatement() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        Mockito.when((Object)conn.getExecutionProperties()).thenReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assertions.assertFalse((boolean)statement.execute("set payload foo bar"));
    }

    @Test
    public void testSetAuthorizationStatement() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        Mockito.when((Object)conn.getExecutionProperties()).thenReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assertions.assertFalse((boolean)statement.execute("set session authorization bar"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).changeUser("bar", null);
    }

    @Test
    public void testPropertiesOverride() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        p.setProperty("ansiQuotedIdentifiers", Boolean.TRUE.toString());
        Mockito.when((Object)conn.getExecutionProperties()).thenReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)statement.getExecutionProperty("ansiQuotedIdentifiers"));
        statement.setExecutionProperty("ansiQuotedIdentifiers", Boolean.FALSE.toString());
        Assertions.assertEquals((Object)Boolean.FALSE.toString(), (Object)statement.getExecutionProperty("ansiQuotedIdentifiers"));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)p.getProperty("ansiQuotedIdentifiers"));
    }

    @Test
    public void testTransactionStatements() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        Mockito.when((Object)conn.getExecutionProperties()).thenReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assertions.assertFalse((boolean)statement.execute("start transaction"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setAutoCommit(false);
        Assertions.assertFalse((boolean)statement.execute("commit"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setAutoCommit(true);
        Assertions.assertFalse((boolean)statement.execute("start transaction"));
        Assertions.assertFalse((boolean)statement.execute("rollback"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).rollback(false);
        Assertions.assertFalse((boolean)statement.execute("abort transaction"));
        ((ConnectionImpl)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).rollback(false);
        Assertions.assertFalse((boolean)statement.execute("rollback work"));
        ((ConnectionImpl)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)3))).rollback(false);
        Assertions.assertFalse((boolean)statement.execute("start transaction isolation level repeatable read"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setTransactionIsolation(4);
    }

    @Test
    public void testDisableLocalTransations() throws Exception {
        ServerConnection mock = (ServerConnection)Mockito.mock(ServerConnection.class);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        Mockito.when((Object)((DQP)mock.getService(DQP.class))).thenReturn((Object)dqp);
        ConnectionImpl conn = new ConnectionImpl(mock, new Properties(), "x");
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assertions.assertTrue((boolean)conn.getAutoCommit());
        statement.execute("set disablelocaltxn true");
        Assertions.assertFalse((boolean)statement.execute("start transaction"));
        conn.beginLocalTxnIfNeeded();
        Assertions.assertFalse((boolean)conn.isInLocalTxn());
        statement.execute("set disablelocaltxn false");
        Assertions.assertFalse((boolean)statement.execute("start transaction"));
        conn.beginLocalTxnIfNeeded();
        Assertions.assertTrue((boolean)conn.isInLocalTxn());
    }

    @Test
    public void testTransactionStatementsAsynch() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)conn.submitSetAutoCommitTrue(Mockito.anyBoolean())).thenReturn((Object)ResultsFuture.NULL_FUTURE);
        Properties p = new Properties();
        Mockito.when((Object)conn.getExecutionProperties()).thenReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        statement.submitExecute("start transaction", null);
        ((ConnectionImpl)Mockito.verify((Object)conn)).setAutoCommit(false);
        statement.submitExecute("commit", null);
        ((ConnectionImpl)Mockito.verify((Object)conn)).submitSetAutoCommitTrue(true);
        statement.submitExecute("start transaction", null);
        statement.submitExecute("rollback", null);
        ((ConnectionImpl)Mockito.verify((Object)conn)).submitSetAutoCommitTrue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsynchTimeout() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)conn.getConnectionProps()).thenReturn((Object)new Properties());
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        statement.setQueryTimeoutMS(1);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        Mockito.when((Object)statement.getDQP()).thenReturn((Object)dqp);
        AtomicInteger counter = new AtomicInteger();
        Mockito.when((Object)dqp.cancelRequest(0L)).then(invocation -> {
            StatementImpl statementImpl = statement;
            synchronized (statementImpl) {
                counter.incrementAndGet();
                statement.notifyAll();
            }
            return true;
        });
        ResultsFuture future = new ResultsFuture();
        Mockito.when((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.any())).thenReturn((Object)future);
        statement.submitExecute("select 'hello world'", null);
        StatementImpl statementImpl = statement;
        synchronized (statementImpl) {
            while (counter.get() != 1) {
                statement.wait();
            }
        }
        statement.setQueryTimeoutMS(1);
        statement.submitExecute("select 'hello world'", null);
        statementImpl = statement;
        synchronized (statementImpl) {
            while (counter.get() != 2) {
                statement.wait();
            }
        }
    }

    @Test
    public void testTimeoutProperty() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        p.setProperty("QUERYTIMEOUT", "2");
        Mockito.when((Object)conn.getExecutionProperties()).thenReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assertions.assertEquals((int)2, (int)statement.getQueryTimeout());
    }

    @Test
    public void testUseJDBC4ColumnNameAndLabelSemantics() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        p.setProperty("useJDBC4ColumnNameAndLabelSemantics", "false");
        Mockito.when((Object)conn.getExecutionProperties()).thenReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assertions.assertEquals((Object)Boolean.FALSE.toString(), (Object)statement.getExecutionProperty("useJDBC4ColumnNameAndLabelSemantics"));
    }

    @Test
    public void testSet() {
        Matcher m = StatementImpl.SET_STATEMENT.matcher("set foo to 1");
        Assertions.assertTrue((boolean)m.matches());
    }

    @Test
    public void testQuotedSet() {
        Matcher m = StatementImpl.SET_STATEMENT.matcher("set \"foo\"\"\" to 1");
        Assertions.assertTrue((boolean)m.matches());
        Assertions.assertEquals((Object)"\"foo\"\"\"", (Object)m.group(2));
        m = StatementImpl.SHOW_STATEMENT.matcher("show \"foo\"");
        Assertions.assertTrue((boolean)m.matches());
    }

    @Test
    public void testSetTxnIsolationLevel() throws SQLException {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assertions.assertFalse((boolean)statement.execute("set session characteristics as transaction isolation level read committed"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setTransactionIsolation(2);
        Assertions.assertFalse((boolean)statement.execute("set session characteristics as transaction isolation level read uncommitted"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setTransactionIsolation(1);
        Assertions.assertFalse((boolean)statement.execute("set session characteristics as transaction isolation level serializable"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setTransactionIsolation(8);
        Assertions.assertFalse((boolean)statement.execute("set session characteristics as transaction isolation level repeatable read"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setTransactionIsolation(4);
    }

    @Test
    public void testShowTxnIsolationLevel() throws SQLException {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        StatementImpl statement = new StatementImpl(this, conn, 1003, 1007){

            protected TimeZone getServerTimeZone() throws SQLException {
                return TimeZone.getDefault();
            }
        };
        Mockito.when((Object)conn.getTransactionIsolation()).thenReturn((Object)2);
        Assertions.assertTrue((boolean)statement.execute("show transaction isolation level"));
        ResultSetImpl rs = statement.getResultSet();
        rs.next();
        Assertions.assertEquals((Object)"READ COMMITTED", (Object)rs.getString(1));
        Assertions.assertFalse((boolean)rs.next());
    }
}

