/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.jdbc.WrapperImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.sql.Wrapper;
import org.junit.jupiter.api.Assertions;

public class TestWrapperImpl {
    public void testProxy() throws SQLException {
        FooImpl fooImpl = new FooImpl();
        Foo proxy = (Foo)Proxy.newProxyInstance(TestWrapperImpl.class.getClassLoader(), new Class[]{Foo.class}, (arg0, arg1, arg2) -> {
            if (arg1.getName().equals("callMe")) {
                return null;
            }
            try {
                return arg1.invoke((Object)fooImpl, arg2);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        });
        proxy.callMe();
        Assertions.assertFalse((boolean)fooImpl.wasCalled);
        proxy.unwrap(Foo.class).callMe();
        Assertions.assertTrue((boolean)fooImpl.wasCalled);
        try {
            proxy.unwrap(String.class);
            Assertions.fail((String)"expected exception");
        }
        catch (SQLException e) {
            Assertions.assertEquals((Object)"Wrapped object is not an instance of class java.lang.String", (Object)e.getMessage());
        }
    }

    static class FooImpl
    extends WrapperImpl
    implements Foo {
        boolean wasCalled;

        FooImpl() {
        }

        @Override
        public void callMe() {
            this.wasCalled = true;
        }
    }

    static interface Foo
    extends Wrapper {
        public void callMe();
    }
}

