/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc.tracing;

import com.kubling.teiid.jdbc.tracing.GlobalTracerInjector;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTracing {
    private InMemorySpanExporter exporter;
    private SdkTracerProvider provider;
    private Tracer tracer;

    @BeforeEach
    void setUp() {
        this.exporter = InMemorySpanExporter.create();
        this.provider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)this.exporter)).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(this.provider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).build();
        GlobalOpenTelemetry.resetForTest();
        GlobalOpenTelemetry.set((OpenTelemetry)openTelemetry);
        this.tracer = openTelemetry.getTracer("com.kubling.test");
    }

    @AfterEach
    void tearDown() {
        this.provider.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSpanContextInjection() {
        Assertions.assertNull((Object)GlobalTracerInjector.getSpanContext((Tracer)this.tracer));
        Span span = this.tracer.spanBuilder("x").startSpan();
        try (Scope ignored = span.makeCurrent();){
            String json = GlobalTracerInjector.getSpanContext((Tracer)this.tracer);
            Assertions.assertNotNull((Object)json);
            Assertions.assertTrue((boolean)json.contains("traceparent"), (String)"Expected W3C trace context key");
        }
        finally {
            span.end();
        }
        List finishedSpans = this.exporter.getFinishedSpanItems();
        Assertions.assertEquals((int)1, (int)finishedSpans.size());
    }
}

