/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.net;

import com.kubling.teiid.net.HostInfo;
import com.kubling.teiid.net.TeiidURL;
import java.net.MalformedURLException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTeiidURL {
    @Test
    public final void testTeiidURL() throws Exception {
        String SERVER_URL = "mm://localhost:31000";
        Assertions.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assertions.assertNotNull((Object)hosts, (String)"MMURL should have 1 Host");
        Assertions.assertEquals((int)1, (int)hosts.size());
    }

    @Test
    public final void testTeiidURLIPv6() throws Exception {
        String SERVER_URL = "mm://[3ffe:ffff:0100:f101::1]:31000";
        Assertions.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assertions.assertNotNull((Object)hosts, (String)"TeiidURL should have 1 Host");
        Assertions.assertEquals((int)1, (int)hosts.size());
        Assertions.assertEquals((Object)"3ffe:ffff:0100:f101::1", (Object)((HostInfo)hosts.get(0)).getHostName());
        Assertions.assertEquals((int)31000, (int)((HostInfo)hosts.get(0)).getPortNumber());
    }

    @Test
    public final void testBogusProtocol() throws Exception {
        String SERVER_URL = "foo://localhost:31000";
        Assertions.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testBogusProtocol1() {
        String SERVER_URL = "foo://localhost:31000";
        Assertions.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURLSecure() throws Exception {
        String SERVER_URL = "mms://localhost:31000";
        Assertions.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assertions.assertNotNull((Object)hosts, (String)"MMURL should have 1 Host");
        Assertions.assertEquals((int)1, (int)hosts.size());
    }

    @Test
    public final void testTeiidURLBadProtocolMM() {
        String SERVER_URL = "mmm://localhost:31000";
        Assertions.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURLWrongSlash() {
        String SERVER_URL = "mm:\\\\localhost:31000";
        Assertions.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURLOneSlash() {
        String SERVER_URL = "mm:/localhost:31000";
        Assertions.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURLNoHost() throws Exception {
        String SERVER_URL = "mm://:31000";
        Assertions.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        Assertions.assertThrows(MalformedURLException.class, () -> new TeiidURL(SERVER_URL));
    }

    @Test
    public final void testTeiidURLNoHostAndPort() throws Exception {
        String SERVER_URL = "mm://:";
        Assertions.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        Assertions.assertThrows(MalformedURLException.class, () -> new TeiidURL(SERVER_URL));
    }

    @Test
    public final void testTeiidURLNoHostAndPort2() {
        String SERVER_URL = "mm://";
        Assertions.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURLBadPort() {
        String SERVER_URL = "mm://localhost:port";
        Assertions.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURL2Hosts() throws Exception {
        String SERVER_URL = "mm://localhost:31000,localhost:31001";
        Assertions.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assertions.assertNotNull((Object)hosts, (String)"MMURL should have 2 Host");
        Assertions.assertEquals((int)2, (int)hosts.size());
    }

    @Test
    public final void testTeiidIPv6URL2Hosts() throws Exception {
        String SERVER_URL = "mm://[3ffe:ffff:0100:f101::1]:31000,[::1]:31001, 127.0.0.1:31003";
        Assertions.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assertions.assertNotNull((Object)hosts, (String)"TeiidURL should have 3 Host");
        Assertions.assertEquals((int)3, (int)hosts.size());
        Assertions.assertEquals((Object)"3ffe:ffff:0100:f101::1", (Object)((HostInfo)hosts.get(0)).getHostName());
        Assertions.assertEquals((int)31001, (int)((HostInfo)hosts.get(1)).getPortNumber());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)((HostInfo)hosts.get(2)).getHostName());
    }

    @Test
    public final void testTeiidURL3Hosts() throws Exception {
        String SERVER_URL = "mm://localhost:31000,localhost:31001,localhost:31002";
        Assertions.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assertions.assertNotNull((Object)hosts, (String)"MMURL should have 3 Host");
        Assertions.assertEquals((int)3, (int)hosts.size());
    }

    @Test
    public final void testGetHostInfo() throws Exception {
        String SERVER_URL = "mm://localhost:31000";
        Assertions.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        Assertions.assertNotNull((Object)url.getHostInfo());
    }

    @Test
    public final void testGetProtocolStandalone() throws Exception {
        TeiidURL url = new TeiidURL("mm://localhost:31000");
        Assertions.assertNotNull((Object)url);
        Assertions.assertEquals((Object)"mm://localhost:31000", (Object)url.getAppServerURL());
    }

    @Test
    public final void testHasMoreElements() throws Exception {
        TeiidURL url = new TeiidURL("mm://localhost:31000,localhost:31001");
        Assertions.assertNotNull((Object)url);
        Assertions.assertFalse((boolean)url.getHostInfo().isEmpty());
    }

    @Test
    public final void testNextElement() throws Exception {
        TeiidURL url = new TeiidURL("mm://localhost:31000,localhost:31001");
        Assertions.assertEquals((int)2, (int)url.getHostInfo().size());
    }

    @Test
    public final void testHostInfoEquals() throws Exception {
        HostInfo expectedResults = new HostInfo("localhost", 31000);
        TeiidURL url = new TeiidURL("mm://localhost:31000");
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        Assertions.assertEquals((Object)expectedResults, (Object)actualResults);
    }

    @Test
    public final void testWithEmbeddedSpaces() throws Exception {
        HostInfo expectedResults = new HostInfo("localhost", 12345);
        TeiidURL url = new TeiidURL("mm://localhost : 12345");
        List hosts = url.getHostInfo();
        Assertions.assertNotNull((Object)hosts, (String)"MMURL should have 1 Host");
        Assertions.assertEquals((int)1, (int)hosts.size());
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        Assertions.assertEquals((Object)expectedResults, (Object)actualResults);
    }

    @Test
    public final void testHostPortConstructor() {
        HostInfo expectedResults = new HostInfo("myhost", 12345);
        TeiidURL url = new TeiidURL("myhost", 12345, false);
        List hosts = url.getHostInfo();
        Assertions.assertNotNull((Object)hosts, (String)"MMURL should have 1 Host");
        Assertions.assertEquals((int)1, (int)hosts.size());
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        Assertions.assertEquals((Object)expectedResults, (Object)actualResults);
        Assertions.assertEquals((Object)"mm://myhost:12345", (Object)url.getAppServerURL());
    }

    @Test
    public final void testHostPortConstructorSSL() {
        HostInfo expectedResults = new HostInfo("myhost", 12345);
        TeiidURL url = new TeiidURL("myhost", 12345, true);
        List hosts = url.getHostInfo();
        Assertions.assertNotNull((Object)hosts, (String)"MMURL should have 1 Host");
        Assertions.assertEquals((int)1, (int)hosts.size());
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        Assertions.assertEquals((Object)expectedResults, (Object)actualResults);
        Assertions.assertEquals((Object)"mms://myhost:12345", (Object)url.getAppServerURL());
    }
}

