/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.net.socket;

import com.kubling.teiid.client.DQP;
import com.kubling.teiid.client.security.InvalidSessionException;
import com.kubling.teiid.client.util.ExceptionUtil;
import com.kubling.teiid.client.xa.XATransactionException;
import com.kubling.teiid.core.TeiidComponentException;
import com.kubling.teiid.core.TeiidRuntimeException;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSocketServiceRegistry {
    @Test
    public void testExceptionConversionNoException() throws Exception {
        Method m = Foo.class.getMethod("somemethod", new Class[0]);
        Throwable t = ExceptionUtil.convertException((Method)m, (Throwable)new TeiidComponentException());
        Assertions.assertTrue((boolean)(t instanceof TeiidRuntimeException));
    }

    @Test
    public void testComponentExceptionConversion() throws Exception {
        Method m = DQP.class.getMethod("getMetadata", Long.TYPE);
        Throwable t = ExceptionUtil.convertException((Method)m, (Throwable)new NullPointerException());
        Assertions.assertTrue((boolean)(t instanceof TeiidComponentException));
    }

    @Test
    public void testXATransactionExceptionConversion() throws Exception {
        Method m = DQP.class.getMethod("recover", Integer.TYPE);
        Throwable t = ExceptionUtil.convertException((Method)m, (Throwable)new TeiidComponentException());
        Assertions.assertTrue((boolean)(t instanceof XATransactionException));
    }

    @Test
    public void testSubclass() throws Exception {
        Method m = DQP.class.getMethod("getMetadata", Long.TYPE);
        Throwable t = ExceptionUtil.convertException((Method)m, (Throwable)new InvalidSessionException());
        Assertions.assertTrue((boolean)(t instanceof InvalidSessionException));
    }

    static interface Foo {
        public void somemethod();
    }
}

