/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client.util;

import com.kubling.teiid.client.SourceWarning;
import com.kubling.teiid.client.xa.XATransactionException;
import com.kubling.teiid.core.TeiidComponentException;
import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.core.TeiidRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ExceptionUtil {
    public static <T extends Throwable> T getExceptionOfType(Throwable ex, Class<T> cls) {
        while (ex != null) {
            if (cls.isAssignableFrom(ex.getClass())) {
                return (T)((Throwable)cls.cast(ex));
            }
            if (ex.getCause() == ex) break;
            ex = ex.getCause();
        }
        return null;
    }

    public static Throwable convertException(Method method, Throwable exception) {
        Class<?>[] exceptionClasses;
        boolean canThrowXATransactionException = false;
        boolean canThrowComponentException = false;
        for (Class<?> exceptionClass : exceptionClasses = method.getExceptionTypes()) {
            if (exceptionClass.isAssignableFrom(exception.getClass())) {
                return exception;
            }
            if (!canThrowComponentException) {
                canThrowComponentException = TeiidComponentException.class.isAssignableFrom(exceptionClass);
            }
            if (canThrowXATransactionException) continue;
            canThrowXATransactionException = XATransactionException.class.isAssignableFrom(exceptionClass);
        }
        if (canThrowComponentException) {
            return new TeiidComponentException(exception);
        }
        if (canThrowXATransactionException) {
            return new XATransactionException(exception);
        }
        if (RuntimeException.class.isAssignableFrom(exception.getClass())) {
            return exception;
        }
        return new TeiidRuntimeException(exception);
    }

    public static Throwable sanitize(Throwable t, boolean preserveStack) {
        String code = t instanceof TeiidException ? ((TeiidException)t).getCode() : (t instanceof TeiidRuntimeException ? ((TeiidRuntimeException)t).getCode() : t.getClass().getName());
        Throwable child = null;
        if (t.getCause() != null && t.getCause() != t) {
            child = ExceptionUtil.sanitize(t.getCause(), preserveStack);
        }
        Throwable result = null;
        for (Class<?> clazz = t.getClass(); clazz != null && clazz != Throwable.class && clazz != Exception.class; clazz = clazz.getSuperclass()) {
            try {
                Constructor<?> ctor = clazz.getDeclaredConstructor(String.class);
                result = (Throwable)ctor.newInstance(code);
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        if (result == null) {
            result = new TeiidException(code);
        }
        if (result instanceof TeiidException) {
            result.setCode(code);
        } else if (result instanceof TeiidRuntimeException) {
            result.setCode(code);
        }
        if (child != null) {
            result.initCause(child);
        }
        if (preserveStack) {
            result.setStackTrace(t.getStackTrace());
        } else {
            result.setStackTrace(SourceWarning.EMPTY_STACK_TRACE);
        }
        return result;
    }
}

