/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client.xa;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Externalizable {
    private static final long serialVersionUID = -7078441828703404308L;
    private int formatID;
    private byte[] globalTransactionId;
    private byte[] branchQualifier;
    private String toString;

    public XidImpl() {
    }

    public XidImpl(Xid xid) {
        this.formatID = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
    }

    public XidImpl(int formatID, byte[] globalTransactionId, byte[] branchQualifier) {
        this.formatID = formatID;
        this.globalTransactionId = globalTransactionId;
        this.branchQualifier = branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this.formatID;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XidImpl)) {
            return false;
        }
        XidImpl that = (XidImpl)obj;
        return this.formatID == that.formatID && Arrays.equals(this.globalTransactionId, that.globalTransactionId) && Arrays.equals(this.branchQualifier, that.branchQualifier);
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "Teiid-Xid global:" + XidImpl.getByteArrayString(this.globalTransactionId) + " branch:" + XidImpl.getByteArrayString(this.branchQualifier) + " format:" + this.getFormatId();
        }
        return this.toString;
    }

    static String getByteArrayString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new BigInteger(bytes).toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.formatID = in.readInt();
        this.globalTransactionId = (byte[])in.readObject();
        this.branchQualifier = (byte[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.formatID);
        out.writeObject(this.globalTransactionId);
        out.writeObject(this.branchQualifier);
    }
}

