/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BatchResults {
    static final int DEFAULT_SAVED_BATCHES = 3;
    private final ArrayList<Batch> batches = new ArrayList();
    private int currentRowNumber;
    private List<?> currentRow;
    private int lastRowNumber = -1;
    private int highestRowNumber;
    private BatchFetcher batchFetcher;
    private final int savedBatches;
    private boolean tailLast;

    public BatchResults(BatchFetcher batchFetcher, Batch batch, int savedBatches) {
        this.batchFetcher = batchFetcher;
        this.savedBatches = savedBatches;
        this.setBatch(batch);
    }

    public List<?> getCurrentRow() throws SQLException {
        if (this.currentRow != null) {
            return this.currentRow;
        }
        if (this.currentRowNumber == 0 || this.lastRowNumber != -1 && this.currentRowNumber > this.lastRowNumber) {
            return null;
        }
        for (int i = 0; i < this.batches.size(); ++i) {
            Batch batch = this.batches.get(i);
            if (this.currentRowNumber < batch.getBeginRow() || this.currentRowNumber > batch.getEndRow()) continue;
            if (i != 0) {
                this.batches.addFirst(this.batches.remove(i));
            }
            this.setCurrentRow(batch);
            return this.currentRow;
        }
        this.requestBatchAndWait(this.currentRowNumber);
        Batch batch = this.batches.getFirst();
        this.setCurrentRow(batch);
        return this.currentRow;
    }

    private void setCurrentRow(Batch batch) {
        this.currentRow = batch.getRow(this.currentRowNumber);
        if (batch.isLast() && batch.getEndRow() == this.currentRowNumber) {
            this.currentRow = null;
        }
    }

    private void requestNextBatch() throws SQLException {
        this.requestBatchAndWait(this.highestRowNumber + 1);
    }

    public boolean next() throws SQLException {
        if (this.hasNext()) {
            this.setCurrentRowNumber(this.currentRowNumber + 1);
            this.getCurrentRow();
            return true;
        }
        if (this.currentRowNumber == this.highestRowNumber) {
            this.setCurrentRowNumber(this.currentRowNumber + 1);
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.currentRowNumber != 0 && this.currentRowNumber != 1;
    }

    public boolean previous() {
        if (this.hasPrevious()) {
            this.setCurrentRowNumber(this.currentRowNumber - 1);
            return true;
        }
        if (this.currentRowNumber == 1) {
            this.setCurrentRowNumber(0);
        }
        return false;
    }

    public void setBatchFetcher(BatchFetcher batchFetcher) {
        this.batchFetcher = batchFetcher;
    }

    public boolean absolute(int row) throws SQLException {
        return this.absolute(row, 0);
    }

    public boolean absolute(int row, int offset) throws SQLException {
        int positiveRow;
        if (row == 0) {
            this.setCurrentRowNumber(0);
            return false;
        }
        if (row > 0) {
            if (row + offset > this.highestRowNumber && this.lastRowNumber == -1) {
                this.requestBatchAndWait(row + offset);
            }
            if (row + offset <= this.highestRowNumber) {
                this.setCurrentRowNumber(row);
                return true;
            }
            this.setCurrentRowNumber(this.lastRowNumber + 1 - offset);
            return false;
        }
        row -= offset;
        if (this.lastRowNumber == -1) {
            this.requestBatchAndWait(Integer.MAX_VALUE);
        }
        if ((positiveRow = this.lastRowNumber + row + 1) <= 0) {
            this.setCurrentRowNumber(0);
            return false;
        }
        this.setCurrentRowNumber(positiveRow);
        return true;
    }

    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    private void requestBatchAndWait(int beginRow) throws SQLException {
        this.setBatch(this.batchFetcher.requestBatch(beginRow));
    }

    void setBatch(Batch batch) {
        if (this.batches.size() == this.savedBatches) {
            this.batches.remove(this.savedBatches - 1);
        }
        if (batch.getLastRow() != -1) {
            this.lastRowNumber = batch.getLastRow();
            this.highestRowNumber = batch.getLastRow();
        } else {
            this.highestRowNumber = Math.max(batch.getEndRow(), this.highestRowNumber);
            this.tailLast = batch.isLast();
        }
        this.batches.addFirst(batch);
    }

    public boolean hasNext() throws SQLException {
        return this.hasNext(1, true);
    }

    public Boolean hasNext(int next, boolean wait) throws SQLException {
        boolean result;
        while (this.currentRowNumber + next > this.highestRowNumber && this.lastRowNumber == -1) {
            if (!wait) {
                return null;
            }
            this.requestNextBatch();
        }
        boolean bl = result = this.currentRowNumber + next <= this.highestRowNumber;
        if (result && !wait) {
            for (Batch batch : this.batches) {
                if (this.currentRowNumber + next < batch.getBeginRow() || this.currentRowNumber + next > batch.getEndRow()) continue;
                return Boolean.TRUE;
            }
            return null;
        }
        return result;
    }

    public int getFinalRowNumber() {
        return this.lastRowNumber;
    }

    public int getHighestRowNumber() {
        return this.highestRowNumber;
    }

    private void setCurrentRowNumber(int currentRowNumber) {
        if (currentRowNumber != this.currentRowNumber) {
            this.currentRow = null;
        }
        this.currentRowNumber = currentRowNumber;
    }

    public boolean isTailLast() {
        return this.tailLast;
    }

    public static interface BatchFetcher {
        public Batch requestBatch(int var1) throws SQLException;
    }

    static class Batch {
        private final List<?>[] batch;
        private final int beginRow;
        private final int endRow;
        private boolean isLast;
        private int lastRow = -1;

        Batch(List<?>[] batch, int beginRow, int endRow) {
            this.batch = batch;
            this.beginRow = beginRow;
            this.endRow = this.beginRow + this.batch.length - 1;
            if (endRow != this.endRow) {
                this.isLast = true;
            }
        }

        int getLastRow() {
            return this.lastRow;
        }

        void setLastRow(int lastRow) {
            this.lastRow = lastRow;
        }

        int getLength() {
            return this.batch.length;
        }

        List<?> getRow(int index) {
            return this.batch[index - this.beginRow];
        }

        int getBeginRow() {
            return this.beginRow;
        }

        int getEndRow() {
            return this.endRow;
        }

        boolean isLast() {
            return this.isLast;
        }
    }
}

