/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.metadata.ResultsMetadataConstants;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.JDBCSQLTypeInfo;
import com.kubling.teiid.core.util.PropertiesUtils;
import com.kubling.teiid.core.util.SqlUtil;
import com.kubling.teiid.core.util.StringUtil;
import com.kubling.teiid.jdbc.ConnectionImpl;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.jdbc.MetadataProvider;
import com.kubling.teiid.jdbc.PreparedStatementImpl;
import com.kubling.teiid.jdbc.ResultSetImpl;
import com.kubling.teiid.jdbc.ResultSetMetaDataImpl;
import com.kubling.teiid.jdbc.StatementImpl;
import com.kubling.teiid.jdbc.TeiidDriver;
import com.kubling.teiid.jdbc.TeiidSQLException;
import com.kubling.teiid.jdbc.WrapperImpl;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class DatabaseMetaDataImpl
extends WrapperImpl
implements DatabaseMetaData {
    public static final String REPORT_AS_VIEWS = "reportAsViews";
    public static final String NULL_SORT = "nullsAreSorted";
    private static final String IS_NULLABLE = "CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE";
    private static final String DATA_TYPES = "DataTypes";
    private static final Logger logger = Logger.getLogger("org.teiid.jdbc");
    private static final String PERCENT = "%";
    private static final int NO_LIMIT = 0;
    private static final String SCHEMA_TERM = "Schema";
    private static final String ESCAPE_SEARCH_STRING = "\\";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String EXTRA_CHARS = ".@";
    static final String KEY_WORDS = "OPTION, BIGDECIMAL, BIGDECIMAL, BIGINTEGER, BREAK, BYTE, CRITERIA, ERROR, LIMIT, LONG, LOOP, MAKEDEP, MAKENOTDEP, NOCACHE, STRING, VIRTUAL, WHILE";
    private static final String PROCEDURE_TERM = "StoredProcedure";
    static final String NUMERIC_FUNCTIONS = "ABS, ACOS, ASIN, ATAN, ATAN2, BITAND, BITNOT, BITOR, BITXOR, CEILING, COS, COT, DEGREES, EXP, FLOOR, FORMATBIGDECIMAL, FORMATBIGINTEGER, FORMATDOUBLE, FORMATFLOAT, FORMATINTEGER, FORMATLONG, LOG, LOG10, MOD, PARSEBIGDECIMAL, PARSEBIGINTEGER, PARSEDOUBLE, PARSEFLOAT, PARSEINTEGER, PARSELONG, PI, POWER, RADIANS, RAND, ROUND, SIGN, SIN, SQRT, TAN";
    static final String STRING_FUNCTIONS = "ASCII, CHR, CHAR, CONCAT, CONCAT2, INITCAP, INSERT, LCASE, LEFT, LENGTH, LOCATE, LOWER, LPAD, LTRIM, REPEAT, REPLACE, RIGHT, RPAD, RTRIM, SUBSTRING, TRANSLATE, UCASE, UPPER";
    static final String DATE_FUNCTIONS = "CURDATE, CURTIME, NOW, DAYNAME, DAYOFMONTH, DAYOFWEEK, DAYOFYEAR, FORMATDATE, FORMATTIME, FORMATTIMESTAMP, FROM_UNIXTIME, HOUR, MINUTE, MONTH, MONTHNAME, PARSEDATE, PARSETIME, PARSETIMESTAMP, QUARTER, SECOND, TIMESTAMPADD, TIMESTAMPDIFF, WEEK, YEAR";
    static final String SYSTEM_FUNCTIONS = "CAST, COALESCE, CONVERT, DECODESTRING, DECODEINTEGER, IFNULL, NULLIF, NVL, LOOKUP, UUID, UNESCAPE, ARRAY_GET, ARRAY_LENGTH";
    private static final int MAX_CATALOG_NAME_LENGTH = 255;
    private static final int MAX_PROCEDURE_NAME_LENGTH = 255;
    private static final int MAX_TABLE_NAME_LENGTH = 255;
    private static final int MAX_COLUMN_NAME_LENGTH = 255;
    private static final int MAX_USER_NAME_LENGTH = 255;
    private static final String LIKE_ESCAPE = " LIKE ? ESCAPE '\\' ";
    private static final String NULLABILITY_MAPPING = "No Nulls, 0, Nullable, 1, Unknown, 2";
    private static final String TYPE_NULLABILITY_MAPPING = "No Nulls, 0, Nullable, 1, Unknown, 2";
    private static final String PROC_COLUMN_NULLABILITY_MAPPING = "No Nulls, 0, Nullable, 1, Unknown, 2";
    private static final String PARAM_DIRECTION_MAPPING = "In,1, Out,4, InOut,2, ReturnValue,5, ResultSet,3";
    private static final String QUERY_REFERENCE_KEYS = "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYS.ReferenceKeyColumns";
    private static final String QUERY_CROSS_REFERENCES = "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYS.ReferenceKeyColumns WHERE UCASE(PKTABLE_CAT) LIKE ? ESCAPE '\\' AND UCASE(FKTABLE_CAT) LIKE ? ESCAPE '\\'  AND UCASE(PKTABLE_SCHEM) LIKE ? ESCAPE '\\' AND UCASE(FKTABLE_SCHEM) LIKE ? ESCAPE '\\'  AND UCASE(PKTABLE_NAME) LIKE ? ESCAPE '\\' AND UCASE(FKTABLE_NAME) LIKE ? ESCAPE '\\' ORDER BY FKTABLE_NAME, KEY_SEQ";
    private static final String QUERY_EXPORTED_KEYS = "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYS.ReferenceKeyColumns WHERE UCASE(PKTABLE_CAT) LIKE ? ESCAPE '\\'  AND UCASE(PKTABLE_SCHEM) LIKE ? ESCAPE '\\'  AND UCASE(PKTABLE_NAME) LIKE ? ESCAPE '\\' ORDER BY FKTABLE_NAME, KEY_SEQ";
    private static final String QUERY_IMPORTED_KEYS = "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYS.ReferenceKeyColumns WHERE UCASE(FKTABLE_CAT) LIKE ? ESCAPE '\\'  AND UCASE(FKTABLE_SCHEM) LIKE ? ESCAPE '\\'  AND UCASE(FKTABLE_NAME) LIKE ? ESCAPE '\\' ORDER BY PKTABLE_NAME, KEY_SEQ";
    private static final String QUERY_COLUMNS_OLD = "SELECT VDBName AS TABLE_CAT, SchemaName AS TABLE_SCHEM, TableName AS TABLE_NAME, Name AS COLUMN_NAME, Length AS DATA_TYPE, DataType AS TYPE_NAME, e.Precision AS COLUMN_SIZE, NULL AS BUFFER_LENGTH, Scale AS DECIMAL_DIGITS, Radix AS NUM_PREC_RADIX, convert(decodeString(NullType, 'No Nulls, 0, Nullable, 1, Unknown, 2', ','), integer) AS NULLABLE, Description AS REMARKS, DefaultValue AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, CharOctetLength AS CHAR_OCTET_LENGTH, Position AS ORDINAL_POSITION, CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE, NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE, CASE WHEN e.IsAutoIncremented = 'true' THEN 'YES' ELSE 'NO' END AS IS_AUTOINCREMENT FROM SYS.Columns e WHERE UCASE(SchemaName) LIKE ? ESCAPE '\\' AND UCASE(TableName) LIKE ? ESCAPE '\\' AND UCASE(Name) LIKE ? ESCAPE '\\' AND UCASE(VDBName) LIKE ? ESCAPE '\\'  ORDER BY TABLE_NAME, ORDINAL_POSITION";
    private static final String QUERY_COLUMNS = "SELECT VDBName AS TABLE_CAT, SchemaName AS TABLE_SCHEM, TableName AS TABLE_NAME, Name AS COLUMN_NAME, TypeCode AS DATA_TYPE, TypeName AS TYPE_NAME, ColumnSize AS COLUMN_SIZE, NULL AS BUFFER_LENGTH, Scale AS DECIMAL_DIGITS, Radix AS NUM_PREC_RADIX, convert(decodeString(NullType, 'No Nulls, 0, Nullable, 1, Unknown, 2', ','), integer) AS NULLABLE, Description AS REMARKS, DefaultValue AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, CharOctetLength AS CHAR_OCTET_LENGTH, Position AS ORDINAL_POSITION, CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE, NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE, CASE WHEN e.IsAutoIncremented = 'true' THEN 'YES' ELSE 'NO' END AS IS_AUTOINCREMENT, null AS IS_GENERATEDCOLUMN FROM SYS.Columns e WHERE UCASE(SchemaName) LIKE ? ESCAPE '\\' AND UCASE(TableName) LIKE ? ESCAPE '\\' AND UCASE(Name) LIKE ? ESCAPE '\\' AND UCASE(VDBName) LIKE ? ESCAPE '\\'  ORDER BY TABLE_NAME, ORDINAL_POSITION";
    private static final String QUERY_INDEX_INFO = "SELECT VDBName AS TABLE_CAT, SchemaName AS TABLE_SCHEM, TableName AS TABLE_NAME, case when KeyType = 'Index' then TRUE else FALSE end AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, KeyName AS INDEX_NAME, 3 AS TYPE, convert(Position, short) AS ORDINAL_POSITION, k.Name AS COLUMN_NAME, NULL AS ASC_OR_DESC, 0 AS CARDINALITY, 1 AS PAGES, NULL AS FILTER_CONDITION FROM SYS.KeyColumns k WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(TableName) LIKE ? ESCAPE '\\'  AND KeyType IN ('Unique', ?)";
    private static final String QUERY_INDEX_INFO_CARDINALITY = "SELECT VDBName AS TABLE_CAT, SchemaName AS TABLE_SCHEM, Name AS TABLE_NAME, FALSE AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, null AS INDEX_NAME, 0 AS TYPE, cast(0 as short) AS ORDINAL_POSITION, null AS COLUMN_NAME, NULL AS ASC_OR_DESC, CARDINALITY, 1 AS PAGES, NULL AS FILTER_CONDITION FROM SYS.Tables t WHERE Cardinality > -1 AND UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(Name) LIKE ? ESCAPE '\\' ";
    private static final String QUERY_PRIMARY_KEYS = "SELECT VDBName as TABLE_CAT, SchemaName AS TABLE_SCHEM, TableName AS TABLE_NAME, k.Name AS COLUMN_NAME, convert(Position, short) AS KEY_SEQ, KeyName AS PK_NAME FROM SYS.KeyColumns k WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(TableName) LIKE ? ESCAPE '\\'  AND KeyType LIKE 'Primary' ORDER BY COLUMN_NAME, KEY_SEQ";
    private static final String QUERY_PROCEDURES = "SELECT VDBName AS PROCEDURE_CAT, SchemaName AS PROCEDURE_SCHEM, p.Name AS PROCEDURE_NAME, convert(null, string) AS RESERVED_1, convert(null, string) AS RESERVED_2, convert(null, string) AS RESERVED_3, p.Description AS REMARKS, convert(decodeString(p.ReturnsResults, 'true, 2, false, 1'), short) AS PROCEDURE_TYPE, p.Name AS SPECIFIC_NAME FROM SYS.Procedures as p WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(p.Name) LIKE ? ESCAPE '\\'  ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME";
    private static final String QUERY_PROCEDURE_COLUMNS = "SELECT VDBName PROCEDURE_CAT, SchemaName AS PROCEDURE_SCHEM, ProcedureName AS PROCEDURE_NAME, p.Name AS COLUMN_NAME, convert(decodeString(TYPE, 'In,1, Out,4, InOut,2, ReturnValue,5, ResultSet,3', ','), short) AS COLUMN_TYPE, TypeCode AS DATA_TYPE, TypeName AS TYPE_NAME, ColumnSize AS \"PRECISION\", TypeLength  AS LENGTH, convert(case when scale > 32767 then 32767 else Scale end, short) AS SCALE, Radix AS RADIX, convert(decodeString(NullType, 'No Nulls, 0, Nullable, 1, Unknown, 2', ','), integer) AS NULLABLE, p.Description AS REMARKS, %s AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, p.Position AS ORDINAL_POSITION, CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE, p.ProcedureName as SPECIFIC_NAME FROM SYS.ProcedureParams as p WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(ProcedureName) LIKE ? ESCAPE '\\'  AND UCASE(p.Name) LIKE ? ESCAPE '\\'  ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, case TYPE when 'ReturnValue' then 0 when 'ResultSet' then 2 else 1 end, POSITION";
    private static final String QUERY_PROCEDURE_COLUMNS_OLD = "SELECT VDBName PROCEDURE_CAT, SchemaName AS PROCEDURE_SCHEM, ProcedureName AS PROCEDURE_NAME, p.Name AS COLUMN_NAME, convert(decodeString(TYPE, 'In,1, Out,4, InOut,2, ReturnValue,5, ResultSet,3', ','), short) AS COLUMN_TYPE, 1 AS DATA_TYPE, DataType AS TYPE_NAME, p.Precision AS \"PRECISION\", TypeLength  AS LENGTH, convert(case when scale > 32767 then 32767 else Scale end, short) AS SCALE, Radix AS RADIX, convert(decodeString(NullType, 'No Nulls, 0, Nullable, 1, Unknown, 2', ','), integer) AS NULLABLE, p.Description AS REMARKS, NULL AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, p.Position AS ORDINAL_POSITION, CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE, p.ProcedureName as SPECIFIC_NAME FROM SYS.ProcedureParams as p WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(ProcedureName) LIKE ? ESCAPE '\\'  AND UCASE(p.Name) LIKE ? ESCAPE '\\'  ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, case TYPE when 'ReturnValue' then 0 when 'ResultSet' then 2 else 1 end, POSITION";
    private static final String QUERY_SCHEMAS = "SELECT Name AS TABLE_SCHEM, VDBName AS TABLE_CATALOG FROM SYS.Schemas WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(Name) LIKE ? ESCAPE '\\'  ORDER BY TABLE_SCHEM";
    private static final String QUERY_FUNCTIONS = "SELECT VDBName AS Function_CAT, SchemaName AS FUNCTION_SCHEM, Name AS FUNCTION_NAME, Description as REMARKS, 1 as FUNCTION_TYPE, UID AS SPECIFIC_NAME FROM SYS.Functions WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(Name) LIKE ? ESCAPE '\\'  ORDER BY FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME";
    private static final String QUERY_FUNCTION_COLUMNS = "SELECT VDBName AS Function_CAT, SchemaName AS FUNCTION_SCHEM, FunctionName AS FUNCTION_NAME, Name as COLUMN_NAME, CASE WHEN Type = 'ReturnValue' Then 4 WHEN Type = 'In' Then 1 ELSE 0 END AS COLUMN_TYPE, TypeCode AS DATA_TYPE, TypeName AS TYPE_NAME, ColumnSize AS \"PRECISION\", TypeLength  AS LENGTH, convert(case when scale > 32767 then 32767 else Scale end, short) AS SCALE, Radix AS RADIX, convert(decodeString(NullType, 'No Nulls, 0, Nullable, 1, Unknown, 2', ','), integer) AS NULLABLE, Description AS REMARKS, NULL AS CHAR_OCTET_LENGTH, Position AS ORDINAL_POSITION,CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE, FunctionUID as SPECIFIC_NAME FROM SYS.FunctionParams WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(FunctionName) LIKE ? ESCAPE '\\'  AND UCASE(Name) LIKE ? ESCAPE '\\'  ORDER BY FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME, ORDINAL_POSITION";
    private static final String QUERY_FUNCTION_COLUMNS_OLD = "SELECT VDBName AS Function_CAT, SchemaName AS FUNCTION_SCHEM, FunctionName AS FUNCTION_NAME, Name as COLUMN_NAME, CASE WHEN Type = 'ReturnValue' Then 4 WHEN Type = 'In' Then 1 ELSE 0 END AS COLUMN_TYPE, 1 AS DATA_TYPE, DataType AS TYPE_NAME, \"Precision\" AS \"PRECISION\", TypeLength  AS LENGTH, convert(case when scale > 32767 then 32767 else Scale end, short) AS SCALE, Radix AS RADIX, convert(decodeString(NullType, 'No Nulls, 0, Nullable, 1, Unknown, 2', ','), integer) AS NULLABLE, Description AS REMARKS, NULL AS CHAR_OCTET_LENGTH, Position AS ORDINAL_POSITION,CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE, FunctionUID as SPECIFIC_NAME FROM SYS.FunctionParams WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(FunctionName) LIKE ? ESCAPE '\\'  AND UCASE(Name) LIKE ? ESCAPE '\\'  ORDER BY FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME, ORDINAL_POSITION";
    private static final String QUERY_TYPEINFO = "SELECT name as TYPE_NAME, typecode as DATA_TYPE, \"PRECISION\", LITERAL_PREFIX, LITERAL_SUFFIX, null as CREATE_PARAMS, convert(decodeString(NullType, 'No Nulls, 0, Nullable, 1, Unknown, 2', ','), short) AS NULLABLE, IsCaseSensitive as CASE_SENSITIVE, cast(case SearchType when 'Like Only' then 1 when 'All Except Like' then 2 when 'Searchable' then 3 else 0 end as short) as SEARCHABLE, not(IsSigned) as UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, IsAutoIncremented as AUTO_INCREMENT, null as LOCAL_TYPE_NAME, cast(0 as short) as MINIMUM_SCALE, cast(32767 as short) as MAXIMUM_SCALE, cast(null as integer) AS SQL_DATA_TYPE, cast(null as integer) AS SQL_DATETIME_SUB, radix as NUM_PREC_RADIX from SYS.datatypes where type in ('Domain', 'Basic')";
    private final String TABLE_TYPE;
    private final String QUERY_TABLES;
    private final ConnectionImpl driverConnection;
    private NullSort nullSort;

    DatabaseMetaDataImpl(ConnectionImpl connection) {
        this.driverConnection = connection;
        this.TABLE_TYPE = PropertiesUtils.getBooleanProperty((Properties)connection.getConnectionProps(), (String)REPORT_AS_VIEWS, (boolean)true) ? "CASE WHEN IsSystem = 'true' and UCASE(Type) = 'TABLE' THEN 'SYSTEM TABLE' WHEN IsPhysical <> 'true' AND UCASE(Type) = 'TABLE' THEN 'VIEW' ELSE UCASE(Type) END" : "CASE WHEN IsSystem = 'true' and UCASE(Type) = 'TABLE' THEN 'SYSTEM TABLE' ELSE UCASE(Type) END";
        String nullSortProp = connection.getConnectionProps().getProperty(NULL_SORT);
        if (nullSortProp != null) {
            this.nullSort = (NullSort)StringUtil.caseInsensitiveValueOf(NullSort.class, (String)nullSortProp);
        }
        this.QUERY_TABLES = "SELECT VDBName AS TABLE_CAT, SchemaName AS TABLE_SCHEM, Name AS TABLE_NAME, " + this.TABLE_TYPE + " AS TABLE_TYPE, Description AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION, IsPhysical AS ISPHYSICAL FROM SYS.Tables g  WHERE UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(Name) LIKE ? ESCAPE '\\' ";
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "SCOPE", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "COLUMN_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "DATA_TYPE", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "COLUMN_SIZE", "integer", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "BUFFER_LENGTH", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "DECIMAL_DIGITS", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "PSEUDO_COLUMN", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection)};
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.Best_row_sucess", new Object[]{table});
        logger.fine(logMsg);
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList<List<String>> records = new ArrayList<List<String>>(1);
        records.add(Arrays.asList(this.driverConnection.getCatalog()));
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection)};
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.Catalog_success");
        logger.fine(logMsg);
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public String getCatalogTerm() {
        return "VirtualDatabase";
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnName) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "COLUMN_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "GRANTOR", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "GRANTEE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "PRIVILEGE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "IS_GRANTABLE", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection)};
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public ResultSet getColumns(String catalog, String schema, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (tableNamePattern == null) {
            tableNamePattern = PERCENT;
        }
        if (columnNamePattern == null) {
            columnNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        boolean newMetadata = this.driverConnection.getServerConnection().getServerVersion().compareTo("09.03") >= 0;
        try (Statement prepareQuery = null;){
            prepareQuery = this.driverConnection.prepareStatement(newMetadata ? QUERY_COLUMNS : QUERY_COLUMNS_OLD);
            prepareQuery.setObject(1, schema.toUpperCase());
            prepareQuery.setObject(2, tableNamePattern.toUpperCase());
            prepareQuery.setObject(3, columnNamePattern.toUpperCase());
            prepareQuery.setObject(4, catalog.toUpperCase());
            ResultSetImpl results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(23);
                for (int i = 0; i < results.getMetaData().getColumnCount(); ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                if (!newMetadata) {
                    String typeName = (String)currentRow.get(5);
                    Integer length = (Integer)currentRow.get(4);
                    Integer precision = (Integer)currentRow.get(6);
                    if (typeName != null) {
                        currentRow.set(4, JDBCSQLTypeInfo.getSQLType((String)typeName));
                        if (!Number.class.isAssignableFrom(DataTypeManager.getDataTypeClass((String)typeName))) {
                            if (length != null && length <= 0) {
                                currentRow.set(6, JDBCSQLTypeInfo.getDefaultPrecision((String)typeName));
                            } else {
                                currentRow.set(6, length);
                            }
                        } else if (precision != null && precision <= 0) {
                            currentRow.set(6, JDBCSQLTypeInfo.getDefaultPrecision((String)typeName));
                        }
                    } else {
                        currentRow.set(4, null);
                        currentRow.set(6, null);
                    }
                }
                records.add(currentRow);
            }
            ResultSetMetaData rmetadata = results.getMetaData();
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCols_success", new Object[]{columnNamePattern, tableNamePattern});
            logger.fine(logMsg);
            ResultSetImpl typeName = this.dummyStatement().createResultSet(records, rmetadata);
            return typeName;
        }
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        ResultSet resultSet;
        block14: {
            if (primaryCatalog == null) {
                primaryCatalog = PERCENT;
            }
            if (foreignCatalog == null) {
                foreignCatalog = PERCENT;
            }
            if (primarySchema == null) {
                primarySchema = PERCENT;
            }
            if (foreignSchema == null) {
                foreignSchema = PERCENT;
            }
            if (primaryTable == null) {
                primaryTable = PERCENT;
            }
            if (foreignTable == null) {
                foreignTable = PERCENT;
            }
            PreparedStatementImpl prepareQuery = this.driverConnection.prepareStatement(QUERY_CROSS_REFERENCES);
            try {
                prepareQuery.setObject(1, (Object)primaryCatalog.toUpperCase());
                prepareQuery.setObject(2, (Object)foreignCatalog.toUpperCase());
                prepareQuery.setObject(3, (Object)primarySchema.toUpperCase());
                prepareQuery.setObject(4, (Object)foreignSchema.toUpperCase());
                prepareQuery.setObject(5, (Object)primaryTable.toUpperCase());
                prepareQuery.setObject(6, (Object)foreignTable.toUpperCase());
                ResultSet results = prepareQuery.executeQuery();
                ResultSet resultSet2 = this.getReferenceKeys(results);
                String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCrossRef_success", new Object[]{primaryTable, foreignTable});
                logger.fine(logMsg);
                resultSet = resultSet2;
                if (prepareQuery == null) break block14;
            }
            catch (Throwable resultSet2) {
                try {
                    if (prepareQuery != null) {
                        try {
                            prepareQuery.close();
                        }
                        catch (Throwable throwable) {
                            resultSet2.addSuppressed(throwable);
                        }
                    }
                    throw resultSet2;
                }
                catch (Exception e) {
                    String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCrossRef_error", new Object[]{primaryTable, foreignTable, e.getMessage()});
                    throw TeiidSQLException.create(e, logMsg);
                }
            }
            prepareQuery.close();
        }
        return resultSet;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return Integer.parseInt(this.driverConnection.getServerConnection().getServerVersion().split("[.]")[1]);
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.parseInt(this.driverConnection.getServerConnection().getServerVersion().split("[.]")[0]);
    }

    @Override
    public int getJDBCMajorVersion() {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public String getDatabaseProductName() {
        return this.driverConnection.getDatabaseName();
    }

    @Override
    public String getDatabaseProductVersion() {
        return TeiidDriver.getInstance().getMajorVersion() + "." + TeiidDriver.getInstance().getMinorVersion();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 2;
    }

    @Override
    public int getDriverMajorVersion() {
        return TeiidDriver.getInstance().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return TeiidDriver.getInstance().getMinorVersion();
    }

    @Override
    public String getDriverName() {
        return TeiidDriver.getInstance().getDriverName();
    }

    @Override
    public String getDriverVersion() {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet resultSet;
        block11: {
            if (catalog == null) {
                catalog = PERCENT;
            }
            if (schema == null) {
                schema = PERCENT;
            }
            if (table == null) {
                table = PERCENT;
            }
            PreparedStatementImpl prepareQuery = this.driverConnection.prepareStatement(QUERY_EXPORTED_KEYS);
            try {
                prepareQuery.setObject(1, (Object)catalog.toUpperCase());
                prepareQuery.setObject(2, (Object)schema.toUpperCase());
                prepareQuery.setObject(3, (Object)table.toUpperCase());
                ResultSet results = prepareQuery.executeQuery();
                ResultSet resultSet2 = this.getReferenceKeys(results);
                logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getExpKey_success", new Object[]{table}));
                resultSet = resultSet2;
                if (prepareQuery == null) break block11;
            }
            catch (Throwable resultSet2) {
                try {
                    if (prepareQuery != null) {
                        try {
                            prepareQuery.close();
                        }
                        catch (Throwable throwable) {
                            resultSet2.addSuppressed(throwable);
                        }
                    }
                    throw resultSet2;
                }
                catch (Exception e) {
                    String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getExpKey_error", new Object[]{table, e.getMessage()});
                    throw TeiidSQLException.create(e, logMsg);
                }
            }
            prepareQuery.close();
        }
        return resultSet;
    }

    @Override
    public String getExtraNameCharacters() {
        return EXTRA_CHARS;
    }

    @Override
    public String getIdentifierQuoteString() {
        return DOUBLE_QUOTE;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet resultSet;
        block11: {
            if (catalog == null) {
                catalog = PERCENT;
            }
            if (schema == null) {
                schema = PERCENT;
            }
            if (table == null) {
                table = PERCENT;
            }
            PreparedStatementImpl prepareQuery = this.driverConnection.prepareStatement(QUERY_IMPORTED_KEYS);
            try {
                prepareQuery.setObject(1, (Object)catalog.toUpperCase());
                prepareQuery.setObject(2, (Object)schema.toUpperCase());
                prepareQuery.setObject(3, (Object)table.toUpperCase());
                ResultSet results = prepareQuery.executeQuery();
                ResultSet resultSet2 = this.getReferenceKeys(results);
                logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getImpKey_success", new Object[]{table}));
                resultSet = resultSet2;
                if (prepareQuery == null) break block11;
            }
            catch (Throwable resultSet2) {
                try {
                    if (prepareQuery != null) {
                        try {
                            prepareQuery.close();
                        }
                        catch (Throwable throwable) {
                            resultSet2.addSuppressed(throwable);
                        }
                    }
                    throw resultSet2;
                }
                catch (Exception e) {
                    String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getImpKey_error", new Object[]{table, e.getMessage()});
                    throw TeiidSQLException.create(e, logMsg);
                }
            }
            prepareQuery.close();
        }
        return resultSet;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ArrayList records = new ArrayList();
        try (Statement prepareQuery = null;){
            Object query = QUERY_INDEX_INFO;
            if (approximate) {
                query = (String)query + " UNION ALL SELECT VDBName AS TABLE_CAT, SchemaName AS TABLE_SCHEM, Name AS TABLE_NAME, FALSE AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, null AS INDEX_NAME, 0 AS TYPE, cast(0 as short) AS ORDINAL_POSITION, null AS COLUMN_NAME, NULL AS ASC_OR_DESC, CARDINALITY, 1 AS PAGES, NULL AS FILTER_CONDITION FROM SYS.Tables t WHERE Cardinality > -1 AND UCASE(VDBName) LIKE ? ESCAPE '\\'  AND UCASE(SchemaName) LIKE ? ESCAPE '\\'  AND UCASE(Name) LIKE ? ESCAPE '\\' ";
            }
            query = (String)query + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION";
            prepareQuery = this.driverConnection.prepareStatement((String)query);
            prepareQuery.setObject(1, catalog.toUpperCase());
            prepareQuery.setObject(2, schema.toUpperCase());
            prepareQuery.setObject(3, table.toUpperCase());
            prepareQuery.setObject(4, unique ? null : "Index");
            if (approximate) {
                prepareQuery.setObject(5, catalog.toUpperCase());
                prepareQuery.setObject(6, schema.toUpperCase());
                prepareQuery.setObject(7, table.toUpperCase());
            }
            ResultSetImpl results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(13);
                for (int i = 0; i < 13; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            ResultSetMetaData rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getIndex_success", new Object[]{table}));
            ResultSetImpl resultSetImpl = this.dummyStatement().createResultSet(records, rmetadata);
            return resultSetImpl;
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 255;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 255;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 255;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 255;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 255;
    }

    @Override
    public String getNumericFunctions() {
        return NUMERIC_FUNCTIONS;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ArrayList records = new ArrayList();
        try (PreparedStatementImpl prepareQuery = null;){
            Object currentRow;
            prepareQuery = this.driverConnection.prepareStatement(QUERY_PRIMARY_KEYS);
            prepareQuery.setObject(1, (Object)catalog.toUpperCase());
            prepareQuery.setObject(2, (Object)schema.toUpperCase());
            prepareQuery.setObject(3, (Object)table.toUpperCase());
            ResultSetImpl results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                currentRow = new ArrayList<Object>(7);
                for (int i = 0; i < 6; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            ResultSetMetaData rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getPrimaryKey_success"));
            currentRow = this.dummyStatement().createResultSet(records, rmetadata);
            return currentRow;
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        if (procedureNamePattern == null) {
            procedureNamePattern = PERCENT;
        }
        if (columnNamePattern == null) {
            columnNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        boolean newMetadata = this.driverConnection.getServerConnection().getServerVersion().compareTo("09.03") >= 0;
        try (Statement prepareQuery = null;){
            String query = QUERY_PROCEDURE_COLUMNS_OLD;
            if (newMetadata) {
                query = QUERY_PROCEDURE_COLUMNS;
                query = this.driverConnection.getServerConnection().getServerVersion().compareTo("10.02") >= 0 ? String.format(query, "DefaultValue") : String.format(query, "NULL");
            }
            prepareQuery = this.driverConnection.prepareStatement(query);
            prepareQuery.setObject(1, catalog.toUpperCase());
            prepareQuery.setObject(2, schemaPattern.toUpperCase());
            prepareQuery.setObject(3, procedureNamePattern.toUpperCase());
            prepareQuery.setObject(4, columnNamePattern.toUpperCase());
            ResultSetImpl results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(13);
                for (int i = 0; i < 20; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                if (!newMetadata) {
                    String typeName = (String)currentRow.get(6);
                    Integer length = (Integer)currentRow.get(8);
                    Integer precision = (Integer)currentRow.get(7);
                    if (precision != null && precision <= 0) {
                        currentRow.set(7, JDBCSQLTypeInfo.getDefaultPrecision((String)typeName));
                    }
                    if (length != null && length <= 0) {
                        currentRow.set(8, JDBCSQLTypeInfo.getDefaultPrecision((String)typeName));
                    }
                    if (typeName != null) {
                        currentRow.set(5, JDBCSQLTypeInfo.getSQLType((String)typeName));
                    } else {
                        currentRow.set(5, null);
                    }
                }
                records.add(currentRow);
            }
            ResultSetMetaData rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getProcCol_success", new Object[]{columnNamePattern, procedureNamePattern}));
            ResultSetImpl resultSetImpl = this.dummyStatement().createResultSet(records, rmetadata);
            return resultSetImpl;
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        if (procedureNamePattern == null) {
            procedureNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        try (PreparedStatementImpl prepareQuery = null;){
            Object currentRow;
            prepareQuery = this.driverConnection.prepareStatement(QUERY_PROCEDURES);
            prepareQuery.setObject(1, (Object)catalog.toUpperCase());
            prepareQuery.setObject(2, (Object)schemaPattern.toUpperCase());
            prepareQuery.setObject(3, (Object)procedureNamePattern.toUpperCase());
            ResultSetImpl results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                currentRow = new ArrayList<Object>(9);
                for (int i = 0; i < 9; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            ResultSetMetaData rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getProc_success", new Object[]{procedureNamePattern}));
            currentRow = this.dummyStatement().createResultSet(records, rmetadata);
            return currentRow;
        }
    }

    @Override
    public String getProcedureTerm() {
        return PROCEDURE_TERM;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public String getSchemaTerm() {
        return SCHEMA_TERM;
    }

    @Override
    public String getSearchStringEscape() {
        return ESCAPE_SEARCH_STRING;
    }

    @Override
    public String getSQLKeywords() {
        return KEY_WORDS;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public String getStringFunctions() {
        return STRING_FUNCTIONS;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "SUPERTABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection)};
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TYPE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TYPE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "SUPERTYPE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "SUPERTYPE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "SUPERTYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection)};
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public String getSystemFunctions() {
        return SYSTEM_FUNCTIONS;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableName) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "GRANTOR", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "GRANTEE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "PRIVILEGE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "IS_GRANTABLE", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection)};
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        if (tableNamePattern == null) {
            tableNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        StringBuilder sqlQuery = new StringBuilder(this.QUERY_TABLES);
        if (types != null) {
            StringBuilder typesString = new StringBuilder("(");
            if (types.length == 0) {
                typesString.append("1 = 0");
            } else {
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] == null || types[i].isEmpty()) continue;
                    if (i > 0) {
                        typesString.append(" OR ");
                    }
                    typesString.append(this.TABLE_TYPE).append(LIKE_ESCAPE);
                }
            }
            typesString.append(")");
            sqlQuery.append(" AND ").append((CharSequence)typesString);
        }
        sqlQuery.append(" ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        try (PreparedStatementImpl prepareQuery = null;){
            prepareQuery = this.driverConnection.prepareStatement(sqlQuery.toString());
            int columnIndex = 0;
            prepareQuery.setObject(++columnIndex, (Object)catalog.toUpperCase());
            prepareQuery.setObject(++columnIndex, (Object)schemaPattern.toUpperCase());
            prepareQuery.setObject(++columnIndex, (Object)tableNamePattern.toUpperCase());
            if (types != null) {
                for (String type : types) {
                    if (type == null || type.isEmpty()) continue;
                    prepareQuery.setObject(++columnIndex, (Object)type.toUpperCase());
                }
            }
            ResultSetImpl results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                ArrayList<Object> arrayList = new ArrayList<Object>(11);
                for (int i = 0; i < 11; ++i) {
                    arrayList.add(results.getObject(i + 1));
                }
                records.add(arrayList);
            }
            ResultSetMetaData rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getTable_success", new Object[]{tableNamePattern}));
            ResultSetImpl resultSetImpl = this.dummyStatement().createResultSet(records, rmetadata);
            return resultSetImpl;
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<List<String>> records = new ArrayList<List<String>>(5);
        records.add(Arrays.asList("DOCUMENT"));
        records.add(Arrays.asList("TABLE"));
        records.add(Arrays.asList("VIEW"));
        records.add(Arrays.asList("XMLSTAGINGTABLE"));
        records.add(Arrays.asList("SYSTEM TABLE"));
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_TYPE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection)};
        logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getTableType_success"));
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public String getTimeDateFunctions() {
        return DATE_FUNCTIONS;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        if (this.driverConnection.getServerConnection().getServerVersion().compareTo("09.03") >= 0) {
            ArrayList<Object> records = new ArrayList<Object>();
            try (PreparedStatementImpl prepareQuery = null;){
                Object currentRow;
                prepareQuery = this.driverConnection.prepareStatement(QUERY_TYPEINFO);
                ResultSetImpl results = (ResultSetImpl)prepareQuery.executeQuery();
                while (results.next()) {
                    currentRow = new ArrayList();
                    for (int i = 0; i < results.getMetaData().getColumnCount(); ++i) {
                        currentRow.add(results.getObject(i + 1));
                    }
                    records.add(currentRow);
                }
                ResultSetMetaData rmetadata = results.getMetaData();
                currentRow = this.dummyStatement().createResultSet(records, rmetadata);
                return currentRow;
            }
        }
        return this.getStaticTypeInfo();
    }

    private ResultSet getStaticTypeInfo() throws SQLException {
        ArrayList<List<Object>> records = new ArrayList<List<Object>>();
        records.add(Arrays.asList(this.createTypeInfoRow("boolean", "{b'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("byte", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("tinyint", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("long", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("bigint", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("char", "'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("bigdecimal", null, null, Boolean.FALSE, Boolean.TRUE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("decimal", null, null, Boolean.FALSE, Boolean.TRUE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("biginteger", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("integer", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("short", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("smallint", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("float", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("real", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("double", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("string", "'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("varchar", "'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("xml", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("date", "{d'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("time", "{t'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("timestamp", "{ts'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("object", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("blob", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("varbinary", "X'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("clob", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata("SYS.DataTypes", "TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "DATA_TYPE", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "PRECISION", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "LITERAL_PREFIX", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "LITERAL_SUFFIX", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "CREATE_PARAMS", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "NULLABLE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "CASE_SENSITIVE", "boolean", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "SEARCHABLE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "UNSIGNED_ATTRIBUTE", "boolean", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "FIXED_PREC_SCALE", "boolean", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "AUTO_INCREMENT", "boolean", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "LOCAL_TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "MINIMUM_SCALE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "MAXIMUM_SCALE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "SQL_DATA_TYPE", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "SQL_DATETIME_SUB", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "NUM_PREC_RADIX", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.driverConnection)};
        ResultSetMetaDataImpl rmetadata = new ResultSetMetaDataImpl(new MetadataProvider(metadataList), null);
        logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getTypes_success"));
        return this.dummyStatement().createResultSet(records, rmetadata);
    }

    private Object[] createTypeInfoRow(String typeName, String prefix, String suffix, Boolean unsigned, Boolean fixedPrecScale, int radix) {
        return new Object[]{typeName, JDBCSQLTypeInfo.getSQLType((String)typeName), JDBCSQLTypeInfo.getDefaultPrecision((String)typeName), prefix, suffix, null, (short)1, Boolean.FALSE, (short)3, unsigned, fixedPrecScale, Boolean.FALSE, typeName, (short)0, (short)255, null, null, radix};
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.emptyUDTSResultSet();
    }

    private ResultSet emptyUDTSResultSet() throws SQLException {
        String[] columnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"};
        String[] dataTypes = new String[]{"string", "string", "string", "string", "string", "string", "short"};
        return this.dummyStatement().createResultSet(Collections.EMPTY_LIST, columnNames, dataTypes);
    }

    private StatementImpl dummyStatement() {
        return new StatementImpl(this.driverConnection, 1004, 1007);
    }

    @Override
    public String getURL() {
        return this.driverConnection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.driverConnection.getUserName();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ResultSet resultSet = this.getBestRowIdentifier(catalog, schema, table, 0, true);
        logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getVersionCols_success"));
        return resultSet;
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return this.nullSort == NullSort.AtEnd;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return this.nullSort == NullSort.AtStart;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return this.nullSort == NullSort.High;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return this.nullSort == NullSort.Low;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        String toName;
        String fromName = JDBCSQLTypeInfo.getTypeName((int)fromType);
        if (fromName.equals(toName = JDBCSQLTypeInfo.getTypeName((int)toType))) {
            return !fromName.equals("object") || fromName.equals(toName);
        }
        return DataTypeManager.isTransformable((String)fromName, (String)toName);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        if (type == 1003 || type == 1004) {
            return concurrency == 1007;
        }
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003 || type == 1004;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return false;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    private ResultSet getReferenceKeys(ResultSet results) throws SQLException {
        ResultSetMetaData rmetadata;
        ArrayList records = new ArrayList();
        try {
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(15);
                for (int i = 0; i < 14; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (Exception e) {
            String msg = JDBCPlugin.Util.getString("MMDatabaseMetadata.Err_getting_primary_keys");
            throw TeiidSQLException.create(e, msg);
        }
        logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getRefKey_success"));
        return this.dummyStatement().createResultSet(records, rmetadata);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driverConnection;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        ResultSetImpl resultSetImpl;
        block19: {
            if (catalog == null) {
                catalog = PERCENT;
            }
            if (schemaPattern == null) {
                schemaPattern = PERCENT;
            }
            if (functionNamePattern == null) {
                functionNamePattern = PERCENT;
            }
            if (columnNamePattern == null) {
                columnNamePattern = PERCENT;
            }
            ArrayList records = new ArrayList();
            boolean newMetadata = this.driverConnection.getServerConnection().getServerVersion().compareTo("09.03") >= 0;
            PreparedStatementImpl prepareQuery = this.driverConnection.prepareStatement(newMetadata ? QUERY_FUNCTION_COLUMNS : QUERY_FUNCTION_COLUMNS_OLD);
            try {
                prepareQuery.setString(1, catalog.toUpperCase());
                prepareQuery.setString(2, schemaPattern.toUpperCase());
                prepareQuery.setString(3, functionNamePattern.toUpperCase());
                prepareQuery.setString(4, columnNamePattern.toUpperCase());
                ResultSetImpl results = prepareQuery.executeQuery();
                ResultSetMetaData rmetadata = results.getMetaData();
                int cols = rmetadata.getColumnCount();
                while (results.next()) {
                    ArrayList<Object> currentRow = new ArrayList<Object>(cols);
                    for (int i = 0; i < cols; ++i) {
                        currentRow.add(results.getObject(i + 1));
                    }
                    if (!newMetadata) {
                        String typeName = (String)currentRow.get(6);
                        Integer length = (Integer)currentRow.get(8);
                        Integer precision = (Integer)currentRow.get(7);
                        if (precision != null && precision <= 0) {
                            currentRow.set(7, JDBCSQLTypeInfo.getDefaultPrecision((String)typeName));
                        }
                        if (length != null && length <= 0) {
                            currentRow.set(8, JDBCSQLTypeInfo.getDefaultPrecision((String)typeName));
                        }
                        if (typeName != null) {
                            currentRow.set(5, JDBCSQLTypeInfo.getSQLType((String)typeName));
                        } else {
                            currentRow.set(5, null);
                        }
                    }
                    records.add(currentRow);
                }
                logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getfunctioncolumns_success"));
                resultSetImpl = this.dummyStatement().createResultSet(records, rmetadata);
                if (prepareQuery == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (prepareQuery != null) {
                        try {
                            prepareQuery.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw TeiidSQLException.create(e, JDBCPlugin.Util.getString("MMDatabaseMetadata.getfunctioncolumns_error", new Object[]{e.getMessage()}));
                }
            }
            prepareQuery.close();
        }
        return resultSetImpl;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        ResultSetImpl resultSetImpl;
        block13: {
            if (catalog == null) {
                catalog = PERCENT;
            }
            if (schemaPattern == null) {
                schemaPattern = PERCENT;
            }
            if (functionNamePattern == null) {
                functionNamePattern = PERCENT;
            }
            ArrayList records = new ArrayList();
            PreparedStatementImpl prepareQuery = this.driverConnection.prepareStatement(QUERY_FUNCTIONS);
            try {
                prepareQuery.setString(1, catalog.toUpperCase());
                prepareQuery.setString(2, schemaPattern.toUpperCase());
                prepareQuery.setString(3, functionNamePattern.toUpperCase());
                ResultSetImpl results = prepareQuery.executeQuery();
                ResultSetMetaData rmetadata = results.getMetaData();
                int cols = rmetadata.getColumnCount();
                while (results.next()) {
                    ArrayList<Object> currentRow = new ArrayList<Object>(cols);
                    for (int i = 0; i < cols; ++i) {
                        currentRow.add(results.getObject(i + 1));
                    }
                    records.add(currentRow);
                }
                logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getfunctions_success"));
                resultSetImpl = this.dummyStatement().createResultSet(records, rmetadata);
                if (prepareQuery == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (prepareQuery != null) {
                        try {
                            prepareQuery.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw TeiidSQLException.create(e, JDBCPlugin.Util.getString("MMDatabaseMetadata.getfunctions_error", new Object[]{e.getMessage()}));
                }
            }
            prepareQuery.close();
        }
        return resultSetImpl;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        ResultSetImpl resultSetImpl;
        block12: {
            if (catalog == null) {
                catalog = PERCENT;
            }
            if (schemaPattern == null) {
                schemaPattern = PERCENT;
            }
            ArrayList records = new ArrayList();
            PreparedStatementImpl prepareQuery = this.driverConnection.prepareStatement(QUERY_SCHEMAS);
            try {
                prepareQuery.setObject(1, (Object)catalog.toUpperCase());
                prepareQuery.setObject(2, (Object)schemaPattern.toUpperCase());
                ResultSetImpl results = prepareQuery.executeQuery();
                while (results.next()) {
                    ArrayList<Object> currentRow = new ArrayList<Object>(2);
                    for (int i = 0; i < 2; ++i) {
                        currentRow.add(results.getObject(i + 1));
                    }
                    records.add(currentRow);
                }
                ResultSetMetaData rmetadata = results.getMetaData();
                logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getschema_success"));
                resultSetImpl = this.dummyStatement().createResultSet(records, rmetadata);
                if (prepareQuery == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (prepareQuery != null) {
                        try {
                            prepareQuery.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw TeiidSQLException.create(e, JDBCPlugin.Util.getString("MMDatabaseMetadata.getschema_error", new Object[]{e.getMessage()}));
                }
            }
            prepareQuery.close();
        }
        return resultSetImpl;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    private static final class RUNTIME_MODEL {
        public static final String VIRTUAL_MODEL_NAME = "SYS";

        private RUNTIME_MODEL() {
        }
    }

    static enum NullSort {
        High,
        Low,
        AtStart,
        AtEnd;

    }
}

