/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc.tracing;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ContextPropagatingExecutorService
implements ExecutorService {
    private final ExecutorService delegate;

    public ContextPropagatingExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        Context parent = Context.current();
        this.delegate.execute(() -> {
            try (Scope scope = parent.makeCurrent();){
                command.run();
            }
        });
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Context parent = Context.current();
        return this.delegate.submit(() -> {
            try (Scope scope = parent.makeCurrent();){
                Object v = task.call();
                return v;
            }
        });
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        Context parent = Context.current();
        return this.delegate.submit(() -> {
            try (Scope scope = parent.makeCurrent();){
                task.run();
            }
        }, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        Context parent = Context.current();
        return this.delegate.submit(() -> {
            try (Scope scope = parent.makeCurrent();){
                task.run();
            }
        });
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }
}

