/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.net.socket;

import com.kubling.teiid.core.util.ApplicationInfo;
import com.kubling.teiid.core.util.StringUtil;
import com.kubling.teiid.net.socket.AuthenticationType;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.List;

public class Handshake
implements Externalizable {
    private static final long serialVersionUID = 7839271224736355515L;
    private String version = ApplicationInfo.getInstance().getReleaseNumber();
    private byte[] publicKey;
    private byte[] publicKeyLarge;
    private AuthenticationType authType = AuthenticationType.USERPASSWORD;
    private boolean cbc = true;

    public Handshake() {
    }

    Handshake(String version) {
        this.version = version;
    }

    public String getVersion() {
        if (this.version != null) {
            StringBuilder builder = new StringBuilder();
            List parts = StringUtil.split((String)this.version, (String)".");
            for (int i = 0; i < parts.size(); ++i) {
                String part;
                if (i > 0) {
                    builder.append('.');
                }
                if ((part = (String)parts.get(i)).length() < 2 && Character.isDigit(part.charAt(0))) {
                    builder.append('0');
                }
                builder.append(part);
            }
            return builder.toString();
        }
        return this.version;
    }

    public void setVersion() {
        this.version = ApplicationInfo.getInstance().getReleaseNumber();
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] key) {
        this.publicKey = key;
    }

    @Deprecated
    public AuthenticationType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthenticationType authType) {
        this.authType = authType;
    }

    public byte[] getPublicKeyLarge() {
        return this.publicKeyLarge;
    }

    public void setPublicKeyLarge(byte[] publicKeyLarge) {
        this.publicKeyLarge = publicKeyLarge;
    }

    public boolean isCbc() {
        return this.cbc;
    }

    public void setCbc(boolean cbc) {
        this.cbc = cbc;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.version = (String)in.readObject();
        this.publicKey = (byte[])in.readObject();
        try {
            this.authType = AuthenticationType.values()[in.readByte()];
            int byteLength = in.readInt();
            if (byteLength > -1) {
                this.publicKeyLarge = new byte[byteLength];
                in.readFully(this.publicKeyLarge);
            }
        }
        catch (EOFException e) {
            this.publicKeyLarge = null;
        }
        try {
            this.cbc = in.readBoolean();
        }
        catch (EOFException | OptionalDataException e) {
            this.cbc = false;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.version);
        out.writeObject(this.publicKey);
        out.writeByte(this.authType.ordinal());
        if (this.publicKeyLarge == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.publicKeyLarge.length);
            out.write(this.publicKeyLarge);
        }
        out.writeBoolean(this.cbc);
    }
}

