/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.netty.handler.codec.serialization;

import com.kubling.teiid.core.util.ExternalizeUtil;
import com.kubling.teiid.core.util.MultiArrayOutputStream;
import com.kubling.teiid.netty.handler.codec.serialization.CompactObjectOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class ObjectEncoderOutputStream
extends ObjectOutputStream {
    private final DataOutputStream out;
    private final MultiArrayOutputStream baos;

    public ObjectEncoderOutputStream(DataOutputStream out, int initialBufferSize) throws SecurityException, IOException {
        this.out = out;
        this.baos = new MultiArrayOutputStream(initialBufferSize);
    }

    @Override
    protected final void writeObjectOverride(Object obj) throws IOException {
        this.baos.reset(4);
        CompactObjectOutputStream oout = new CompactObjectOutputStream((OutputStream)this.baos);
        oout.writeObject(obj);
        ExternalizeUtil.writeCollection((ObjectOutput)oout, oout.getReferences());
        oout.flush();
        oout.close();
        int val = this.baos.getCount() - 4;
        byte[] b = this.baos.getBuffers()[0];
        b[3] = (byte)(val >>> 0);
        b[2] = (byte)(val >>> 8);
        b[1] = (byte)(val >>> 16);
        b[0] = (byte)(val >>> 24);
        this.baos.writeTo((DataOutput)this.out);
        if (!oout.getStreams().isEmpty()) {
            this.baos.reset(0);
            byte[] chunk = new byte[65536];
            for (InputStream is : oout.getStreams()) {
                int bytes;
                do {
                    bytes = is.read(chunk, 2, chunk.length - 2);
                    int toWrite = Math.max(0, bytes);
                    chunk[1] = (byte)(toWrite >>> 0);
                    chunk[0] = (byte)(toWrite >>> 8);
                    if (this.baos.getIndex() + toWrite + 2 > b.length) {
                        this.baos.writeTo((DataOutput)this.out);
                        this.baos.reset(0);
                        this.out.write(chunk, 0, toWrite + 2);
                        continue;
                    }
                    this.baos.write(chunk, 0, toWrite + 2);
                } while (bytes >= 1);
                is.close();
            }
            if (this.baos.getIndex() > 0) {
                this.baos.writeTo((DataOutput)this.out);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void reset() {
    }
}

