/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.TeiidRuntimeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class TestMetaMatrixRuntimeException {
    @Test
    public void testFailMetaMatrixRuntimeExceptionWithNullMessage() {
        Throwable e = null;
        try {
            new TeiidRuntimeException((String)null);
            Assertions.fail((String)"Should not get here");
        }
        catch (Throwable ex) {
            e = ex;
        }
        Assertions.assertNotNull((Object)e);
    }

    @Test
    public void testMetaMatrixRuntimeExceptionWithNullThrowable() {
        TeiidRuntimeException err = new TeiidRuntimeException((Throwable)null);
        Assertions.assertNull((Object)err.getCause());
        Assertions.assertNull((Object)err.getCode());
        Assertions.assertNull((Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixRuntimeExceptionWithMessage() {
        TeiidRuntimeException err = new TeiidRuntimeException("Test");
        Assertions.assertNull((Object)err.getCause());
        Assertions.assertNull((Object)err.getCode());
        Assertions.assertEquals((Object)"Test", (Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixRuntimeExceptionWithCodeAndMessage() {
        String code = "1234";
        TeiidRuntimeException err = new TeiidRuntimeException("1234", "Test");
        Assertions.assertNull((Object)err.getCause());
        Assertions.assertEquals((Object)"1234", (Object)err.getCode());
        Assertions.assertEquals((Object)"1234 Test", (Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixRuntimeExceptionWithExceptionAndCodeAndMessage() {
        String code = "1234";
        TeiidRuntimeException child = new TeiidRuntimeException("1234", "Child");
        TeiidRuntimeException err = new TeiidRuntimeException((BundleUtil.Event)Event.Code, (Throwable)child, "Test");
        Assertions.assertSame((Object)child, (Object)err.getCause());
        Assertions.assertEquals((Object)"Code", (Object)err.getCode());
        Assertions.assertEquals((Object)"Code Test", (Object)err.getMessage());
    }

    public static enum Event implements BundleUtil.Event
    {
        Code;

    }
}

