/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.util.PropertiesUtils;
import com.kubling.teiid.core.util.UnitTestUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPropertiesUtils {
    private static final String TEMP_FILE = UnitTestUtil.getTestScratchPath() + "/temp.properties";
    private static final boolean UNMODIFIABLE = true;
    private static final boolean DEEP_CLONE = true;
    private static final String PROP_NAME_1 = "prop1";
    private static final String PROP_NAME_2 = "prop2";
    private static final String PROP_NAME_3 = "prop3";
    private static final String PROP_NAME_4 = "prop4";
    private static final String PROP_NAME_5 = "prop5";
    private static final String PROP_NAME_6 = "prop6";
    private static final String PROP_VALUE_1A = "value1a";
    private static final String PROP_VALUE_1B = "value1b";
    private static final String PROP_VALUE_2A = "value2a";
    private static final String PROP_VALUE_2C = "value2c";
    private static final String PROP_VALUE_3A = "value3a";
    private static final String PROP_VALUE_4B = "value4b";
    private static final String PROP_VALUE_4C = "value4c";
    private static final String PROP_VALUE_5B = "value5b";
    private static final String PROP_VALUE_6C = "value6c";
    private static final Map<String, String> MAP_A = Map.of("prop1", "value1a", "prop2", "value2a", "prop3", "value3a");
    private static final Map<String, String> MAP_B;
    private static final Map<String, String> MAP_C;
    private static final List<Map<String, String>> LIST_A;
    private static final List LIST_AB;
    private static final List LIST_ABC;

    @AfterEach
    public void tearDown() {
        try {
            File temp = new File(TEMP_FILE);
            temp.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPutAllWithDefaults() {
        Properties c = TestPropertiesUtils.make(MAP_C, null, false);
        Properties ab = TestPropertiesUtils.make(MAP_A, TestPropertiesUtils.make(MAP_B, null, true), true);
        PropertiesUtils.putAll((Properties)c, (Properties)ab);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(c, LIST_ABC));
    }

    @Test
    public void testSimpleModifiableClone() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        a = PropertiesUtils.clone((Properties)a);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_A));
    }

    @Test
    public void testSimpleModifiableCloneWithUnmodifiableDefaults() {
        Properties ab = TestPropertiesUtils.make(MAP_A, TestPropertiesUtils.make(MAP_B, null, true), false);
        ab = PropertiesUtils.clone((Properties)ab);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(ab, LIST_AB));
    }

    @Test
    public void testSimpleModifiableCloneWithModifiableDefaults() {
        Properties ab = TestPropertiesUtils.make(MAP_A, TestPropertiesUtils.make(MAP_B, null, false), false);
        ab = PropertiesUtils.clone((Properties)ab);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(ab, LIST_AB));
    }

    @Test
    public void testCloneModifiableAsModifiable() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        a = PropertiesUtils.clone((Properties)a);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_A));
    }

    @Test
    public void testCloneUnmodifiableAsModifiable() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        a = PropertiesUtils.clone((Properties)a);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_A));
    }

    @Test
    public void testCloneModifiableWithModifiableAsModifiable() {
        Properties ab = TestPropertiesUtils.make(MAP_A, TestPropertiesUtils.make(MAP_B, null, false), false);
        ab = PropertiesUtils.clone((Properties)ab);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(ab, LIST_AB));
    }

    @Test
    public void testCloneModAndModAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        Properties b = TestPropertiesUtils.make(MAP_B, null, false);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)false);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    @Test
    public void testDeepcloneModAndModAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        Properties b = TestPropertiesUtils.make(MAP_B, null, false);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)true);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    @Test
    public void testCloneModAndUnmodAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        Properties b = TestPropertiesUtils.make(MAP_B, null, true);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)false);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    @Test
    public void testDeepcloneModAndUnmodAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        Properties b = TestPropertiesUtils.make(MAP_B, null, true);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)true);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    @Test
    public void testCloneUnmodAndModAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        Properties b = TestPropertiesUtils.make(MAP_B, null, false);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)false);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    @Test
    public void testDeepcloneUnmodAndModAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        Properties b = TestPropertiesUtils.make(MAP_B, null, false);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)true);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    @Test
    public void testCloneUnmodAndUnmodAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        Properties b = TestPropertiesUtils.make(MAP_B, null, true);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)false);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    @Test
    public void testDeepcloneUnmodAndUnmodAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        Properties b = TestPropertiesUtils.make(MAP_B, null, true);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)true);
        Assertions.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    private static boolean verifyProps(Properties props, List chainOfMappings) {
        boolean result = TestPropertiesUtils.verifyAllPropsPresent(props, chainOfMappings);
        if (result) {
            result = TestPropertiesUtils.verifyCorrectMappings(props, chainOfMappings);
        }
        return result;
    }

    private static boolean verifyAllPropsPresent(Properties props, List chainOfMappings) {
        Enumeration<?> e = props.propertyNames();
        HashSet propNames = new HashSet();
        while (e.hasMoreElements()) {
            propNames.add(e.nextElement());
        }
        HashSet testNames = new HashSet();
        for (Object chainOfMapping : chainOfMappings) {
            Map aMapping = (Map)chainOfMapping;
            testNames.addAll(aMapping.keySet());
        }
        return propNames.containsAll(testNames);
    }

    private static boolean verifyCorrectMappings(Properties props, List chainOfMappings) {
        Enumeration<?> e = props.propertyNames();
        boolean allGood = true;
        while (e.hasMoreElements() && allGood) {
            boolean foundKey = false;
            String propName = (String)e.nextElement();
            String propValue = props.getProperty(propName);
            Iterator i = chainOfMappings.iterator();
            while (i.hasNext() && !foundKey) {
                Map aMapping = (Map)i.next();
                Object value = aMapping.get(propName);
                if (value == null) continue;
                foundKey = true;
                allGood = propValue.equals(value);
            }
        }
        return allGood;
    }

    private static Properties make(Map mappings, Properties defaults, boolean makeUnmodifiable) {
        Properties props = defaults != null ? new Properties(defaults) : new Properties();
        Iterator iterator = mappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry anEntry = o = iterator.next();
            props.setProperty((String)anEntry.getKey(), (String)anEntry.getValue());
        }
        return props;
    }

    @Test
    public void testGetInvalidInt() {
        Properties p = new Properties();
        p.setProperty("x", "y");
        try {
            PropertiesUtils.getIntProperty((Properties)p, (String)"x", (int)1);
            Assertions.fail((String)"expected exception");
        }
        catch (PropertiesUtils.InvalidPropertyException e) {
            Assertions.assertEquals((Object)"TEIID10037 Property 'x' with value 'y' is not a valid Integer.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetBeanProperties() {
        Bean bean = new Bean();
        Properties p = new Properties();
        p.setProperty("prop", "0");
        p.setProperty(PROP_NAME_1, "1");
        p.setProperty(PROP_NAME_2, "2");
        p.setProperty(PROP_NAME_3, "3");
        p = new Properties(p);
        p.put("object", new Object());
        PropertiesUtils.setBeanProperties((Object)bean, (Properties)p, null);
        Assertions.assertEquals((int)0, (int)bean.getProp());
        Assertions.assertEquals((Object)"1", (Object)bean.getProp1());
        Assertions.assertEquals((double)2.0, (double)bean.getProp2(), (double)0.0);
        Assertions.assertEquals(Arrays.asList("3"), bean.getProp3());
        p.setProperty("prop", "?");
        try {
            PropertiesUtils.setBeanProperties((Object)bean, (Properties)p, null);
            Assertions.fail((String)"expected exception");
        }
        catch (PropertiesUtils.InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
    }

    @Test
    public void testGetInt() {
        Properties p = new Properties();
        p.setProperty("prop", "0  ");
        Assertions.assertEquals((int)PropertiesUtils.getIntProperty((Properties)p, (String)"prop", (int)-1), (int)0);
    }

    @Test
    public void testCaseSensitive() {
        Properties p = new Properties();
        p.setProperty("org.teiid.val", "100");
        MyBean test = new MyBean();
        PropertiesUtils.setBeanProperties((Object)test, (Properties)p, (String)"org.teiid");
        Assertions.assertEquals((int)100, (int)test.getVal());
    }

    @Test
    public void testSystemProperty() {
        String old = System.setProperty("org.teiid.val", "200");
        try {
            MyBean test = new MyBean();
            PropertiesUtils.setBeanProperties((Object)test, (Properties)System.getProperties(), (String)"org.teiid");
            Assertions.assertEquals((int)200, (int)test.getVal());
        }
        finally {
            if (old != null) {
                System.setProperty("org.teiid.val", old);
            } else {
                System.clearProperty("org.teiid.val");
            }
        }
    }

    @Test
    public void testGetEnvValue() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ORG_TEIID_SOME_LONG_VAL", "val");
        Assertions.assertEquals((Object)"val", (Object)PropertiesUtils.getValue((String)"org.teiid.someLongVal", (Map)Collections.EMPTY_MAP, env));
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put(PROP_NAME_1, PROP_VALUE_1B);
        temp.put(PROP_NAME_4, PROP_VALUE_4B);
        temp.put(PROP_NAME_5, PROP_VALUE_5B);
        MAP_B = Collections.unmodifiableMap(temp);
        temp = new HashMap();
        temp.put(PROP_NAME_2, PROP_VALUE_2C);
        temp.put(PROP_NAME_4, PROP_VALUE_4C);
        temp.put(PROP_NAME_6, PROP_VALUE_6C);
        MAP_C = Collections.unmodifiableMap(temp);
        LIST_A = List.of(MAP_A);
        ArrayList<Map<String, String>> tempList = new ArrayList<Map<String, String>>(1);
        tempList.add(MAP_B);
        tempList = new ArrayList(2);
        tempList.add(MAP_A);
        tempList.add(MAP_B);
        LIST_AB = Collections.unmodifiableList(tempList);
        tempList = new ArrayList(3);
        tempList.add(MAP_A);
        tempList.add(MAP_B);
        tempList.add(MAP_C);
        LIST_ABC = Collections.unmodifiableList(tempList);
    }

    static class Bean {
        private int prop;
        private String prop1;
        private double prop2;
        private List<String> prop3;

        Bean() {
        }

        public int getProp() {
            return this.prop;
        }

        public void setProp(int prop) {
            this.prop = prop;
        }

        public String getProp1() {
            return this.prop1;
        }

        public void setProp1(String prop1) {
            this.prop1 = prop1;
        }

        public double getProp2() {
            return this.prop2;
        }

        public void setProp2(double prop2) {
            this.prop2 = prop2;
        }

        public List<String> getProp3() {
            return this.prop3;
        }

        public void setProp3(List<String> prop3) {
            this.prop3 = prop3;
        }
    }

    public static class MyBean {
        int val;

        public int getVal() {
            return this.val;
        }

        public void setVal(int val) {
            this.val = val;
        }
    }
}

