/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.containerapp;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.utils.StreamingLogSupport;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.Replica;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ReplicaContainerModule;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.Revision;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;

public class ReplicaContainer
extends AbstractAzResource<ReplicaContainer, Replica, com.azure.resourcemanager.appcontainers.models.ReplicaContainer>
implements StreamingLogSupport {
    protected ReplicaContainer(@Nonnull String name, @Nonnull ReplicaContainerModule module) {
        super(name, (AbstractAzResourceModule)module);
    }

    protected ReplicaContainer(@Nonnull ReplicaContainer origin) {
        super((AbstractAzResource)origin);
    }

    protected ReplicaContainer(@Nonnull com.azure.resourcemanager.appcontainers.models.ReplicaContainer remote, @Nonnull ReplicaContainerModule module) {
        super(remote.name(), (AbstractAzResourceModule)module);
    }

    @NotNull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @NotNull
    protected String loadStatus(@NotNull com.azure.resourcemanager.appcontainers.models.ReplicaContainer remote) {
        return BooleanUtils.isTrue((Boolean)remote.started()) ? "Running" : "Unknown";
    }

    @Nullable
    public String getLogStreamEndpoint() {
        if (!this.exists()) {
            throw new AzureToolkitRuntimeException(AzureString.format((String)"resource ({0}) not found", (Object[])new Object[]{this.getName()}).toString());
        }
        Replica replica = (Replica)this.getParent();
        Revision revision = (Revision)replica.getParent();
        ContainerApp app = (ContainerApp)revision.getParent();
        String eventStreamEndpoint = ((com.azure.resourcemanager.appcontainers.models.ContainerApp)Objects.requireNonNull(app.getRemote())).eventStreamEndpoint();
        String baseUrl = eventStreamEndpoint.substring(0, eventStreamEndpoint.indexOf("/subscriptions/"));
        return String.format("%s/subscriptions/%s/resourceGroups/%s/containerApps/%s/revisions/%s/replicas/%s/containers/%s/logstream", baseUrl, this.getSubscriptionId(), this.getResourceGroupName(), app.getName(), revision.getName(), replica.getName(), this.getName());
    }

    public String getLogStreamAuthorization() {
        return ((ContainerApp)((Revision)((Replica)this.getParent()).getParent()).getParent()).getLogStreamAuthorization();
    }
}

