/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.models.Providers;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryModule;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryServiceSubscription;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureContainerRegistry
extends AbstractAzService<AzureContainerRegistryServiceSubscription, ContainerRegistryManager> {
    public AzureContainerRegistry() {
        super("Microsoft.ContainerRegistry");
    }

    @Nonnull
    protected AzureContainerRegistryServiceSubscription newResource(@Nonnull ContainerRegistryManager containerRegistryManager) {
        return new AzureContainerRegistryServiceSubscription(containerRegistryManager, this);
    }

    public AzureContainerRegistryModule registry(@Nonnull String subscriptionId) {
        AzureContainerRegistryServiceSubscription rm = (AzureContainerRegistryServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.registry();
    }

    @Nullable
    protected ContainerRegistryManager loadResourceFromAzure(@Nonnull String subscriptionId, String resourceGroup) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        String tenantId = account.getSubscription(subscriptionId).getTenantId();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogOptions logOptions = new HttpLogOptions();
        logOptions.setLogLevel(Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE));
        AzureProfile azureProfile = new AzureProfile(tenantId, subscriptionId, account.getEnvironment());
        Providers providers = ((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId).providers();
        return ((ContainerRegistryManager.Configurable)((ContainerRegistryManager.Configurable)((ContainerRegistryManager.Configurable)((ContainerRegistryManager.Configurable)ContainerRegistryManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withLogOptions(logOptions)).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent))).withPolicy((HttpPipelinePolicy)new ProviderRegistrationPolicy(providers))).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Container Registries";
    }

    public String getServiceNameForTelemetry() {
        return "acr";
    }
}

