/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.core.util.BinaryData;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryInner;
import com.azure.resourcemanager.containerregistry.fluent.models.RunInner;
import com.azure.resourcemanager.containerregistry.models.AccessKeyType;
import com.azure.resourcemanager.containerregistry.models.ImageDescriptor;
import com.azure.resourcemanager.containerregistry.models.OverridingArgument;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.Registry;
import com.azure.resourcemanager.containerregistry.models.RegistryTaskRun;
import com.azure.resourcemanager.containerregistry.models.RunStatus;
import com.azure.resourcemanager.containerregistry.models.SourceUploadDefinition;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.google.common.collect.ImmutableSet;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.StreamingDiagnosticsException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.StreamingLogSupport;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryModule;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistryDraft;
import com.microsoft.azure.toolkit.lib.containerregistry.RegistryTaskRunStreamingLog;
import com.microsoft.azure.toolkit.lib.containerregistry.RepositoryModule;
import com.microsoft.azure.toolkit.lib.containerregistry.model.Sku;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerRegistry
extends AbstractAzResource<ContainerRegistry, AzureContainerRegistryServiceSubscription, Registry> {
    public static final String ACR_IMAGE_SUFFIX = ".azurecr.io";
    private final RepositoryModule repositoryModule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected ContainerRegistry(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AzureContainerRegistryModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
        this.repositoryModule = new RepositoryModule(this);
    }

    protected ContainerRegistry(@Nonnull ContainerRegistry registry) {
        super((AbstractAzResource)registry);
        this.repositoryModule = registry.repositoryModule;
    }

    protected ContainerRegistry(@Nonnull Registry registry, @Nonnull AzureContainerRegistryModule module) {
        super(registry.name(), registry.resourceGroupName(), (AbstractAzResourceModule)module);
        this.repositoryModule = new RepositoryModule(this);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.repositoryModule);
    }

    @Nonnull
    protected String loadStatus(@Nonnull Registry remote) {
        return Optional.ofNullable(remote.innerModel()).map(RegistryInner::provisioningState).map(ExpandableStringEnum::toString).orElse("Unknown");
    }

    public boolean isAdminUserEnabled() {
        return this.remoteOptional().map(Registry::adminUserEnabled).orElse(false);
    }

    public boolean isPublicAccessEnabled() {
        return this.remoteOptional().map(r -> r.publicNetworkAccess() == PublicNetworkAccess.ENABLED).orElse(true);
    }

    @AzureOperation(name="internal/acr.enable_admin_user.registry", params={"this.getName()"})
    public void enableAdminUser() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ContainerRegistryDraft update = (ContainerRegistryDraft)this.update();
            update.setAdminUserEnabled(true);
            update.commit();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="internal/acr.disable_admin_user.registry", params={"this.getName()"})
    public void disableAdminUser() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ContainerRegistryDraft update = (ContainerRegistryDraft)this.update();
            update.setAdminUserEnabled(false);
            update.commit();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public Sku getSku() {
        return this.remoteOptional().map(Registry::sku).map(sku -> sku.tier().toString()).map(Sku::valueOf).orElse(null);
    }

    @Nullable
    public Region getRegion() {
        return this.remoteOptional().map(registry -> registry.region().name()).map(Region::fromName).orElse(null);
    }

    @Nullable
    public String getUserName() {
        return this.remoteOptional().map(registry -> registry.getCredentials().username()).orElse(null);
    }

    @Nullable
    public String getPrimaryCredential() {
        return this.remoteOptional().map(registry -> registry.getCredentials().accessKeys()).map(map -> (String)map.get(AccessKeyType.PRIMARY)).orElse(null);
    }

    @Nullable
    public String getSecondaryCredential() {
        return this.remoteOptional().map(registry -> registry.getCredentials().accessKeys()).map(map -> (String)map.get(AccessKeyType.SECONDARY)).orElse(null);
    }

    @Nullable
    public String getLoginServerUrl() {
        return this.remoteOptional().map(Registry::loginServerUrl).orElse(null);
    }

    @Nullable
    public String getType() {
        return this.remoteOptional().map(Resource::type).orElse(null);
    }

    @Nullable
    public RegistryTaskRun buildImage(String imageNameWithTag, Path sourceTar) {
        return this.buildImage(imageNameWithTag, sourceTar, "./Dockerfile", Collections.emptyMap());
    }

    @Nullable
    public RegistryTaskRun buildImage(String imageNameWithTag, Path sourceTar, String dockerFilePath, Map<String, OverridingArgument> buildArguments) {
        return this.remoteOptional().map(r -> {
            AzureMessager.getMessager().progress(AzureString.format((String)"Uploading compressed source code to Registry '%s'.", (Object[])new Object[]{this.getName()}));
            SourceUploadDefinition upload = r.getBuildSourceUploadUrl();
            BlockBlobClient blobClient = new SpecializedBlobClientBuilder().endpoint(upload.uploadUrl()).buildBlockBlobClient();
            blobClient.upload(BinaryData.fromFile((Path)sourceTar));
            AzureMessager.getMessager().progress(AzureString.format((String)"Building image '%s' in Registry '%s'.", (Object[])new Object[]{imageNameWithTag, this.getName()}));
            return (RegistryTaskRun)((RegistryTaskRun.DefinitionStages.RunRequestExecutableWithSourceLocation)r.scheduleRun().withLinux().withDockerTaskRunRequest().defineDockerTaskStep().withDockerFilePath(dockerFilePath).withOverridingArguments(buildArguments).withImageNames(Collections.singletonList(imageNameWithTag)).withPushEnabled(true).attach()).withSourceLocation(upload.relativePath()).execute();
        }).orElse(null);
    }

    @Nullable
    public String waitForImageBuilding(@Nonnull RegistryTaskRun run) {
        ImmutableSet errorStatus = ImmutableSet.of((Object)RunStatus.FAILED, (Object)RunStatus.CANCELED, (Object)RunStatus.ERROR, (Object)RunStatus.TIMEOUT);
        ImmutableSet waitingStatus = ImmutableSet.of((Object)RunStatus.QUEUED, (Object)RunStatus.STARTED, (Object)RunStatus.RUNNING);
        ContainerRegistryManager registryManager = (ContainerRegistryManager)Objects.requireNonNull(((AzureContainerRegistryServiceSubscription)this.getParent()).getRemote());
        String logSasUrl = registryManager.registryTaskRuns().getLogSasUrl(this.getResourceGroupName(), this.getName(), run.runId());
        if (!logSasUrl.startsWith("https://") && !logSasUrl.startsWith("http://")) {
            logSasUrl = "https://" + logSasUrl;
        }
        Action openUrl = AzureActionManager.getInstance().getAction(Action.OPEN_URL);
        Action viewLogInBrowser = openUrl.bind((Object)logSasUrl).withLabel("Open streaming logs in browser");
        RegistryTaskRunStreamingLog urlStreamingLog = RegistryTaskRunStreamingLog.builder().logSasUrl(logSasUrl).task(run).build();
        Action viewLogInToolkit = Optional.ofNullable(AzureActionManager.getInstance().getAction(StreamingLogSupport.OPEN_STREAMING_LOG)).map(action -> action.bind((Object)urlStreamingLog).withLabel("Open streaming logs")).orElse(null);
        AzureMessager.getMessager().info(AzureString.format((String)"Waiting for image building task run (%s) to be completed...", (Object[])new Object[]{run.runId()}), new Object[]{viewLogInToolkit, viewLogInBrowser});
        RunStatus status = run.status();
        while (waitingStatus.contains((Object)status)) {
            ResourceManagerUtils.sleep((Duration)Duration.ofSeconds(10L));
            run.refresh();
            status = run.status();
        }
        List images = ((RunInner)run.innerModel()).outputImages();
        if (errorStatus.contains((Object)status) || CollectionUtils.isEmpty((Collection)images)) {
            String message = String.format("Failed to build image (status: %s). View logs at %s for more details.", status, logSasUrl);
            throw new StreamingDiagnosticsException(message, (StreamingLogSupport)urlStreamingLog);
        }
        ImageDescriptor image = (ImageDescriptor)images.get(0);
        String fullImageName = String.format("%s/%s:%s", image.registry(), image.repository(), image.tag());
        AzureMessager.getMessager().info(AzureString.format((String)"Image building task run %s is completed successfully, image %s is built.", (Object[])new Object[]{run.runId(), fullImageName}), new Object[]{viewLogInToolkit, viewLogInBrowser});
        this.refresh();
        ResourceManagerUtils.sleep((Duration)Duration.ofSeconds(3L));
        return fullImageName;
    }

    public RepositoryModule getRepositoryModule() {
        return this.repositoryModule;
    }

    static {
        ContainerRegistry.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerRegistry.java", ContainerRegistry.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enableAdminUser", "com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry", "", "", "", "void"), 91);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "disableAdminUser", "com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry", "", "", "", "void"), 98);
    }
}

