/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.commands.SIRevertCommand;
import com.mks.api.commands.WorkingFileCommandBase;
import com.mks.api.commands.ide.WorkingFile;
import com.mks.api.commands.ide.WorkingFileFactory;
import com.mks.api.commands.ide.WorkingFileList;
import com.mks.api.response.APIException;
import com.mks.api.response.ItemNotFoundException;
import com.mks.api.response.Response;
import java.util.ArrayList;
import java.util.Iterator;

abstract class WFTrackCommandBase
extends WorkingFileCommandBase {
    protected String cpid = null;
    protected boolean allowCreateSubs = true;

    WFTrackCommandBase(CmdRunnerCreator session) throws APIException {
        super(session);
    }

    protected Response revertDeferred(WorkingFileList toBeReverted, boolean overwriteIfDeferred) throws APIException {
        if (toBeReverted.size() == 0) {
            return null;
        }
        SIRevertCommand siRevert = new SIRevertCommand(this.getCmdRunnerCreator());
        siRevert.setOverwriteIfDeferred(overwriteIfDeferred);
        siRevert.setOverwriteIfChanged(false);
        try {
            Response[] response = this.runApiCommand(siRevert, toBeReverted, this.interactive);
            for (int j = 0; j < response.length; ++j) {
                if (response[j] == null || response[j].getAPIException() == null) continue;
                return response[j];
            }
        }
        catch (ItemNotFoundException infx) {
            return null;
        }
        return null;
    }

    public void setCpid(String cpid) {
        this.cpid = cpid;
    }

    public void setAllowCreateSubs(boolean allowCreateSubs) {
        this.allowCreateSubs = allowCreateSubs;
    }

    protected WorkingFileList update(WorkingFileList outdated) throws APIException {
        ArrayList<String> fileNames = new ArrayList<String>();
        Iterator i = outdated.iterator();
        while (i.hasNext()) {
            WorkingFile wf = (WorkingFile)i.next();
            fileNames.add(wf.getFile().getAbsolutePath());
        }
        return WorkingFileFactory.getWorkingFiles(this.getCmdRunnerCreator(), fileNames);
    }
}

