/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.netflix.discovery.util.SpectatorUtil;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.WaitingThreadAborter;
import org.apache.http.params.HttpParams;

public class NamedConnectionPool
extends ConnPoolByRoute {
    private Counter freeEntryCounter;
    private Counter createEntryCounter;
    private Counter requestCounter;
    private Counter releaseCounter;
    private Counter deleteCounter;
    private Timer requestTimer;
    private Timer creationTimer;
    private String name;

    public NamedConnectionPool(String name, ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections, long connTTL, TimeUnit connTTLTimeUnit) {
        super(operator, connPerRoute, maxTotalConnections, connTTL, connTTLTimeUnit);
        this.initMonitors(name);
    }

    public NamedConnectionPool(String name, ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections) {
        super(operator, connPerRoute, maxTotalConnections);
        this.initMonitors(name);
    }

    public NamedConnectionPool(String name, ClientConnectionOperator operator, HttpParams params) {
        super(operator, params);
        this.initMonitors(name);
    }

    NamedConnectionPool(ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections, long connTTL, TimeUnit connTTLTimeUnit) {
        super(operator, connPerRoute, maxTotalConnections, connTTL, connTTLTimeUnit);
    }

    NamedConnectionPool(ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections) {
        super(operator, connPerRoute, maxTotalConnections);
    }

    NamedConnectionPool(ClientConnectionOperator operator, HttpParams params) {
        super(operator, params);
    }

    void initMonitors(String name) {
        Objects.requireNonNull(name);
        this.freeEntryCounter = SpectatorUtil.counter(name + "_Reuse", name, NamedConnectionPool.class);
        this.createEntryCounter = SpectatorUtil.counter(name + "_CreateNew", name, NamedConnectionPool.class);
        this.requestCounter = SpectatorUtil.counter(name + "_Request", name, NamedConnectionPool.class);
        this.releaseCounter = SpectatorUtil.counter(name + "_Release", name, NamedConnectionPool.class);
        this.deleteCounter = SpectatorUtil.counter(name + "_Delete", name, NamedConnectionPool.class);
        this.requestTimer = SpectatorUtil.timer(name + "_RequestConnectionTimer", name, NamedConnectionPool.class);
        this.creationTimer = SpectatorUtil.timer(name + "_CreateConnectionTimer", name, NamedConnectionPool.class);
        SpectatorUtil.monitoredValue("connectionCount", name, this, ConnPoolByRoute::getConnectionsInPool);
        this.name = name;
    }

    public PoolEntryRequest requestPoolEntry(HttpRoute route, Object state) {
        this.requestCounter.increment();
        return super.requestPoolEntry(route, state);
    }

    protected BasicPoolEntry getFreeEntry(RouteSpecificPool rospl, Object state) {
        BasicPoolEntry entry = super.getFreeEntry(rospl, state);
        if (entry != null) {
            this.freeEntryCounter.increment();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry createEntry(RouteSpecificPool rospl, ClientConnectionOperator op) {
        this.createEntryCounter.increment();
        long monotonicTime = SpectatorUtil.time(this.creationTimer);
        try {
            BasicPoolEntry basicPoolEntry = super.createEntry(rospl, op);
            return basicPoolEntry;
        }
        finally {
            SpectatorUtil.record(this.creationTimer, monotonicTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry getEntryBlocking(HttpRoute route, Object state, long timeout, TimeUnit tunit, WaitingThreadAborter aborter) throws ConnectionPoolTimeoutException, InterruptedException {
        long monotonicTime = SpectatorUtil.time(this.requestTimer);
        try {
            BasicPoolEntry basicPoolEntry = super.getEntryBlocking(route, state, timeout, tunit, aborter);
            return basicPoolEntry;
        }
        finally {
            SpectatorUtil.record(this.requestTimer, monotonicTime);
        }
    }

    public void freeEntry(BasicPoolEntry entry, boolean reusable, long validDuration, TimeUnit timeUnit) {
        this.releaseCounter.increment();
        super.freeEntry(entry, reusable, validDuration, timeUnit);
    }

    protected void deleteEntry(BasicPoolEntry entry) {
        this.deleteCounter.increment();
        super.deleteEntry(entry);
    }

    public final long getFreeEntryCount() {
        return this.freeEntryCounter.count();
    }

    public final long getCreatedEntryCount() {
        return this.createEntryCounter.count();
    }

    public final long getRequestsCount() {
        return this.requestCounter.count();
    }

    public final long getReleaseCount() {
        return this.releaseCounter.count();
    }

    public final long getDeleteCount() {
        return this.deleteCounter.count();
    }

    public void shutdown() {
        super.shutdown();
    }
}

