/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.core;

import com.netflix.nebula.lint.jdt.core.IClassFile;
import com.netflix.nebula.lint.jdt.core.ICodeFormatter;
import com.netflix.nebula.lint.jdt.core.IPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.core.JavaCore;
import com.netflix.nebula.lint.jdt.core.ToolFactory;
import com.netflix.nebula.lint.jdt.core.compiler.IScanner;
import com.netflix.nebula.lint.jdt.core.formatter.CodeFormatter;
import com.netflix.nebula.lint.jdt.core.util.ClassFileBytesDisassembler;
import com.netflix.nebula.lint.jdt.core.util.ClassFormatException;
import com.netflix.nebula.lint.jdt.core.util.IClassFileDisassembler;
import com.netflix.nebula.lint.jdt.core.util.IClassFileReader;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.CompilerOptions;
import com.netflix.nebula.lint.jdt.internal.compiler.util.Util;
import com.netflix.nebula.lint.jdt.internal.core.JarPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.util.ClassFileReader;
import com.netflix.nebula.lint.jdt.internal.core.util.Disassembler;
import com.netflix.nebula.lint.jdt.internal.core.util.PublicScanner;
import com.netflix.nebula.lint.jdt.internal.formatter.DefaultCodeFormatter;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class ToolFactory {
    public static ICodeFormatter createCodeFormatter() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint("codeFormatter");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    try {
                        Object execExt = configElements[j].createExecutableExtension("class");
                        if (execExt instanceof ICodeFormatter) {
                            return (ICodeFormatter)execExt;
                        }
                    }
                    catch (CoreException coreException) {}
                    ++j;
                }
                ++i;
            }
        }
        return ToolFactory.createDefaultCodeFormatter(null);
    }

    public static CodeFormatter createCodeFormatter(Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        return new DefaultCodeFormatter(options);
    }

    public static ICodeFormatter createDefaultCodeFormatter(Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        return new com.netflix.nebula.lint.jdt.internal.formatter.old.CodeFormatter(options);
    }

    public static IClassFileDisassembler createDefaultClassFileDisassembler() {
        class DeprecatedDisassembler
        extends Disassembler
        implements IClassFileDisassembler {
            DeprecatedDisassembler() {
            }
        }
        return new DeprecatedDisassembler();
    }

    public static ClassFileBytesDisassembler createDefaultClassFileBytesDisassembler() {
        return new Disassembler();
    }

    public static IClassFileReader createDefaultClassFileReader(String fileName, int decodingFlag) {
        try {
            return new ClassFileReader(Util.getFileByteContent(new File(fileName)), decodingFlag);
        }
        catch (ClassFormatException classFormatException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClassFileReader createDefaultClassFileReader(IClassFile classfile, int decodingFlag) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)classfile.getAncestor(3);
        if (root != null) {
            try {
                if (root instanceof JarPackageFragmentRoot) {
                    String archiveName = null;
                    ZipFile jar = null;
                    try {
                        jar = ((JarPackageFragmentRoot)root).getJar();
                        archiveName = jar.getName();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(jar);
                        throw throwable;
                    }
                    {
                        Object var5_9 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(jar);
                    }
                    PackageFragment packageFragment = (PackageFragment)classfile.getParent();
                    String classFileName = classfile.getElementName();
                    String entryName = com.netflix.nebula.lint.jdt.internal.core.util.Util.concatWith(packageFragment.names, classFileName, '/');
                    return ToolFactory.createDefaultClassFileReader(archiveName, entryName, decodingFlag);
                }
                IPath location = classfile.getResource().getLocation();
                if (location == null) {
                    return null;
                }
                return ToolFactory.createDefaultClassFileReader(location.toOSString(), decodingFlag);
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClassFileReader createDefaultClassFileReader(String zipFileName, String zipEntryName, int decodingFlag) {
        ClassFileReader classFileReader;
        ZipFile zipFile;
        block17: {
            IClassFileReader iClassFileReader;
            block16: {
                IClassFileReader iClassFileReader2;
                block15: {
                    zipFile = null;
                    try {
                        try {
                            ZipEntry zipEntry;
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [ToolFactory.createDefaultClassFileReader()] Creating ZipFile on " + zipFileName);
                            }
                            if ((zipEntry = (zipFile = new ZipFile(zipFileName)).getEntry(zipEntryName)) == null) {
                                iClassFileReader2 = null;
                                Object var6_10 = null;
                                if (zipFile == null) return iClassFileReader2;
                                break block15;
                            }
                            if (!zipEntryName.toLowerCase().endsWith(".class")) {
                                iClassFileReader = null;
                                break block16;
                            }
                            byte[] classFileBytes = Util.getZipEntryByteContent(zipEntry, zipFile);
                            classFileReader = new ClassFileReader(classFileBytes, decodingFlag);
                            break block17;
                        }
                        catch (ClassFormatException classFormatException) {
                            IClassFileReader iClassFileReader3 = null;
                            Object var6_13 = null;
                            if (zipFile == null) return iClassFileReader3;
                            try {
                                zipFile.close();
                                return iClassFileReader3;
                            }
                            catch (IOException iOException) {}
                            return iClassFileReader3;
                        }
                        catch (IOException iOException) {
                            IClassFileReader iClassFileReader4 = null;
                            Object var6_14 = null;
                            if (zipFile == null) return iClassFileReader4;
                            try {}
                            catch (IOException iOException2) {}
                            zipFile.close();
                            return iClassFileReader4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_15 = null;
                        if (zipFile == null) throw throwable;
                        try {}
                        catch (IOException iOException) {
                            throw throwable;
                        }
                        zipFile.close();
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                zipFile.close();
                return iClassFileReader2;
            }
            Object var6_11 = null;
            if (zipFile == null) return iClassFileReader;
            try {}
            catch (IOException iOException) {}
            zipFile.close();
            return iClassFileReader;
        }
        Object var6_12 = null;
        if (zipFile == null) return classFileReader;
        try {}
        catch (IOException iOException) {}
        zipFile.close();
        return classFileReader;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, assertMode ? 0x300000L : 0x2F0000L, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel) {
        PublicScanner scanner = null;
        long level = CompilerOptions.versionToJdkLevel(sourceLevel);
        if (level == 0L) {
            level = 0x2F0000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, level, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel, String complianceLevel) {
        long complianceLevelValue;
        PublicScanner scanner = null;
        long sourceLevelValue = CompilerOptions.versionToJdkLevel(sourceLevel);
        if (sourceLevelValue == 0L) {
            sourceLevelValue = 0x2F0000L;
        }
        if ((complianceLevelValue = CompilerOptions.versionToJdkLevel(complianceLevel)) == 0L) {
            complianceLevelValue = 0x2F0000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, sourceLevelValue, complianceLevelValue, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }
}

