/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.core.dom;

import com.netflix.nebula.lint.jdt.core.WorkingCopyOwner;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.dom.ASTNode;
import com.netflix.nebula.lint.jdt.core.dom.AnnotationTypeDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.AnnotationTypeMemberDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.AnonymousClassDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.ArrayType;
import com.netflix.nebula.lint.jdt.core.dom.BindingResolver;
import com.netflix.nebula.lint.jdt.core.dom.ClassInstanceCreation;
import com.netflix.nebula.lint.jdt.core.dom.ConstructorInvocation;
import com.netflix.nebula.lint.jdt.core.dom.EnumConstantDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.EnumDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.Expression;
import com.netflix.nebula.lint.jdt.core.dom.FieldAccess;
import com.netflix.nebula.lint.jdt.core.dom.IBinding;
import com.netflix.nebula.lint.jdt.core.dom.IMethodBinding;
import com.netflix.nebula.lint.jdt.core.dom.IPackageBinding;
import com.netflix.nebula.lint.jdt.core.dom.ITypeBinding;
import com.netflix.nebula.lint.jdt.core.dom.IVariableBinding;
import com.netflix.nebula.lint.jdt.core.dom.ImportDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.MemberRef;
import com.netflix.nebula.lint.jdt.core.dom.MethodBinding;
import com.netflix.nebula.lint.jdt.core.dom.MethodDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.MethodInvocation;
import com.netflix.nebula.lint.jdt.core.dom.MethodRef;
import com.netflix.nebula.lint.jdt.core.dom.Name;
import com.netflix.nebula.lint.jdt.core.dom.PackageBinding;
import com.netflix.nebula.lint.jdt.core.dom.PackageDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.ParameterizedType;
import com.netflix.nebula.lint.jdt.core.dom.ParenthesizedExpression;
import com.netflix.nebula.lint.jdt.core.dom.PrimitiveType;
import com.netflix.nebula.lint.jdt.core.dom.QualifiedType;
import com.netflix.nebula.lint.jdt.core.dom.SuperConstructorInvocation;
import com.netflix.nebula.lint.jdt.core.dom.SuperFieldAccess;
import com.netflix.nebula.lint.jdt.core.dom.SuperMethodInvocation;
import com.netflix.nebula.lint.jdt.core.dom.Type;
import com.netflix.nebula.lint.jdt.core.dom.TypeBinding;
import com.netflix.nebula.lint.jdt.core.dom.TypeDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.TypeParameter;
import com.netflix.nebula.lint.jdt.core.dom.VariableBinding;
import com.netflix.nebula.lint.jdt.core.dom.VariableDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.VariableDeclarationExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.AllocationExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ArrayAllocationExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ExplicitConstructorCall;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.FieldDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.FieldReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ImportReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocAllocationExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocFieldReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocImplicitTypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocMessageSend;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Literal;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.LocalDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.MemberValuePair;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.MessageSend;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.QualifiedNameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.QualifiedSuperReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.QualifiedTypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.SingleNameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.SingleTypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ThisReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.Constant;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ArrayBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BaseTypes;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Binding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.CompilationUnitScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.FieldBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.LocalVariableBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.LookupEnvironment;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ProblemFieldBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Scope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeConstants;
import com.netflix.nebula.lint.jdt.internal.compiler.problem.AbortCompilation;
import java.util.HashMap;
import java.util.Map;

class DefaultBindingResolver
extends BindingResolver {
    Map astNodesToBlockScope;
    Map bindingsToAstNodes;
    BindingTables bindingTables;
    Map newAstToOldAst = new HashMap();
    private CompilationUnitScope scope;
    WorkingCopyOwner workingCopyOwner;

    DefaultBindingResolver(CompilationUnitScope scope, WorkingCopyOwner workingCopyOwner, BindingTables bindingTables) {
        this.astNodesToBlockScope = new HashMap();
        this.bindingsToAstNodes = new HashMap();
        this.bindingTables = bindingTables;
        this.scope = scope;
        this.workingCopyOwner = workingCopyOwner;
    }

    DefaultBindingResolver(LookupEnvironment lookupEnvironment, WorkingCopyOwner workingCopyOwner, BindingTables bindingTables) {
        this.astNodesToBlockScope = new HashMap();
        this.bindingsToAstNodes = new HashMap();
        this.bindingTables = bindingTables;
        this.scope = new CompilationUnitScope(new CompilationUnitDeclaration(null, null, -1), lookupEnvironment);
        this.workingCopyOwner = workingCopyOwner;
    }

    synchronized ASTNode findDeclaringNode(IBinding binding) {
        if (binding == null) {
            return null;
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)binding;
            return (ASTNode)this.bindingsToAstNodes.get(methodBinding.getMethodDeclaration());
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            return (ASTNode)this.bindingsToAstNodes.get(typeBinding.getTypeDeclaration());
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            return (ASTNode)this.bindingsToAstNodes.get(variableBinding.getVariableDeclaration());
        }
        return (ASTNode)this.bindingsToAstNodes.get(binding);
    }

    synchronized ASTNode findDeclaringNode(String bindingKey) {
        if (bindingKey == null) {
            return null;
        }
        Object binding = this.bindingTables.bindingKeysToBindings.get(bindingKey);
        if (binding == null) {
            return null;
        }
        return (ASTNode)this.bindingsToAstNodes.get(binding);
    }

    IBinding getBinding(Binding binding) {
        switch (binding.kind()) {
            case 16: {
                return this.getPackageBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding)binding);
            }
            case 4: 
            case 132: 
            case 260: 
            case 1028: 
            case 2052: {
                return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
            }
            case 68: 
            case 4100: {
                return new TypeBinding(this, (com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
            }
            case 8: {
                return this.getMethodBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding)binding);
            }
            case 1: 
            case 2: {
                return this.getVariableBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.VariableBinding)binding);
            }
        }
        return null;
    }

    synchronized com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode getCorrespondingNode(ASTNode currentNode) {
        return (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(currentNode);
    }

    synchronized IMethodBinding getMethodBinding(com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding methodBinding) {
        if (methodBinding != null) {
            if (methodBinding.isValidBinding()) {
                IMethodBinding binding = (IMethodBinding)this.bindingTables.compilerBindingsToASTBindings.get(methodBinding);
                if (binding != null) {
                    return binding;
                }
                binding = new MethodBinding(this, methodBinding);
                this.bindingTables.compilerBindingsToASTBindings.put(methodBinding, binding);
                return binding;
            }
            switch (methodBinding.problemId()) {
                case 2: 
                case 6: 
                case 7: {
                    com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding exactBinding;
                    ReferenceBinding declaringClass = methodBinding.declaringClass;
                    if (declaringClass == null || (exactBinding = declaringClass.getExactMethod(methodBinding.selector, methodBinding.parameters, null)) == null) break;
                    IMethodBinding binding = (IMethodBinding)this.bindingTables.compilerBindingsToASTBindings.get(exactBinding);
                    if (binding != null) {
                        return binding;
                    }
                    binding = new MethodBinding(this, exactBinding);
                    this.bindingTables.compilerBindingsToASTBindings.put(exactBinding, binding);
                    return binding;
                }
            }
        }
        return null;
    }

    synchronized IPackageBinding getPackageBinding(com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding packageBinding) {
        if (packageBinding == null || !packageBinding.isValidBinding()) {
            return null;
        }
        IPackageBinding binding = (IPackageBinding)this.bindingTables.compilerBindingsToASTBindings.get(packageBinding);
        if (binding != null) {
            return binding;
        }
        binding = new PackageBinding(packageBinding);
        this.bindingTables.compilerBindingsToASTBindings.put(packageBinding, binding);
        return binding;
    }

    private int getTypeArguments(ParameterizedQualifiedTypeReference typeReference) {
        TypeReference[][] typeArguments = typeReference.typeArguments;
        int value = 0;
        int i = 0;
        int max = typeArguments.length;
        while (i < max) {
            if (typeArguments[i] != null || value != 0) {
                ++value;
            }
            ++i;
        }
        return value;
    }

    synchronized ITypeBinding getTypeBinding(com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding referenceBinding) {
        if (referenceBinding == null) {
            return null;
        }
        if (!referenceBinding.isValidBinding()) {
            switch (referenceBinding.problemId()) {
                case 2: 
                case 7: {
                    if (!(referenceBinding instanceof ProblemReferenceBinding)) break;
                    ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)referenceBinding;
                    ReferenceBinding binding2 = problemReferenceBinding.closestMatch;
                    if (binding2 == null || !(binding2 instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)) break;
                    TypeBinding binding = (TypeBinding)this.bindingTables.compilerBindingsToASTBindings.get(binding2);
                    if (binding != null) {
                        return binding;
                    }
                    binding = new TypeBinding(this, binding2);
                    this.bindingTables.compilerBindingsToASTBindings.put(binding2, binding);
                    return binding;
                }
            }
            return null;
        }
        TypeBinding binding = (TypeBinding)this.bindingTables.compilerBindingsToASTBindings.get(referenceBinding);
        if (binding != null) {
            return binding;
        }
        binding = new TypeBinding(this, referenceBinding);
        this.bindingTables.compilerBindingsToASTBindings.put(referenceBinding, binding);
        return binding;
    }

    synchronized IVariableBinding getVariableBinding(com.netflix.nebula.lint.jdt.internal.compiler.lookup.VariableBinding variableBinding) {
        if (variableBinding != null) {
            if (variableBinding.isValidBinding()) {
                if (variableBinding.type != null) {
                    IVariableBinding binding = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(variableBinding);
                    if (binding != null) {
                        return binding;
                    }
                    binding = new VariableBinding(this, variableBinding);
                    this.bindingTables.compilerBindingsToASTBindings.put(variableBinding, binding);
                    return binding;
                }
            } else if (variableBinding instanceof ProblemFieldBinding) {
                ProblemFieldBinding problemFieldBinding = (ProblemFieldBinding)variableBinding;
                switch (problemFieldBinding.problemId()) {
                    case 2: 
                    case 6: 
                    case 7: {
                        ReferenceBinding declaringClass = problemFieldBinding.declaringClass;
                        FieldBinding exactBinding = declaringClass.getField(problemFieldBinding.name, true);
                        if (exactBinding == null) break;
                        IVariableBinding variableBinding2 = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(exactBinding);
                        if (variableBinding2 != null) {
                            return variableBinding2;
                        }
                        variableBinding2 = new VariableBinding(this, exactBinding);
                        this.bindingTables.compilerBindingsToASTBindings.put(exactBinding, variableBinding2);
                        return variableBinding2;
                    }
                }
            }
        }
        return null;
    }

    LookupEnvironment lookupEnvironment() {
        return this.scope.environment();
    }

    synchronized void recordScope(ASTNode astNode, BlockScope blockScope) {
        this.astNodesToBlockScope.put(astNode, blockScope);
    }

    boolean resolveBoxing(Expression expression) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node != null && node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression) {
            com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression compilerExpression = (com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression)node;
            return (compilerExpression.implicitConversion & 0x200) != 0;
        }
        return false;
    }

    boolean resolveUnboxing(Expression expression) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node != null && node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression) {
            com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression compilerExpression = (com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression)node;
            return (compilerExpression.implicitConversion & 0x400) != 0;
        }
        return false;
    }

    Object resolveConstantExpressionValue(Expression expression) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node != null && node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression) {
            com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression compilerExpression = (com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression)node;
            Constant constant = compilerExpression.constant;
            if (constant != null && constant != Constant.NotAConstant) {
                switch (constant.typeID()) {
                    case 10: {
                        return new Integer(constant.intValue());
                    }
                    case 3: {
                        return new Byte(constant.byteValue());
                    }
                    case 4: {
                        return new Short(constant.shortValue());
                    }
                    case 2: {
                        return new Character(constant.charValue());
                    }
                    case 9: {
                        return new Float(constant.floatValue());
                    }
                    case 8: {
                        return new Double(constant.doubleValue());
                    }
                    case 5: {
                        return constant.booleanValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 7: {
                        return new Long(constant.longValue());
                    }
                    case 11: {
                        return constant.stringValue();
                    }
                }
                return null;
            }
        }
        return null;
    }

    synchronized IMethodBinding resolveConstructor(ClassInstanceCreation expression) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node != null && (node.bits & 0x200) != 0) {
            com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration anonymousLocalTypeDeclaration = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration)node;
            return this.getMethodBinding(anonymousLocalTypeDeclaration.allocation.binding);
        }
        if (node instanceof AllocationExpression) {
            return this.getMethodBinding(((AllocationExpression)node).binding);
        }
        return null;
    }

    synchronized IMethodBinding resolveConstructor(ConstructorInvocation expression) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node instanceof ExplicitConstructorCall) {
            ExplicitConstructorCall explicitConstructorCall = (ExplicitConstructorCall)node;
            return this.getMethodBinding(explicitConstructorCall.binding);
        }
        return null;
    }

    IMethodBinding resolveConstructor(EnumConstantDeclaration enumConstantDeclaration) {
        FieldDeclaration fieldDeclaration;
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(enumConstantDeclaration);
        if (node instanceof FieldDeclaration && (fieldDeclaration = (FieldDeclaration)node).getKind() == 3 && fieldDeclaration.initialization != null) {
            AllocationExpression allocationExpression = (AllocationExpression)fieldDeclaration.initialization;
            return this.getMethodBinding(allocationExpression.binding);
        }
        return null;
    }

    synchronized IMethodBinding resolveConstructor(SuperConstructorInvocation expression) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node instanceof ExplicitConstructorCall) {
            ExplicitConstructorCall explicitConstructorCall = (ExplicitConstructorCall)node;
            return this.getMethodBinding(explicitConstructorCall.binding);
        }
        return null;
    }

    synchronized ITypeBinding resolveExpressionType(Expression expression) {
        switch (expression.getNodeType()) {
            case 14: {
                com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode astNode = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
                if (astNode instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration) {
                    com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration)astNode;
                    if (typeDeclaration != null) {
                        ITypeBinding typeBinding = this.getTypeBinding(typeDeclaration.binding);
                        if (typeBinding == null) {
                            return null;
                        }
                        return typeBinding;
                    }
                } else {
                    AllocationExpression allocationExpression = (AllocationExpression)astNode;
                    return this.getTypeBinding(allocationExpression.resolvedType);
                }
                return null;
            }
            case 40: 
            case 42: {
                return this.resolveTypeBindingForName((Name)expression);
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 22: 
            case 27: 
            case 32: 
            case 37: 
            case 38: 
            case 47: 
            case 48: 
            case 57: 
            case 62: 
            case 77: 
            case 78: 
            case 79: {
                com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression compilerExpression = (com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression)this.newAstToOldAst.get(expression);
                if (compilerExpression == null) {
                    return null;
                }
                return this.getTypeBinding(compilerExpression.resolvedType);
            }
            case 45: {
                return this.getTypeBinding(this.scope.getJavaLangString());
            }
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                Literal literal = (Literal)this.newAstToOldAst.get(expression);
                return this.getTypeBinding(literal.literalType(null));
            }
            case 52: {
                ThisReference thisReference = (ThisReference)this.newAstToOldAst.get(expression);
                BlockScope blockScope = (BlockScope)this.astNodesToBlockScope.get(expression);
                if (blockScope == null) {
                    return null;
                }
                return this.getTypeBinding(thisReference.resolveType(blockScope));
            }
            case 36: {
                ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression;
                return this.resolveExpressionType(parenthesizedExpression.getExpression());
            }
            case 58: {
                VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)expression;
                Type type = variableDeclarationExpression.getType();
                if (type != null) {
                    return type.resolveBinding();
                }
                return null;
            }
        }
        return null;
    }

    synchronized IVariableBinding resolveField(FieldAccess fieldAccess) {
        FieldReference fieldReference;
        Object oldNode = this.newAstToOldAst.get(fieldAccess);
        if (oldNode instanceof FieldReference && (fieldReference = (FieldReference)oldNode) != null) {
            return this.getVariableBinding(fieldReference.binding);
        }
        return null;
    }

    synchronized IVariableBinding resolveField(SuperFieldAccess fieldAccess) {
        FieldReference fieldReference;
        Object oldNode = this.newAstToOldAst.get(fieldAccess);
        if (oldNode instanceof FieldReference && (fieldReference = (FieldReference)oldNode) != null) {
            return this.getVariableBinding(fieldReference.binding);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized IBinding resolveImport(ImportDeclaration importDeclaration) {
        try {
            com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(importDeclaration);
            if (!(node instanceof ImportReference)) return null;
            ImportReference importReference = (ImportReference)node;
            boolean isStatic = importReference.isStatic();
            if (importReference.onDemand) {
                Binding binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, importReference.tokens.length), true, isStatic);
                if (binding == null) return null;
                if (isStatic) {
                    if (!(binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)) return null;
                    ITypeBinding typeBinding = this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
                    if (typeBinding == null) {
                        return null;
                    }
                    ITypeBinding iTypeBinding = typeBinding;
                    return iTypeBinding;
                }
                if ((binding.kind() & 0x10) != 0) {
                    IPackageBinding packageBinding = this.getPackageBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding)binding);
                    if (packageBinding != null) return packageBinding;
                    return null;
                }
                ITypeBinding typeBinding = this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
                if (typeBinding != null) return typeBinding;
                return null;
            }
            Binding binding = this.scope.getImport(importReference.tokens, false, isStatic);
            if (binding == null) return null;
            if (isStatic) {
                if (binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding) {
                    ITypeBinding typeBinding = this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
                    if (typeBinding == null) {
                        return null;
                    }
                    ITypeBinding iTypeBinding = typeBinding;
                    return iTypeBinding;
                }
                if (binding instanceof FieldBinding) {
                    IVariableBinding variableBinding = this.getVariableBinding((FieldBinding)binding);
                    if (variableBinding == null) {
                        return null;
                    }
                    IVariableBinding iVariableBinding = variableBinding;
                    return iVariableBinding;
                }
                if (!(binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding)) return null;
                return this.getMethodBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding)binding);
            }
            if (!(binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)) return null;
            ITypeBinding typeBinding = this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
            if (typeBinding == null) {
                return null;
            }
            ITypeBinding iTypeBinding = typeBinding;
            return iTypeBinding;
        }
        catch (RuntimeException runtimeException) {}
        return null;
    }

    IMethodBinding resolveMember(AnnotationTypeMemberDeclaration declaration) {
        AbstractMethodDeclaration methodDeclaration;
        Object oldNode = this.newAstToOldAst.get(declaration);
        if (oldNode instanceof AbstractMethodDeclaration && (methodDeclaration = (AbstractMethodDeclaration)oldNode) != null) {
            IMethodBinding methodBinding = this.getMethodBinding(methodDeclaration.binding);
            if (methodBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(methodBinding, declaration);
            String key = methodBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, methodBinding);
            }
            return methodBinding;
        }
        return null;
    }

    synchronized IMethodBinding resolveMethod(MethodDeclaration method) {
        AbstractMethodDeclaration methodDeclaration;
        Object oldNode = this.newAstToOldAst.get(method);
        if (oldNode instanceof AbstractMethodDeclaration && (methodDeclaration = (AbstractMethodDeclaration)oldNode) != null) {
            IMethodBinding methodBinding = this.getMethodBinding(methodDeclaration.binding);
            if (methodBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(methodBinding, method);
            String key = methodBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, methodBinding);
            }
            return methodBinding;
        }
        return null;
    }

    synchronized IMethodBinding resolveMethod(MethodInvocation method) {
        MessageSend messageSend;
        Object oldNode = this.newAstToOldAst.get(method);
        if (oldNode instanceof MessageSend && (messageSend = (MessageSend)oldNode) != null) {
            return this.getMethodBinding(messageSend.binding);
        }
        return null;
    }

    synchronized IMethodBinding resolveMethod(SuperMethodInvocation method) {
        MessageSend messageSend;
        Object oldNode = this.newAstToOldAst.get(method);
        if (oldNode instanceof MessageSend && (messageSend = (MessageSend)oldNode) != null) {
            return this.getMethodBinding(messageSend.binding);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized ITypeBinding resolveTypeBindingForName(Name name) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node;
        block53: {
            block55: {
                int index;
                block54: {
                    block52: {
                        node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(name);
                        index = name.index;
                        if (!(node instanceof QualifiedNameReference)) break block52;
                        QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)node;
                        char[][] tokens = qualifiedNameReference.tokens;
                        if (tokens.length == index) {
                            return this.getTypeBinding(qualifiedNameReference.resolvedType);
                        }
                        int indexOfFirstFieldBinding = qualifiedNameReference.indexOfFirstFieldBinding;
                        if (index < indexOfFirstFieldBinding) {
                            void var8_24;
                            BlockScope internalScope = (BlockScope)this.astNodesToBlockScope.get(name);
                            Object var8_21 = null;
                            try {
                                if (internalScope == null) {
                                    Binding binding = this.scope.getTypeOrPackage(CharOperation.subarray(tokens, 0, index));
                                } else {
                                    Binding binding = internalScope.getTypeOrPackage(CharOperation.subarray(tokens, 0, index));
                                }
                            }
                            catch (RuntimeException runtimeException) {}
                            if (var8_24 instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding) {
                                return null;
                            }
                            if (var8_24 instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding) {
                                return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)var8_24);
                            }
                            break block53;
                        } else {
                            void var9_33;
                            if (index == indexOfFirstFieldBinding) {
                                void var8_28;
                                if (qualifiedNameReference.isTypeReference()) {
                                    return this.getTypeBinding(qualifiedNameReference.resolvedType);
                                }
                                if (qualifiedNameReference.otherBindings == null) {
                                    return null;
                                }
                                FieldBinding fieldBinding = qualifiedNameReference.otherBindings[0];
                                if (fieldBinding == null) {
                                    return null;
                                }
                                ReferenceBinding referenceBinding = fieldBinding.declaringClass;
                                if (referenceBinding != null) return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)var8_28);
                                switch (qualifiedNameReference.bits & 7) {
                                    case 1: {
                                        com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding typeBinding = ((FieldBinding)qualifiedNameReference.binding).type;
                                        return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)var8_28);
                                    }
                                    case 2: {
                                        com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding typeBinding = ((LocalVariableBinding)qualifiedNameReference.binding).type;
                                        return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)var8_28);
                                    }
                                }
                                return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)var8_28);
                            }
                            if (qualifiedNameReference.otherBindings == null) {
                                return null;
                            }
                            int otherBindingsLength = qualifiedNameReference.otherBindings.length;
                            if (otherBindingsLength == index - indexOfFirstFieldBinding) {
                                return this.getTypeBinding(qualifiedNameReference.resolvedType);
                            }
                            FieldBinding fieldBinding = qualifiedNameReference.otherBindings[index - indexOfFirstFieldBinding];
                            if (fieldBinding == null) {
                                return null;
                            }
                            ReferenceBinding referenceBinding = fieldBinding.declaringClass;
                            if (referenceBinding != null) return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)var9_33);
                            FieldBinding fieldBinding2 = qualifiedNameReference.otherBindings[index - indexOfFirstFieldBinding - 1];
                            if (fieldBinding2 == null) {
                                return null;
                            }
                            com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding typeBinding = fieldBinding2.type;
                            return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)var9_33);
                        }
                    }
                    if (!(node instanceof QualifiedTypeReference)) break block54;
                    QualifiedTypeReference qualifiedTypeReference = (QualifiedTypeReference)node;
                    if (qualifiedTypeReference.resolvedType == null) {
                        return null;
                    }
                    if (index == qualifiedTypeReference.tokens.length) {
                        if (qualifiedTypeReference.resolvedType.isValidBinding()) return this.getTypeBinding(qualifiedTypeReference.resolvedType.leafComponentType());
                        if (!(qualifiedTypeReference instanceof JavadocQualifiedTypeReference)) return this.getTypeBinding(qualifiedTypeReference.resolvedType.leafComponentType());
                        JavadocQualifiedTypeReference typeRef = (JavadocQualifiedTypeReference)node;
                        if (typeRef.packageBinding == null) return this.getTypeBinding(qualifiedTypeReference.resolvedType.leafComponentType());
                        return null;
                    }
                    if (index >= 0) {
                        BlockScope internalScope = (BlockScope)this.astNodesToBlockScope.get(name);
                        Binding binding = null;
                        try {
                            binding = internalScope == null ? this.scope.getTypeOrPackage(CharOperation.subarray(qualifiedTypeReference.tokens, 0, index)) : internalScope.getTypeOrPackage(CharOperation.subarray(qualifiedTypeReference.tokens, 0, index));
                        }
                        catch (RuntimeException runtimeException) {}
                        if (binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding) {
                            return null;
                        }
                        if (!(binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)) return null;
                        return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
                    }
                    break block53;
                }
                if (!(node instanceof ImportReference)) break block55;
                ImportReference importReference = (ImportReference)node;
                int importReferenceLength = importReference.tokens.length;
                if (index >= 0) {
                    Binding binding = null;
                    if (importReferenceLength == index) {
                        try {
                            binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, index), importReference.onDemand, importReference.isStatic());
                        }
                        catch (RuntimeException runtimeException) {}
                    } else {
                        try {
                            binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, index), true, importReference.isStatic());
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                    if (binding != null) {
                        if (!(binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)) return null;
                        return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
                    }
                }
                break block53;
            }
            if (node instanceof AbstractMethodDeclaration) {
                AbstractMethodDeclaration methodDeclaration = (AbstractMethodDeclaration)node;
                if (methodDeclaration != null) {
                    IMethodBinding method = this.getMethodBinding(methodDeclaration.binding);
                    if (method != null) return method.getReturnType();
                    return null;
                }
            } else if (node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration) {
                com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration)node;
                ITypeBinding typeBinding = this.getTypeBinding(typeDeclaration.binding);
                if (typeBinding != null) {
                    return typeBinding;
                }
            }
        }
        if (node instanceof SingleNameReference) {
            SingleNameReference singleNameReference = (SingleNameReference)node;
            return this.getTypeBinding(singleNameReference.resolvedType);
        }
        if (node instanceof QualifiedSuperReference) {
            QualifiedSuperReference qualifiedSuperReference = (QualifiedSuperReference)node;
            return this.getTypeBinding(qualifiedSuperReference.qualification.resolvedType);
        }
        if (node instanceof LocalDeclaration) {
            IVariableBinding variable = this.getVariableBinding(((LocalDeclaration)node).binding);
            if (variable != null) return variable.getType();
            return null;
        }
        if (node instanceof JavadocFieldReference) {
            JavadocFieldReference fieldRef = (JavadocFieldReference)node;
            if (fieldRef.methodBinding == null) return this.getTypeBinding(fieldRef.resolvedType);
            return this.getMethodBinding(fieldRef.methodBinding).getReturnType();
        }
        if (node instanceof FieldReference) {
            return this.getTypeBinding(((FieldReference)node).resolvedType);
        }
        if (node instanceof SingleTypeReference) {
            SingleTypeReference singleTypeReference = (SingleTypeReference)node;
            com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding binding = singleTypeReference.resolvedType;
            if (binding == null) return null;
            return this.getTypeBinding(binding.leafComponentType());
        }
        if (node instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
            IVariableBinding field = this.getVariableBinding(fieldDeclaration.binding);
            if (field != null) return field.getType();
            return null;
        }
        if (node instanceof MessageSend) {
            MessageSend messageSend = (MessageSend)node;
            IMethodBinding method = this.getMethodBinding(messageSend.binding);
            if (method != null) return method.getReturnType();
            return null;
        }
        if (node instanceof AllocationExpression) {
            AllocationExpression allocation = (AllocationExpression)node;
            return this.getTypeBinding(allocation.resolvedType);
        }
        if (node instanceof JavadocImplicitTypeReference) {
            JavadocImplicitTypeReference implicitRef = (JavadocImplicitTypeReference)node;
            return this.getTypeBinding(implicitRef.resolvedType);
        }
        if (node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeParameter) {
            com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeParameter typeParameter = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeParameter)node;
            return this.getTypeBinding(typeParameter.binding);
        }
        if (!(node instanceof MemberValuePair)) return null;
        MemberValuePair memberValuePair = (MemberValuePair)node;
        IMethodBinding method = this.getMethodBinding(memberValuePair.binding);
        if (method != null) return method.getReturnType();
        return null;
    }

    /*
     * Unable to fully structure code
     */
    synchronized IBinding resolveName(Name name) {
        node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(name);
        index = name.index;
        if (!(node instanceof QualifiedNameReference)) ** GOTO lbl43
        qualifiedNameReference = (QualifiedNameReference)node;
        tokens = qualifiedNameReference.tokens;
        indexOfFirstFieldBinding = qualifiedNameReference.indexOfFirstFieldBinding;
        if (index < indexOfFirstFieldBinding) {
            internalScope = (BlockScope)this.astNodesToBlockScope.get(name);
            binding = null;
            try {
                binding = internalScope == null ? this.scope.getTypeOrPackage(CharOperation.subarray(tokens, 0, index)) : internalScope.getTypeOrPackage(CharOperation.subarray(tokens, 0, index));
            }
            catch (RuntimeException v0) {}
            if (binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding) {
                return this.getPackageBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding)binding);
            }
            if (binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding) {
                return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
            }
        } else if (index == indexOfFirstFieldBinding) {
            if (qualifiedNameReference.isTypeReference()) {
                return this.getTypeBinding(qualifiedNameReference.resolvedType);
            }
            binding = qualifiedNameReference.binding;
            if (binding != null) {
                if (binding.isValidBinding()) {
                    return this.getVariableBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.VariableBinding)binding);
                }
                if (binding instanceof ProblemFieldBinding) {
                    problemFieldBinding = (ProblemFieldBinding)binding;
                    switch (problemFieldBinding.problemId()) {
                        case 2: 
                        case 7: {
                            declaringClass = problemFieldBinding.declaringClass;
                            if (declaringClass == null || (exactBinding = declaringClass.getField(tokens[tokens.length - 1], true)) == null || exactBinding.type == null) break;
                            variableBinding = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(exactBinding);
                            if (variableBinding != null) {
                                return variableBinding;
                            }
                            variableBinding = new VariableBinding(this, exactBinding);
                            this.bindingTables.compilerBindingsToASTBindings.put(exactBinding, variableBinding);
                            return variableBinding;
                        }
                    }
                }
            }
        } else {
            if (qualifiedNameReference.otherBindings == null || index - indexOfFirstFieldBinding - 1 < 0) {
                return null;
            }
            return this.getVariableBinding(qualifiedNameReference.otherBindings[index - indexOfFirstFieldBinding - 1]);
lbl43:
            // 1 sources

            if (node instanceof QualifiedTypeReference) {
                qualifiedTypeReference = (QualifiedTypeReference)node;
                if (qualifiedTypeReference.resolvedType == null) {
                    return null;
                }
                if (index == qualifiedTypeReference.tokens.length) {
                    if (!qualifiedTypeReference.resolvedType.isValidBinding() && qualifiedTypeReference instanceof JavadocQualifiedTypeReference) {
                        typeRef = (JavadocQualifiedTypeReference)node;
                        if (typeRef.packageBinding != null) {
                            return this.getPackageBinding(typeRef.packageBinding);
                        }
                    }
                    return this.getTypeBinding(qualifiedTypeReference.resolvedType.leafComponentType());
                }
                if (index >= 0) {
                    internalScope = (BlockScope)this.astNodesToBlockScope.get(name);
                    binding = null;
                    try {
                        binding = internalScope == null ? this.scope.getTypeOrPackage(CharOperation.subarray(qualifiedTypeReference.tokens, 0, index)) : internalScope.getTypeOrPackage(CharOperation.subarray(qualifiedTypeReference.tokens, 0, index));
                    }
                    catch (RuntimeException v1) {}
                    if (binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding) {
                        return this.getPackageBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding)binding);
                    }
                    if (binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding) {
                        return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
                    }
                    return null;
                }
            } else if (node instanceof ImportReference) {
                importReference = (ImportReference)node;
                importReferenceLength = importReference.tokens.length;
                if (index >= 0) {
                    binding = null;
                    if (importReferenceLength == index) {
                        try {
                            binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, index), importReference.onDemand, importReference.isStatic());
                        }
                        catch (RuntimeException v2) {}
                    } else {
                        try {
                            binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, index), true, importReference.isStatic());
                        }
                        catch (RuntimeException v3) {}
                    }
                    if (binding != null) {
                        if (binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding) {
                            return this.getPackageBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding)binding);
                        }
                        if (binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding) {
                            return this.getTypeBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding)binding);
                        }
                        if (binding instanceof FieldBinding) {
                            return this.getVariableBinding((FieldBinding)binding);
                        }
                        if (binding instanceof com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding) {
                            return this.getMethodBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding)binding);
                        }
                        return null;
                    }
                }
            } else if (node instanceof CompilationUnitDeclaration) {
                compilationUnitDeclaration = (CompilationUnitDeclaration)node;
                types = compilationUnitDeclaration.types;
                if (types == null || types.length == 0) {
                    return null;
                }
                type = types[0];
                if (type != null && (typeBinding = this.getTypeBinding(type.binding)) != null) {
                    return typeBinding.getPackage();
                }
            } else if (node instanceof AbstractMethodDeclaration) {
                methodDeclaration = (AbstractMethodDeclaration)node;
                if (methodDeclaration != null && (methodBinding = this.getMethodBinding(methodDeclaration.binding)) != null) {
                    return methodBinding;
                }
            } else if (node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration) {
                typeDeclaration = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration)node;
                typeBinding = this.getTypeBinding(typeDeclaration.binding);
                if (typeBinding != null) {
                    return typeBinding;
                }
            }
        }
        if (node instanceof SingleNameReference) {
            singleNameReference = (SingleNameReference)node;
            if (singleNameReference.isTypeReference()) {
                return this.getTypeBinding(singleNameReference.resolvedType);
            }
            binding = singleNameReference.binding;
            if (binding != null) {
                if (binding.isValidBinding()) {
                    return this.getVariableBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.VariableBinding)binding);
                }
                if (binding instanceof ProblemFieldBinding) {
                    problemFieldBinding = (ProblemFieldBinding)binding;
                    switch (problemFieldBinding.problemId()) {
                        case 2: 
                        case 6: 
                        case 7: {
                            declaringClass = problemFieldBinding.declaringClass;
                            exactBinding = declaringClass.getField(problemFieldBinding.name, true);
                            if (exactBinding == null || exactBinding.type == null) break;
                            variableBinding2 = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(exactBinding);
                            if (variableBinding2 != null) {
                                return variableBinding2;
                            }
                            variableBinding2 = new VariableBinding(this, exactBinding);
                            this.bindingTables.compilerBindingsToASTBindings.put(exactBinding, variableBinding2);
                            return variableBinding2;
                        }
                    }
                }
            }
        } else {
            if (node instanceof QualifiedSuperReference) {
                qualifiedSuperReference = (QualifiedSuperReference)node;
                return this.getTypeBinding(qualifiedSuperReference.qualification.resolvedType);
            }
            if (node instanceof LocalDeclaration) {
                return this.getVariableBinding(((LocalDeclaration)node).binding);
            }
            if (node instanceof JavadocFieldReference) {
                fieldRef = (JavadocFieldReference)node;
                if (fieldRef.methodBinding != null) {
                    return this.getMethodBinding(fieldRef.methodBinding);
                }
                return this.getVariableBinding(fieldRef.binding);
            }
            if (node instanceof FieldReference) {
                return this.getVariableBinding(((FieldReference)node).binding);
            }
            if (node instanceof SingleTypeReference) {
                singleTypeReference = (SingleTypeReference)node;
                binding = singleTypeReference.resolvedType;
                if (binding != null) {
                    if (!binding.isValidBinding() && node instanceof JavadocSingleTypeReference) {
                        typeRef = (JavadocSingleTypeReference)node;
                        if (typeRef.packageBinding != null) {
                            return this.getPackageBinding(typeRef.packageBinding);
                        }
                    }
                    return this.getTypeBinding(binding.leafComponentType());
                }
            } else {
                if (node instanceof FieldDeclaration) {
                    fieldDeclaration = (FieldDeclaration)node;
                    return this.getVariableBinding(fieldDeclaration.binding);
                }
                if (node instanceof MessageSend) {
                    messageSend = (MessageSend)node;
                    return this.getMethodBinding(messageSend.binding);
                }
                if (node instanceof AllocationExpression) {
                    allocation = (AllocationExpression)node;
                    return this.getMethodBinding(allocation.binding);
                }
                if (node instanceof JavadocImplicitTypeReference) {
                    implicitRef = (JavadocImplicitTypeReference)node;
                    return this.getTypeBinding(implicitRef.resolvedType);
                }
                if (node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeParameter) {
                    typeParameter = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeParameter)node;
                    return this.getTypeBinding(typeParameter.binding);
                }
                if (node instanceof MemberValuePair) {
                    memberValuePair = (MemberValuePair)node;
                    return this.getMethodBinding(memberValuePair.binding);
                }
            }
        }
        return null;
    }

    synchronized IPackageBinding resolvePackage(PackageDeclaration pkg) {
        try {
            com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(pkg);
            if (node instanceof ImportReference) {
                ImportReference importReference = (ImportReference)node;
                Binding binding = this.scope.getTypeOrPackage(CharOperation.subarray(importReference.tokens, 0, importReference.tokens.length));
                if (binding != null && binding.isValidBinding()) {
                    IPackageBinding packageBinding = this.getPackageBinding((com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding)binding);
                    if (packageBinding == null) {
                        return null;
                    }
                    this.bindingsToAstNodes.put(packageBinding, pkg);
                    String key = packageBinding.getKey();
                    if (key != null) {
                        this.bindingTables.bindingKeysToBindings.put(key, packageBinding);
                    }
                    return packageBinding;
                }
            }
        }
        catch (RuntimeException runtimeException) {}
        return null;
    }

    synchronized IBinding resolveReference(MemberRef ref) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression expression = (com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression)this.newAstToOldAst.get(ref);
        if (expression instanceof TypeReference) {
            return this.getTypeBinding(expression.resolvedType);
        }
        if (expression instanceof JavadocFieldReference) {
            JavadocFieldReference fieldRef = (JavadocFieldReference)expression;
            if (fieldRef.methodBinding != null) {
                return this.getMethodBinding(fieldRef.methodBinding);
            }
            return this.getVariableBinding(fieldRef.binding);
        }
        return null;
    }

    synchronized IBinding resolveReference(MethodRef ref) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression expression = (com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression)this.newAstToOldAst.get(ref);
        if (expression instanceof JavadocMessageSend) {
            return this.getMethodBinding(((JavadocMessageSend)expression).binding);
        }
        if (expression instanceof JavadocAllocationExpression) {
            return this.getMethodBinding(((JavadocAllocationExpression)expression).binding);
        }
        return null;
    }

    ITypeBinding resolveType(AnnotationTypeDeclaration type) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration;
        Object node = this.newAstToOldAst.get(type);
        if (node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration && (typeDeclaration = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration)node) != null) {
            ITypeBinding typeBinding = this.getTypeBinding(typeDeclaration.binding);
            if (typeBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(typeBinding, type);
            String key = typeBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, typeBinding);
            }
            return typeBinding;
        }
        return null;
    }

    synchronized ITypeBinding resolveType(AnonymousClassDeclaration type) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration anonymousLocalTypeDeclaration;
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(type);
        if (node != null && (node.bits & 0x200) != 0 && (anonymousLocalTypeDeclaration = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration)node) != null) {
            ITypeBinding typeBinding = this.getTypeBinding(anonymousLocalTypeDeclaration.binding);
            if (typeBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(typeBinding, type);
            String key = typeBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, typeBinding);
            }
            return typeBinding;
        }
        return null;
    }

    ITypeBinding resolveType(EnumDeclaration type) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration;
        Object node = this.newAstToOldAst.get(type);
        if (node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration && (typeDeclaration = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration)node) != null) {
            ITypeBinding typeBinding = this.getTypeBinding(typeDeclaration.binding);
            if (typeBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(typeBinding, type);
            String key = typeBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, typeBinding);
            }
            return typeBinding;
        }
        return null;
    }

    synchronized ITypeBinding resolveType(Type type) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode node = (com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(type);
        com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding binding = null;
        if (node != null) {
            TypeReference typeReference;
            if (node instanceof ParameterizedQualifiedTypeReference) {
                int numberOfTypeArgumentsNotNull;
                typeReference = (ParameterizedQualifiedTypeReference)node;
                com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding typeBinding = typeReference.resolvedType;
                int index = type.isQualifiedType() ? ((QualifiedType)type).index : (type.isParameterizedType() ? ((ParameterizedType)type).index : 1);
                if (index != (numberOfTypeArgumentsNotNull = this.getTypeArguments((ParameterizedQualifiedTypeReference)typeReference))) {
                    int i = numberOfTypeArgumentsNotNull;
                    while (i != index) {
                        typeBinding = typeBinding.enclosingType();
                        --i;
                    }
                    binding = typeBinding;
                } else {
                    binding = typeBinding;
                }
            } else if (node instanceof TypeReference) {
                typeReference = (TypeReference)node;
                binding = typeReference.resolvedType;
            } else if (node instanceof SingleNameReference && ((SingleNameReference)node).isTypeReference()) {
                binding = ((SingleNameReference)node).resolvedType;
            } else if (node instanceof QualifiedNameReference && ((QualifiedNameReference)node).isTypeReference()) {
                binding = ((QualifiedNameReference)node).resolvedType;
            } else if (node instanceof ArrayAllocationExpression) {
                binding = ((ArrayAllocationExpression)node).resolvedType;
            }
            if (binding != null) {
                if (type.isArrayType()) {
                    ArrayType arrayType = (ArrayType)type;
                    if (binding.isArrayType()) {
                        ArrayBinding arrayBinding = (ArrayBinding)binding;
                        return this.getTypeBinding(this.scope.createArrayType(arrayBinding.leafComponentType, arrayType.getDimensions()));
                    }
                    return this.getTypeBinding(this.scope.createArrayType(binding, arrayType.getDimensions()));
                }
                if (binding.isArrayType()) {
                    ArrayBinding arrayBinding = (ArrayBinding)binding;
                    return this.getTypeBinding(arrayBinding.leafComponentType);
                }
                return this.getTypeBinding(binding);
            }
        } else if (type.isPrimitiveType() && ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID) {
            return this.getTypeBinding(BaseTypes.VoidBinding);
        }
        return null;
    }

    synchronized ITypeBinding resolveType(TypeDeclaration type) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration;
        Object node = this.newAstToOldAst.get(type);
        if (node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration && (typeDeclaration = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration)node) != null) {
            ITypeBinding typeBinding = this.getTypeBinding(typeDeclaration.binding);
            if (typeBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(typeBinding, type);
            String key = typeBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, typeBinding);
            }
            return typeBinding;
        }
        return null;
    }

    synchronized ITypeBinding resolveTypeParameter(TypeParameter typeParameter) {
        com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeParameter typeParameter2;
        Object node = this.newAstToOldAst.get(typeParameter);
        if (node instanceof com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeParameter && (typeParameter2 = (com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeParameter)node) != null) {
            ITypeBinding typeBinding = this.getTypeBinding(typeParameter2.binding);
            if (typeBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(typeBinding, typeParameter);
            String key = typeBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, typeBinding);
            }
            return typeBinding;
        }
        return null;
    }

    synchronized IVariableBinding resolveVariable(EnumConstantDeclaration enumConstant) {
        Object node = this.newAstToOldAst.get(enumConstant);
        if (node instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
            IVariableBinding variableBinding = this.getVariableBinding(fieldDeclaration.binding);
            if (variableBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(variableBinding, enumConstant);
            String key = variableBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, variableBinding);
            }
            return variableBinding;
        }
        return null;
    }

    synchronized IVariableBinding resolveVariable(VariableDeclaration variable) {
        Object node = this.newAstToOldAst.get(variable);
        if (node instanceof AbstractVariableDeclaration) {
            AbstractVariableDeclaration abstractVariableDeclaration = (AbstractVariableDeclaration)node;
            if (abstractVariableDeclaration instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)abstractVariableDeclaration;
                IVariableBinding variableBinding = this.getVariableBinding(fieldDeclaration.binding);
                if (variableBinding == null) {
                    return null;
                }
                this.bindingsToAstNodes.put(variableBinding, variable);
                String key = variableBinding.getKey();
                if (key != null) {
                    this.bindingTables.bindingKeysToBindings.put(key, variableBinding);
                }
                return variableBinding;
            }
            IVariableBinding variableBinding = this.getVariableBinding(((LocalDeclaration)abstractVariableDeclaration).binding);
            if (variableBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(variableBinding, variable);
            String key = variableBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, variableBinding);
            }
            return variableBinding;
        }
        return null;
    }

    synchronized ITypeBinding resolveWellKnownType(String name) {
        try {
            if ("boolean".equals(name) || "char".equals(name) || "byte".equals(name) || "short".equals(name) || "int".equals(name) || "long".equals(name) || "float".equals(name) || "double".equals(name) || "void".equals(name)) {
                return this.getTypeBinding(Scope.getBaseType(name.toCharArray()));
            }
            if ("java.lang.Object".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangObject());
            }
            if ("java.lang.String".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangString());
            }
            if ("java.lang.StringBuffer".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_STRINGBUFFER, 3));
            }
            if ("java.lang.Throwable".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangThrowable());
            }
            if ("java.lang.Exception".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_EXCEPTION, 3));
            }
            if ("java.lang.RuntimeException".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, 3));
            }
            if ("java.lang.Error".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_ERROR, 3));
            }
            if ("java.lang.Class".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangClass());
            }
            if ("java.lang.Cloneable".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangCloneable());
            }
            if ("java.io.Serializable".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaIoSerializable());
            }
            if ("java.lang.Boolean".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_BOOLEAN, 3));
            }
            if ("java.lang.Byte".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_BYTE, 3));
            }
            if ("java.lang.Character".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_CHARACTER, 3));
            }
            if ("java.lang.Double".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_DOUBLE, 3));
            }
            if ("java.lang.Float".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_FLOAT, 3));
            }
            if ("java.lang.Integer".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_INTEGER, 3));
            }
            if ("java.lang.Long".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_LONG, 3));
            }
            if ("java.lang.Short".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_SHORT, 3));
            }
            if ("java.lang.Void".equals(name)) {
                return this.getTypeBinding(this.scope.getType(TypeConstants.JAVA_LANG_VOID, 3));
            }
        }
        catch (AbortCompilation abortCompilation) {}
        return null;
    }

    public CompilationUnitScope scope() {
        return this.scope;
    }

    synchronized void store(ASTNode node, com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode oldASTNode) {
        this.newAstToOldAst.put(node, oldASTNode);
    }

    synchronized void updateKey(ASTNode node, ASTNode newNode) {
        Object astNode = this.newAstToOldAst.remove(node);
        if (astNode != null) {
            this.newAstToOldAst.put(newNode, astNode);
        }
    }

    static class BindingTables {
        Map bindingKeysToBindings;
        Map compilerBindingsToASTBindings = new HashMap();

        BindingTables() {
            this.bindingKeysToBindings = new HashMap();
        }
    }
}

