/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.codeassist;

import com.netflix.nebula.lint.jdt.core.CompletionProposal;
import com.netflix.nebula.lint.jdt.core.CompletionRequestor;
import com.netflix.nebula.lint.jdt.core.ICompletionRequestor;
import com.netflix.nebula.lint.jdt.core.Signature;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.compiler.IProblem;
import com.netflix.nebula.lint.jdt.internal.codeassist.IExtendedCompletionRequestor;

public class CompletionRequestorWrapper
extends CompletionRequestor {
    private static boolean DECODE_SIGNATURE = false;
    private ICompletionRequestor requestor;

    public CompletionRequestorWrapper(ICompletionRequestor requestor) {
        this.requestor = requestor;
    }

    public void accept(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 3: {
                this.requestor.acceptKeyword(proposal.getName(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 8: {
                if (DECODE_SIGNATURE) {
                    this.requestor.acceptPackage(proposal.getDeclarationSignature(), proposal.getCompletion(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                this.requestor.acceptPackage(proposal.getPackageName(), proposal.getCompletion(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 9: {
                if ((proposal.getFlags() & 0x4000) != 0) break;
                if ((proposal.getFlags() & 0x200) != 0) {
                    if (DECODE_SIGNATURE) {
                        this.requestor.acceptInterface(proposal.getDeclarationSignature(), Signature.getSignatureSimpleName(proposal.getSignature()), proposal.getCompletion(), proposal.getFlags() & 0xFFFFFDFF, proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                        break;
                    }
                    this.requestor.acceptInterface(proposal.getPackageName() == null ? CharOperation.NO_CHAR : proposal.getPackageName(), proposal.getTypeName(), proposal.getCompletion(), proposal.getFlags() & 0xFFFFFDFF, proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                if (DECODE_SIGNATURE) {
                    this.requestor.acceptClass(proposal.getDeclarationSignature(), Signature.getSignatureSimpleName(proposal.getSignature()), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                this.requestor.acceptClass(proposal.getPackageName() == null ? CharOperation.NO_CHAR : proposal.getPackageName(), proposal.getTypeName(), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 2: {
                if (DECODE_SIGNATURE) {
                    this.requestor.acceptField(Signature.getSignatureQualifier(proposal.getDeclarationSignature()), Signature.getSignatureSimpleName(proposal.getDeclarationSignature()), proposal.getName(), Signature.getSignatureQualifier(proposal.getSignature()), Signature.getSignatureSimpleName(proposal.getSignature()), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                this.requestor.acceptField(proposal.getDeclarationPackageName() == null ? CharOperation.NO_CHAR : proposal.getDeclarationPackageName(), proposal.getDeclarationTypeName() == null ? CharOperation.NO_CHAR : proposal.getDeclarationTypeName(), proposal.getName(), proposal.getPackageName() == null ? CharOperation.NO_CHAR : proposal.getPackageName(), proposal.getTypeName() == null ? CharOperation.NO_CHAR : proposal.getTypeName(), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 6: {
                if (DECODE_SIGNATURE) {
                    this.requestor.acceptMethod(Signature.getSignatureQualifier(proposal.getDeclarationSignature()), Signature.getSignatureSimpleName(proposal.getDeclarationSignature()), proposal.getName(), this.getParameterPackages(proposal.getSignature()), this.getParameterTypes(proposal.getSignature()), proposal.findParameterNames(null) == null ? CharOperation.NO_CHAR_CHAR : proposal.findParameterNames(null), Signature.getSignatureQualifier(Signature.getReturnType(proposal.getSignature())), Signature.getSignatureSimpleName(Signature.getReturnType(proposal.getSignature())), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                this.requestor.acceptMethod(proposal.getDeclarationPackageName() == null ? CharOperation.NO_CHAR : proposal.getDeclarationPackageName(), proposal.getDeclarationTypeName() == null ? CharOperation.NO_CHAR : proposal.getDeclarationTypeName(), proposal.getName(), proposal.getParameterPackageNames() == null ? CharOperation.NO_CHAR_CHAR : proposal.getParameterPackageNames(), proposal.getParameterTypeNames() == null ? CharOperation.NO_CHAR_CHAR : proposal.getParameterTypeNames(), proposal.findParameterNames(null) == null ? CharOperation.NO_CHAR_CHAR : proposal.findParameterNames(null), proposal.getPackageName() == null ? CharOperation.NO_CHAR : proposal.getPackageName(), proposal.getTypeName() == null ? CharOperation.NO_CHAR : proposal.getTypeName(), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 7: {
                if (DECODE_SIGNATURE) {
                    this.requestor.acceptMethodDeclaration(Signature.getSignatureQualifier(proposal.getDeclarationSignature()), Signature.getSignatureSimpleName(proposal.getDeclarationSignature()), proposal.getName(), this.getParameterPackages(proposal.getSignature()), this.getParameterTypes(proposal.getSignature()), proposal.findParameterNames(null) == null ? CharOperation.NO_CHAR_CHAR : proposal.findParameterNames(null), Signature.getSignatureQualifier(Signature.getReturnType(proposal.getSignature())), Signature.getSignatureSimpleName(Signature.getReturnType(proposal.getSignature())), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                this.requestor.acceptMethodDeclaration(proposal.getDeclarationPackageName(), proposal.getDeclarationTypeName(), proposal.getName(), proposal.getParameterPackageNames() == null ? CharOperation.NO_CHAR_CHAR : proposal.getParameterPackageNames(), proposal.getParameterTypeNames() == null ? CharOperation.NO_CHAR_CHAR : proposal.getParameterTypeNames(), proposal.findParameterNames(null) == null ? CharOperation.NO_CHAR_CHAR : proposal.findParameterNames(null), proposal.getPackageName(), proposal.getTypeName(), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 1: {
                if (DECODE_SIGNATURE) {
                    this.requestor.acceptAnonymousType(Signature.getSignatureQualifier(proposal.getDeclarationSignature()), Signature.getSignatureSimpleName(proposal.getDeclarationSignature()), this.getParameterPackages(proposal.getSignature()), this.getParameterTypes(proposal.getSignature()), proposal.findParameterNames(null) == null ? CharOperation.NO_CHAR_CHAR : proposal.findParameterNames(null), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                this.requestor.acceptAnonymousType(proposal.getDeclarationPackageName(), proposal.getDeclarationTypeName(), proposal.getParameterPackageNames() == null ? CharOperation.NO_CHAR_CHAR : proposal.getParameterPackageNames(), proposal.getParameterTypeNames() == null ? CharOperation.NO_CHAR_CHAR : proposal.getParameterTypeNames(), proposal.findParameterNames(null) == null ? CharOperation.NO_CHAR_CHAR : proposal.findParameterNames(null), proposal.getCompletion(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 4: {
                this.requestor.acceptLabel(proposal.getCompletion(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 5: {
                if (DECODE_SIGNATURE) {
                    this.requestor.acceptLocalVariable(proposal.getCompletion(), Signature.getSignatureQualifier(proposal.getSignature()), Signature.getSignatureSimpleName(proposal.getSignature()), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                this.requestor.acceptLocalVariable(proposal.getCompletion(), proposal.getPackageName() == null ? CharOperation.NO_CHAR : proposal.getPackageName(), proposal.getTypeName(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 10: {
                if (DECODE_SIGNATURE) {
                    this.requestor.acceptLocalVariable(proposal.getCompletion(), Signature.getSignatureQualifier(proposal.getSignature()), Signature.getSignatureSimpleName(proposal.getSignature()), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                this.requestor.acceptLocalVariable(proposal.getCompletion(), proposal.getPackageName(), proposal.getTypeName(), proposal.getFlags(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                break;
            }
            case 11: {
                if (!(this.requestor instanceof IExtendedCompletionRequestor)) break;
                IExtendedCompletionRequestor r = (IExtendedCompletionRequestor)this.requestor;
                if (DECODE_SIGNATURE) {
                    r.acceptPotentialMethodDeclaration(Signature.getSignatureQualifier(proposal.getDeclarationSignature()), Signature.getSignatureSimpleName(proposal.getDeclarationSignature()), proposal.getName(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
                    break;
                }
                r.acceptPotentialMethodDeclaration(proposal.getDeclarationPackageName(), proposal.getDeclarationTypeName(), proposal.getName(), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance());
            }
        }
    }

    public void completionFailure(IProblem problem) {
        this.requestor.acceptError(problem);
    }

    private char[][] getParameterPackages(char[] methodSignature) {
        char[][] parameterQualifiedTypes = Signature.getParameterTypes(methodSignature);
        int length = parameterQualifiedTypes == null ? 0 : parameterQualifiedTypes.length;
        char[][] parameterPackages = new char[length][];
        int i = 0;
        while (i < length) {
            parameterPackages[i] = Signature.getSignatureQualifier(parameterQualifiedTypes[i]);
            ++i;
        }
        return parameterPackages;
    }

    private char[][] getParameterTypes(char[] methodSignature) {
        char[][] parameterQualifiedTypes = Signature.getParameterTypes(methodSignature);
        int length = parameterQualifiedTypes == null ? 0 : parameterQualifiedTypes.length;
        char[][] parameterPackages = new char[length][];
        int i = 0;
        while (i < length) {
            parameterPackages[i] = Signature.getSignatureSimpleName(parameterQualifiedTypes[i]);
            ++i;
        }
        return parameterPackages;
    }
}

