/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search;

import com.netflix.nebula.lint.jdt.core.IClasspathEntry;
import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.IJavaModel;
import com.netflix.nebula.lint.jdt.core.IJavaProject;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.search.IJavaSearchScope;
import com.netflix.nebula.lint.jdt.core.search.SearchPattern;
import com.netflix.nebula.lint.jdt.internal.core.JarPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.internal.core.JavaModel;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IndexManager;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.MatchLocator;
import com.netflix.nebula.lint.jdt.internal.core.util.SimpleSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IndexSelector {
    IJavaSearchScope searchScope;
    SearchPattern pattern;
    IPath[] indexLocations;

    public IndexSelector(IJavaSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    public static boolean canSeeFocus(IJavaElement focus, boolean isPolymorphicSearch, IPath projectOrJarPath) {
        try {
            IJavaModel model;
            IJavaProject project;
            IClasspathEntry[] focusEntries = null;
            if (isPolymorphicSearch) {
                JavaProject focusProject = focus instanceof JarPackageFragmentRoot ? (JavaProject)focus.getParent() : (JavaProject)focus;
                focusEntries = focusProject.getExpandedClasspath(true);
            }
            if ((project = IndexSelector.getJavaProject(projectOrJarPath, model = focus.getJavaModel())) != null) {
                return IndexSelector.canSeeFocus(focus, (JavaProject)project, focusEntries);
            }
            IJavaProject[] allProjects = model.getJavaProjects();
            int i = 0;
            int length = allProjects.length;
            while (i < length) {
                JavaProject otherProject = (JavaProject)allProjects[i];
                IClasspathEntry[] entries = otherProject.getResolvedClasspath(true, false, false);
                int j = 0;
                int length2 = entries.length;
                while (j < length2) {
                    IClasspathEntry entry = entries[j];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)projectOrJarPath) && IndexSelector.canSeeFocus(focus, otherProject, focusEntries)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static boolean canSeeFocus(IJavaElement focus, JavaProject javaProject, IClasspathEntry[] focusEntriesForPolymorphicSearch) {
        try {
            int i;
            IPath focusPath;
            if (focus.equals(javaProject)) {
                return true;
            }
            if (focusEntriesForPolymorphicSearch != null) {
                IPath projectPath = javaProject.getProject().getFullPath();
                int i2 = 0;
                int length = focusEntriesForPolymorphicSearch.length;
                while (i2 < length) {
                    IClasspathEntry entry = focusEntriesForPolymorphicSearch[i2];
                    if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)projectPath)) {
                        return true;
                    }
                    ++i2;
                }
            }
            if (focus instanceof JarPackageFragmentRoot) {
                focusPath = focus.getPath();
                IClasspathEntry[] entries = javaProject.getExpandedClasspath(true);
                i = 0;
                int length = entries.length;
                while (i < length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)focusPath)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            focusPath = ((JavaProject)focus).getProject().getFullPath();
            IClasspathEntry[] entries = javaProject.getExpandedClasspath(true);
            i = 0;
            int length = entries.length;
            while (i < length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)focusPath)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void initializeIndexLocations() {
        IPath[] projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        IndexManager manager = JavaModelManager.getJavaModelManager().getIndexManager();
        SimpleSet locations = new SimpleSet();
        IJavaElement focus = MatchLocator.projectOrJarFocus(this.pattern);
        if (focus == null) {
            int i = 0;
            while (i < projectsAndJars.length) {
                locations.add(manager.computeIndexLocation(projectsAndJars[i]));
                ++i;
            }
        } else {
            try {
                int length = projectsAndJars.length;
                JavaProject[] projectsCanSeeFocus = new JavaProject[length];
                SimpleSet visitedProjects = new SimpleSet(length);
                int projectIndex = 0;
                SimpleSet jarsToCheck = new SimpleSet(length);
                IClasspathEntry[] focusEntries = null;
                if (this.pattern != null && MatchLocator.isPolymorphicSearch(this.pattern)) {
                    JavaProject focusProject = focus instanceof JarPackageFragmentRoot ? (JavaProject)focus.getParent() : (JavaProject)focus;
                    focusEntries = focusProject.getExpandedClasspath(true);
                }
                JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                int i = 0;
                while (i < length) {
                    IPath path = projectsAndJars[i];
                    JavaProject project = (JavaProject)IndexSelector.getJavaProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        if (IndexSelector.canSeeFocus(focus, project, focusEntries)) {
                            locations.add(manager.computeIndexLocation(path));
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        jarsToCheck.add(path);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectIndex && jarsToCheck.elementSize > 0) {
                    IClasspathEntry[] entries = projectsCanSeeFocus[i].getResolvedClasspath(true, false, false);
                    int j = entries.length;
                    while (--j >= 0) {
                        IPath path;
                        IClasspathEntry entry = entries[j];
                        if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                        locations.add(manager.computeIndexLocation(entry.getPath()));
                        jarsToCheck.remove(path);
                    }
                    ++i;
                }
                if (jarsToCheck.elementSize > 0) {
                    IJavaProject[] allProjects = model.getJavaProjects();
                    int i2 = 0;
                    int l = allProjects.length;
                    while (i2 < l && jarsToCheck.elementSize > 0) {
                        JavaProject project = (JavaProject)allProjects[i2];
                        if (!visitedProjects.includes(project)) {
                            IClasspathEntry[] entries = project.getResolvedClasspath(true, false, false);
                            int j = entries.length;
                            while (--j >= 0) {
                                IPath path;
                                IClasspathEntry entry = entries[j];
                                if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                                locations.add(manager.computeIndexLocation(entry.getPath()));
                                jarsToCheck.remove(path);
                            }
                        }
                        ++i2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.indexLocations = new IPath[locations.elementSize];
        Object[] values = locations.values;
        int count = 0;
        int i = values.length;
        while (--i >= 0) {
            if (values[i] == null) continue;
            this.indexLocations[count++] = new Path((String)values[i]);
        }
    }

    public IPath[] getIndexLocations() {
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        return this.indexLocations;
    }

    private static IJavaProject getJavaProject(IPath path, IJavaModel model) {
        IJavaProject project = model.getJavaProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }
}

