/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.TransportCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.InvalidRemoteException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.TransportException;
import com.netflix.nebula.lint.jgit.errors.NotSupportedException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.transport.FetchConnection;
import com.netflix.nebula.lint.jgit.transport.RefSpec;
import com.netflix.nebula.lint.jgit.transport.Transport;
import com.netflix.nebula.lint.jgit.transport.URIish;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LsRemoteCommand
extends TransportCommand<LsRemoteCommand, Collection<Ref>> {
    private String remote = "origin";
    private boolean heads;
    private boolean tags;
    private String uploadPack;

    public LsRemoteCommand(Repository repo) {
        super(repo);
    }

    public LsRemoteCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public LsRemoteCommand setHeads(boolean heads) {
        this.heads = heads;
        return this;
    }

    public LsRemoteCommand setTags(boolean tags) {
        this.tags = tags;
        return this;
    }

    public LsRemoteCommand setUploadPack(String uploadPack) {
        this.uploadPack = uploadPack;
        return this;
    }

    @Override
    public Collection<Ref> call() throws GitAPIException, InvalidRemoteException, TransportException {
        return this.execute().values();
    }

    public Map<String, Ref> callAsMap() throws GitAPIException, InvalidRemoteException, TransportException {
        return Collections.unmodifiableMap(this.execute());
    }

    private Map<String, Ref> execute() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_6 = null;
            try {
                Transport transport = this.repo != null ? Transport.open(this.repo, this.remote) : Transport.open(new URIish(this.remote));
                try {
                    transport.setOptionUploadPack(this.uploadPack);
                    this.configure(transport);
                    ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>(1);
                    if (this.tags) {
                        refSpecs.add(new RefSpec("refs/tags/*:refs/remotes/origin/tags/*"));
                    }
                    if (this.heads) {
                        refSpecs.add(new RefSpec("refs/heads/*:refs/remotes/origin/*"));
                    }
                    HashMap<String, Ref> refmap = new HashMap<String, Ref>();
                    Throwable throwable2 = null;
                    Object var8_13 = null;
                    try (FetchConnection fc = transport.openFetch();){
                        Collection<Ref> refs = fc.getRefs();
                        if (refSpecs.isEmpty()) {
                            for (Ref r : refs) {
                                refmap.put(r.getName(), r);
                            }
                        } else {
                            block15: for (Ref r : refs) {
                                for (RefSpec rs : refSpecs) {
                                    if (!rs.matchSource(r)) continue;
                                    refmap.put(r.getName(), r);
                                    continue block15;
                                }
                            }
                        }
                        if (transport != null) {
                            transport.close();
                        }
                        return refmap;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (transport != null) {
                        transport.close();
                    }
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote));
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfLsRemoteCommand, e);
        }
        catch (com.netflix.nebula.lint.jgit.errors.TransportException e) {
            throw new TransportException(e.getMessage(), e);
        }
    }
}

