/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.errors;

import com.netflix.nebula.lint.jgit.annotations.Nullable;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectChecker;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import java.io.IOException;
import java.text.MessageFormat;

public class CorruptObjectException
extends IOException {
    private static final long serialVersionUID = 1L;
    private ObjectChecker.ErrorType errorType;

    public CorruptObjectException(ObjectChecker.ErrorType type, AnyObjectId id, String why) {
        super(MessageFormat.format(JGitText.get().objectIsCorrupt3, type.getMessageId(), id.name(), why));
        this.errorType = type;
    }

    public CorruptObjectException(AnyObjectId id, String why) {
        super(MessageFormat.format(JGitText.get().objectIsCorrupt, id.name(), why));
    }

    public CorruptObjectException(ObjectId id, String why) {
        super(MessageFormat.format(JGitText.get().objectIsCorrupt, id.name(), why));
    }

    public CorruptObjectException(String why) {
        super(why);
    }

    public CorruptObjectException(String why, Throwable cause) {
        super(why);
        this.initCause(cause);
    }

    @Nullable
    public ObjectChecker.ErrorType getErrorType() {
        return this.errorType;
    }
}

