/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.pack;

import com.netflix.nebula.lint.jgit.internal.storage.pack.ObjectToPack;
import com.netflix.nebula.lint.jgit.storage.pack.PackConfig;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

class DeltaCache {
    private final long size;
    private final int entryLimit;
    private final ReferenceQueue<byte[]> queue;
    private long used;

    DeltaCache(PackConfig pc) {
        this.size = pc.getDeltaCacheSize();
        this.entryLimit = pc.getDeltaCacheLimit();
        this.queue = new ReferenceQueue();
    }

    boolean canCache(int length, ObjectToPack src, ObjectToPack res) {
        if (0L < this.size && this.size < this.used + (long)length) {
            this.checkForGarbageCollectedObjects();
            if (0L < this.size && this.size < this.used + (long)length) {
                return false;
            }
        }
        if (length < this.entryLimit) {
            this.used += (long)length;
            return true;
        }
        if (length >> 10 < (src.getWeight() >> 20) + (res.getWeight() >> 21)) {
            this.used += (long)length;
            return true;
        }
        return false;
    }

    void credit(int reservedSize) {
        this.used -= (long)reservedSize;
    }

    Ref cache(byte[] data, int actLen, int reservedSize) {
        if (reservedSize != (data = this.resize(data, actLen)).length) {
            this.used -= (long)reservedSize;
            this.used += (long)data.length;
        }
        return new Ref(data, this.queue);
    }

    byte[] resize(byte[] data, int actLen) {
        if (data.length != actLen) {
            byte[] nbuf = new byte[actLen];
            System.arraycopy(data, 0, nbuf, 0, actLen);
            data = nbuf;
        }
        return data;
    }

    private void checkForGarbageCollectedObjects() {
        Ref r;
        while ((r = (Ref)this.queue.poll()) != null) {
            this.used -= (long)r.cost;
        }
    }

    static class Ref
    extends SoftReference<byte[]> {
        final int cost;

        Ref(byte[] array, ReferenceQueue<byte[]> queue) {
            super(array, queue);
            this.cost = array.length;
        }
    }
}

