/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revwalk;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevFlag;
import com.netflix.nebula.lint.jgit.revwalk.RevObjectList;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

public class RevCommitList<E extends RevCommit>
extends RevObjectList<E> {
    private RevWalk walker;

    @Override
    public void clear() {
        super.clear();
        this.walker = null;
    }

    public void applyFlag(RevFilter matching, RevFlag flag) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.applyFlag(matching, flag, 0, this.size());
    }

    public void applyFlag(RevFilter matching, RevFlag flag, int rangeBegin, int rangeEnd) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevWalk w = flag.getRevWalk();
        rangeEnd = Math.min(rangeEnd, this.size());
        while (rangeBegin < rangeEnd) {
            int index = rangeBegin;
            RevObjectList.Block s = this.contents;
            while (s.shift > 0) {
                int i = index >> s.shift;
                index -= i << s.shift;
                s = (RevObjectList.Block)s.contents[i];
            }
            while (rangeBegin++ < rangeEnd && index < 256) {
                RevCommit c;
                if (matching.include(w, c = (RevCommit)s.contents[index++])) {
                    c.add(flag);
                    continue;
                }
                c.remove(flag);
            }
        }
    }

    public void clearFlag(RevFlag flag) {
        this.clearFlag(flag, 0, this.size());
    }

    public void clearFlag(RevFlag flag, int rangeBegin, int rangeEnd) {
        try {
            this.applyFlag(RevFilter.NONE, flag, rangeBegin, rangeEnd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int indexOf(RevFlag flag, int begin) {
        while (begin < this.size()) {
            int index = begin;
            RevObjectList.Block s = this.contents;
            while (s.shift > 0) {
                int i = index >> s.shift;
                index -= i << s.shift;
                s = (RevObjectList.Block)s.contents[i];
            }
            while (begin++ < this.size() && index < 256) {
                RevCommit c;
                if (!(c = (RevCommit)s.contents[index++]).has(flag)) continue;
                return begin;
            }
        }
        return -1;
    }

    public int lastIndexOf(RevFlag flag, int begin) {
        begin = Math.min(begin, this.size() - 1);
        while (begin >= 0) {
            int index = begin;
            RevObjectList.Block s = this.contents;
            while (s.shift > 0) {
                int i = index >> s.shift;
                index -= i << s.shift;
                s = (RevObjectList.Block)s.contents[i];
            }
            while (begin-- >= 0 && index >= 0) {
                RevCommit c;
                if (!(c = (RevCommit)s.contents[index--]).has(flag)) continue;
                return begin;
            }
        }
        return -1;
    }

    public void source(RevWalk w) {
        this.walker = w;
    }

    public boolean isPending() {
        return this.walker != null;
    }

    public void fillTo(int highMark) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.walker == null || this.size > highMark) {
            return;
        }
        RevCommit c = this.walker.next();
        if (c == null) {
            this.walker = null;
            return;
        }
        this.enter(this.size, c);
        this.add(c);
        while (this.size <= highMark) {
            int index = this.size;
            RevObjectList.Block s = this.contents;
            while (index >> s.shift >= 256) {
                s = new RevObjectList.Block(s.shift + 8);
                s.contents[0] = this.contents;
                this.contents = s;
            }
            while (s.shift > 0) {
                int i = index >> s.shift;
                index -= i << s.shift;
                if (s.contents[i] == null) {
                    s.contents[i] = new RevObjectList.Block(s.shift - 8);
                }
                s = (RevObjectList.Block)s.contents[i];
            }
            Object[] dst = s.contents;
            while (this.size <= highMark && index < 256) {
                c = this.walker.next();
                if (c == null) {
                    this.walker = null;
                    return;
                }
                this.enter(this.size++, c);
                dst[index++] = c;
            }
        }
    }

    public void fillTo(RevCommit commitToLoad, int highMark) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.walker == null || commitToLoad == null || highMark > 0 && this.size > highMark) {
            return;
        }
        RevCommit c = this.walker.next();
        if (c == null) {
            this.walker = null;
            return;
        }
        this.enter(this.size, c);
        this.add(c);
        while (!(highMark != 0 && this.size > highMark || c.equals(commitToLoad))) {
            int index = this.size;
            RevObjectList.Block s = this.contents;
            while (index >> s.shift >= 256) {
                s = new RevObjectList.Block(s.shift + 8);
                s.contents[0] = this.contents;
                this.contents = s;
            }
            while (s.shift > 0) {
                int i = index >> s.shift;
                index -= i << s.shift;
                if (s.contents[i] == null) {
                    s.contents[i] = new RevObjectList.Block(s.shift - 8);
                }
                s = (RevObjectList.Block)s.contents[i];
            }
            Object[] dst = s.contents;
            while (!(highMark != 0 && this.size > highMark || index >= 256 || c.equals(commitToLoad))) {
                c = this.walker.next();
                if (c == null) {
                    this.walker = null;
                    return;
                }
                this.enter(this.size++, c);
                dst[index++] = c;
            }
        }
    }

    protected void enter(int index, E e) {
    }
}

