/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.transport.ReceiveCommand;

public class TrackingRefUpdate {
    private final String remoteName;
    final String localName;
    boolean forceUpdate;
    ObjectId oldObjectId;
    ObjectId newObjectId;
    private RefUpdate.Result result;
    private ReceiveCommand cmd;

    TrackingRefUpdate(boolean canForceUpdate, String remoteName, String localName, AnyObjectId oldValue, AnyObjectId newValue) {
        this.remoteName = remoteName;
        this.localName = localName;
        this.forceUpdate = canForceUpdate;
        this.oldObjectId = oldValue.copy();
        this.newObjectId = newValue.copy();
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public ObjectId getNewObjectId() {
        return this.newObjectId;
    }

    public ObjectId getOldObjectId() {
        return this.oldObjectId;
    }

    public RefUpdate.Result getResult() {
        return this.result;
    }

    void setResult(RefUpdate.Result result) {
        this.result = result;
    }

    public ReceiveCommand asReceiveCommand() {
        if (this.cmd == null) {
            this.cmd = new Command();
        }
        return this.cmd;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TrackingRefUpdate[");
        sb.append(this.remoteName);
        sb.append(" -> ");
        sb.append(this.localName);
        if (this.forceUpdate) {
            sb.append(" (forced)");
        }
        sb.append(" ");
        sb.append(this.oldObjectId == null ? "" : this.oldObjectId.abbreviate(7).name());
        sb.append("..");
        sb.append(this.newObjectId == null ? "" : this.newObjectId.abbreviate(7).name());
        sb.append("]");
        return sb.toString();
    }

    final class Command
    extends ReceiveCommand {
        Command() {
            super(TrackingRefUpdate.this.oldObjectId, TrackingRefUpdate.this.newObjectId, TrackingRefUpdate.this.localName);
        }

        boolean canForceUpdate() {
            return TrackingRefUpdate.this.forceUpdate;
        }

        @Override
        public void setResult(RefUpdate.Result status) {
            TrackingRefUpdate.this.result = status;
            super.setResult(status);
        }

        @Override
        public void setResult(ReceiveCommand.Result status) {
            TrackingRefUpdate.this.result = this.decode(status);
            super.setResult(status);
        }

        @Override
        public void setResult(ReceiveCommand.Result status, String msg) {
            TrackingRefUpdate.this.result = this.decode(status);
            super.setResult(status, msg);
        }

        private RefUpdate.Result decode(ReceiveCommand.Result status) {
            switch (status) {
                case OK: {
                    if (AnyObjectId.equals(TrackingRefUpdate.this.oldObjectId, TrackingRefUpdate.this.newObjectId)) {
                        return RefUpdate.Result.NO_CHANGE;
                    }
                    switch (this.getType()) {
                        case CREATE: {
                            return RefUpdate.Result.NEW;
                        }
                        case UPDATE: {
                            return RefUpdate.Result.FAST_FORWARD;
                        }
                    }
                    return RefUpdate.Result.FORCED;
                }
                case REJECTED_NOCREATE: 
                case REJECTED_NODELETE: 
                case REJECTED_NONFASTFORWARD: {
                    return RefUpdate.Result.REJECTED;
                }
                case REJECTED_CURRENT_BRANCH: {
                    return RefUpdate.Result.REJECTED_CURRENT_BRANCH;
                }
                case REJECTED_MISSING_OBJECT: {
                    return RefUpdate.Result.IO_FAILURE;
                }
            }
            return RefUpdate.Result.LOCK_FAILURE;
        }
    }
}

