/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.org.codenarc;

import com.netflix.nebula.lint.org.codenarc.CodeNarcRunner;
import com.netflix.nebula.lint.org.codenarc.analyzer.FilesystemSourceAnalyzer;
import com.netflix.nebula.lint.org.codenarc.analyzer.SourceAnalyzer;
import com.netflix.nebula.lint.org.codenarc.report.HtmlReportWriter;
import com.netflix.nebula.lint.org.codenarc.report.JsonReportWriter;
import com.netflix.nebula.lint.org.codenarc.report.ReportWriterFactory;
import com.netflix.nebula.lint.org.codenarc.results.Results;
import com.netflix.nebula.lint.org.codenarc.util.CodeNarcVersion;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.net.URLDecoder;
import java.util.List;
import java.util.regex.Matcher;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class CodeNarc
implements GroovyObject {
    protected static final String HELP = "CodeNarc - static analysis for Groovy,\nUsage: java org.codenarc.CodeNarc [OPTIONS]\n  where OPTIONS are zero or more command-line options of the form \"-NAME[=VALUE]\":\n    -basedir=<DIR>\n        The base (root) directory for the source code to be analyzed.\n        Defaults to the current directory (\".\").\n    -includes=<PATTERNS>\n        The comma-separated list of Ant-style file patterns specifying files that must\n        be included. Defaults to \"**/*.groovy\".\n    -excludes=<PATTERNS>\n        The comma-separated list of Ant-style file patterns specifying files that must\n        be excluded. No files are excluded when omitted.\n    -rulesetfiles=<FILENAMES>\n        The path to the Groovy or XML RuleSet definition files, relative to the classpath.\n        This can be a single file path, or multiple paths separated by commas. Each path may be optionally prefixed by\n        any of the valid java.net.URL prefixes, such as \"file:\" (to load from a relative or absolute filesystem path),\n        or \"http:\". If it is a URL, its path may be optionally URL-encoded. That can be useful if the path contains\n        any problematic characters, such as comma (',') or hash ('#'). For instance:\n            file:src/test/resources/RuleSet-,#.txt\n        can be encoded as:\n            file:src%2Ftest%2Fresources%2FRuleSet-%2C%23.txt\n        See URLEncoder#encode(java.lang.String, java.lang.String). Defaults to \"rulesets/basic.xml\"\n    -ruleset=JSON_STRING\n        String containing a ruleSet in JSON format (if set, rulesetfiles argument will be ignored)\n        The JSON string must be URL-encoded in UTF-8 before being sent as argument to CodeNarc\n    -maxPriority1Violations=<MAX>\n        The maximum number of priority 1 violations allowed (int).\n    -maxPriority2Violations=<MAX>\n        The maximum number of priority 2 violations allowed (int).\n    -maxPriority3Violations=<MAX>\n        The maximum number of priority 3 violations allowed (int).\n    -title=<REPORT TITLE>\n        The title for this analysis; used in the output report(s), if supported by the report type. Optional.\n    -report=<REPORT-TYPE[:FILENAME|:stdout]>\n        The definition of the report to produce. The option value is of the form\n        TYPE[:FILENAME], where TYPE is \"html\", \"text\", \"xml\", or \"console\" and FILENAME is the filename (with\n        optional path) of the output report filename. If the TYPE is followed by :stdout (e.g. \"html:stdout\", \"json:stdout\"),\n        then the report is written to standard out. If the report filename is  omitted, the default filename\n        is used for the specified report type (\"CodeNarcReport.html\" for \"html\", \"CodeNarcXmlReport.xml\" for\n        \"xml\" and \"CodeNarcJsonReport.json\" for \"json\"). If no report option is specified, default to a\n        single \"html\" report with the default filename.\n    -plugins=<PLUGIN CLASS NAMES>\n        The optional list of CodeNarcPlugin class names to register, separated by commas.\n    -help\n        Display the command-line help. If present, this must be the only command-line parameter.\n  Example command-line invocations:\n    java org.codenarc.CodeNarc\n    java org.codenarc.CodeNarc -rulesetfiles=\"rulesets/basic.xml\" title=\"My Project\"\n    java org.codenarc.CodeNarc -report=xml:MyXmlReport.xml -report=html\n    java org.codenarc.CodeNarc -report=json:stdout\n    java org.codenarc.CodeNarc -help'";
    protected static Closure systemExit;
    protected String ruleSetFiles;
    protected String ruleset;
    protected String baseDir;
    protected String includes;
    protected String excludes;
    protected String title;
    protected String plugins;
    protected List reports;
    protected Closure createCodeNarcRunner;
    protected int maxPriority1Violations;
    protected int maxPriority2Violations;
    protected int maxPriority3Violations;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public CodeNarc() {
        MetaClass metaClass;
        List list;
        CallSite[] callSiteArray = CodeNarc.$getCallSiteArray();
        this.reports = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        _closure1 _closure110 = new _closure1(this, this);
        this.createCodeNarcRunner = _closure110;
        Object object = callSiteArray[0].callGetProperty(Integer.class);
        this.maxPriority1Violations = DefaultTypeTransformation.intUnbox((Object)object);
        Object object2 = callSiteArray[1].callGetProperty(Integer.class);
        this.maxPriority2Violations = DefaultTypeTransformation.intUnbox((Object)object2);
        Object object3 = callSiteArray[2].callGetProperty(Integer.class);
        this.maxPriority3Violations = DefaultTypeTransformation.intUnbox((Object)object3);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = CodeNarc.$getCallSiteArray();
        Object codeNarc = callSiteArray[3].callConstructor(CodeNarc.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)args, (Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"-help"}), String[].class)))) {
            callSiteArray[4].callStatic(CodeNarc.class, (Object)HELP);
            return;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)args, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"-version"}))) {
            Object version = callSiteArray[5].call(CodeNarcVersion.class);
            callSiteArray[6].callStatic(CodeNarc.class, (Object)new GStringImpl(new Object[]{version}, new String[]{"CodeNarc version ", ""}));
            return;
        }
        try {
            callSiteArray[7].call(codeNarc, (Object)args);
        }
        catch (Throwable t) {
            callSiteArray[8].callStatic(CodeNarc.class, (Object)new GStringImpl(new Object[]{t}, new String[]{"ERROR: ", ""}));
            callSiteArray[9].call((Object)t);
            callSiteArray[10].callStatic(CodeNarc.class, (Object)HELP);
            ScriptBytecodeAdapter.invokeClosure((Object)systemExit, (Object[])new Object[]{1});
        }
    }

    protected void execute(String ... args) {
        CallSite[] callSiteArray = CodeNarc.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[11].callCurrent((GroovyObject)this, (Object)args);
        } else {
            this.parseArgs(args);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[12].callCurrent((GroovyObject)this);
        } else {
            this.setDefaultsIfNecessary();
        }
        Object sourceAnalyzer = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            sourceAnalyzer = object = callSiteArray[13].callCurrent((GroovyObject)this);
        } else {
            SourceAnalyzer sourceAnalyzer2 = this.createSourceAnalyzer();
            sourceAnalyzer = sourceAnalyzer2;
        }
        public final class _execute_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _execute_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _execute_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object reportWriter) {
                CallSite[] callSiteArray = _execute_closure2.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(reportWriter, (Object)"title"))) {
                    Object object = callSiteArray[1].callGroovyObjectGetProperty((Object)this);
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)reportWriter, (String)"title");
                    return object;
                }
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execute_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "hasProperty";
                stringArray[1] = "title";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _execute_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_execute_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _execute_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[14].call((Object)this.reports, (Object)new _execute_closure2(this, this));
        Object codeNarcRunner = ScriptBytecodeAdapter.invokeClosure((Object)this.createCodeNarcRunner, (Object[])new Object[0]);
        String string = this.ruleSetFiles;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)codeNarcRunner, (String)"ruleSetFiles");
        String string2 = this.ruleset;
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)codeNarcRunner, (String)"ruleSetString");
        List list = this.reports;
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)codeNarcRunner, (String)"reportWriters");
        Object object = sourceAnalyzer;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)codeNarcRunner, (String)"sourceAnalyzer");
        if (DefaultTypeTransformation.booleanUnbox((Object)this.plugins)) {
            callSiteArray[15].call(codeNarcRunner, (Object)this.plugins);
        }
        Results results = (Results)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].call(codeNarcRunner), Results.class);
        callSiteArray[17].callCurrent((GroovyObject)this, (Object)results, (Object)1, (Object)this.maxPriority1Violations);
        callSiteArray[18].callCurrent((GroovyObject)this, (Object)results, (Object)2, (Object)this.maxPriority2Violations);
        callSiteArray[19].callCurrent((GroovyObject)this, (Object)results, (Object)3, (Object)this.maxPriority3Violations);
    }

    protected void setDefaultsIfNecessary() {
        String string;
        String string2;
        String string3;
        CallSite[] callSiteArray = CodeNarc.$getCallSiteArray();
        String string4 = this.baseDir;
        this.baseDir = string3 = DefaultTypeTransformation.booleanUnbox((Object)string4) ? string4 : ".";
        String string5 = this.includes;
        this.includes = string2 = DefaultTypeTransformation.booleanUnbox((Object)string5) ? string5 : "**/*.groovy";
        String string6 = this.ruleSetFiles;
        this.ruleSetFiles = string = DefaultTypeTransformation.booleanUnbox((Object)string6) ? string6 : "rulesets/basic.xml";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].callGetProperty((Object)this.reports))) {
            callSiteArray[21].call((Object)this.reports, callSiteArray[22].callConstructor(HtmlReportWriter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"title", this.title})));
        }
    }

    protected void checkMaxViolations(Results results, int priority, int max) {
        CallSite[] callSiteArray = CodeNarc.$getCallSiteArray();
        Object numViolations = callSiteArray[23].call((Object)results, (Object)priority, (Object)true);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)numViolations, (Object)max)) {
            callSiteArray[24].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{priority, max}, new String[]{"ERROR: Number of p", " violations greater than maximum of ", ""}));
            ScriptBytecodeAdapter.invokeClosure((Object)systemExit, (Object[])new Object[]{1});
        }
    }

    protected SourceAnalyzer createSourceAnalyzer() {
        CallSite[] callSiteArray = CodeNarc.$getCallSiteArray();
        return (SourceAnalyzer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callConstructor(FilesystemSourceAnalyzer.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"baseDirectory", this.baseDir, "includes", this.includes, "excludes", this.excludes})), SourceAnalyzer.class);
    }

    protected void parseArgs(String ... args) {
        CallSite[] callSiteArray = CodeNarc.$getCallSiteArray();
        public final class _parseArgs_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _parseArgs_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _parseArgs_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object arg) {
                CallSite[] callSiteArray = _parseArgs_closure3.$getCallSiteArray();
                String PATTERN = "\\-(.*)\\=(.*)";
                Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)arg, (Object)PATTERN);
                if (!DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                    StringBuffer stringBuffer = new StringBuffer("matcher. Values: ");
                    stringBuffer.append((Object)"matcher = ");
                    stringBuffer.append(InvokerHelper.toString((Object)matcher));
                    ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)new GStringImpl(new Object[]{arg}, new String[]{"Invalid argument format: [", "]"}));
                }
                Object name = callSiteArray[0].call(callSiteArray[1].call((Object)matcher, (Object)0), (Object)1);
                Object value = callSiteArray[2].call(callSiteArray[3].call((Object)matcher, (Object)0), (Object)2);
                Object object = name;
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"rulesetfiles")) {
                    Object object2 = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)object2), _parseArgs_closure3.class, (GroovyObject)this, (String)"ruleSetFiles");
                    return object2;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"ruleset")) {
                    Object object3 = callSiteArray[4].call(URLDecoder.class, value, (Object)"UTF-8");
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)object3), _parseArgs_closure3.class, (GroovyObject)this, (String)"ruleset");
                    return object3;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"basedir")) {
                    Object object4 = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)object4), _parseArgs_closure3.class, (GroovyObject)this, (String)"baseDir");
                    return object4;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"includes")) {
                    Object object5 = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)object5), _parseArgs_closure3.class, (GroovyObject)this, (String)"includes");
                    return object5;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"excludes")) {
                    Object object6 = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)object6), _parseArgs_closure3.class, (GroovyObject)this, (String)"excludes");
                    return object6;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"title")) {
                    Object object7 = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)object7), _parseArgs_closure3.class, (GroovyObject)this, (String)"title");
                    return object7;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"report")) {
                    return callSiteArray[5].callCurrent((GroovyObject)this, value);
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"maxPriority1Violations")) {
                    int n = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)value, Integer.TYPE));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, _parseArgs_closure3.class, (GroovyObject)this, (String)"maxPriority1Violations");
                    return n;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"maxPriority2Violations")) {
                    int n = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)value, Integer.TYPE));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, _parseArgs_closure3.class, (GroovyObject)this, (String)"maxPriority2Violations");
                    return n;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"maxPriority3Violations")) {
                    int n = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)value, Integer.TYPE));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, _parseArgs_closure3.class, (GroovyObject)this, (String)"maxPriority3Violations");
                    return n;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"plugins")) {
                    Object object8 = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)object8), _parseArgs_closure3.class, (GroovyObject)this, (String)"plugins");
                    return object8;
                }
                throw (Throwable)callSiteArray[6].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{arg}, new String[]{"Invalid option: [", "]"}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseArgs_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "getAt";
                stringArray[2] = "getAt";
                stringArray[3] = "getAt";
                stringArray[4] = "decode";
                stringArray[5] = "parseReport";
                stringArray[6] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _parseArgs_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_parseArgs_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parseArgs_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[26].call((Object)args, (Object)new _parseArgs_closure3(this, this));
    }

    private void parseReport(String argValue) {
        CallSite[] callSiteArray = CodeNarc.$getCallSiteArray();
        Object parts = callSiteArray[27].call((Object)argValue, (Object)":", (Object)2);
        Object type = callSiteArray[28].call(parts, (Object)0);
        Object reportWriter = callSiteArray[29].call(callSiteArray[30].callConstructor(ReportWriterFactory.class), type);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[31].call(parts), (Object)1) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].call(parts, (Object)1))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[33].call(parts, (Object)1), (Object)"stdout")) {
                boolean bl = true;
                ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)reportWriter, (String)"writeToStandardOut");
                if (reportWriter instanceof JsonReportWriter) {
                    boolean bl2 = true;
                    ScriptBytecodeAdapter.setProperty((Object)bl2, null, (Object)reportWriter, (String)"writeAsSingleLine");
                }
            } else {
                Object object = callSiteArray[34].call(parts, (Object)1);
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)reportWriter, (String)"outputFile");
            }
        }
        callSiteArray[35].call((Object)this.reports, reportWriter);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CodeNarc.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        public final class __clinit__closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = __clinit__closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object exitCode) {
                CallSite[] callSiteArray = __clinit__closure4.$getCallSiteArray();
                return callSiteArray[0].call(System.class, exitCode);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "exit";
                return new CallSiteArray(__clinit__closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        __clinit__closure4 __clinit__closure42 = new __clinit__closure4(CodeNarc.class, CodeNarc.class);
        systemExit = __clinit__closure42;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "MAX_VALUE";
        stringArray[1] = "MAX_VALUE";
        stringArray[2] = "MAX_VALUE";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "println";
        stringArray[5] = "getVersion";
        stringArray[6] = "println";
        stringArray[7] = "execute";
        stringArray[8] = "println";
        stringArray[9] = "printStackTrace";
        stringArray[10] = "println";
        stringArray[11] = "parseArgs";
        stringArray[12] = "setDefaultsIfNecessary";
        stringArray[13] = "createSourceAnalyzer";
        stringArray[14] = "each";
        stringArray[15] = "registerPluginsForClassNames";
        stringArray[16] = "execute";
        stringArray[17] = "checkMaxViolations";
        stringArray[18] = "checkMaxViolations";
        stringArray[19] = "checkMaxViolations";
        stringArray[20] = "empty";
        stringArray[21] = "leftShift";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "getNumberOfViolationsWithPriority";
        stringArray[24] = "println";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "each";
        stringArray[27] = "split";
        stringArray[28] = "getAt";
        stringArray[29] = "getReportWriter";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "size";
        stringArray[32] = "getAt";
        stringArray[33] = "getAt";
        stringArray[34] = "getAt";
        stringArray[35] = "leftShift";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[36];
        CodeNarc.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CodeNarc.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CodeNarc.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure1(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return callSiteArray[0].callConstructor(CodeNarcRunner.class);
        }

        @Generated
        public Object doCall() {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "<$constructor$>";
            return new CallSiteArray(_closure1.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure1.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

