/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.credential.CredentialPlugin;
import com.oceanbase.jdbc.credential.CredentialPluginLoader;
import com.oceanbase.jdbc.internal.failover.utils.ConfigParser;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.util.constant.HaMode;
import com.oceanbase.jdbc.util.DefaultOptions;
import com.oceanbase.jdbc.util.Options;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlParser
implements Cloneable {
    private static final String DISABLE_MYSQL_URL = "disableMariaDbDriver";
    private static final Pattern URL_PARAMETER = Pattern.compile("(\\/([^\\?]*))?(\\?(.+))*", 32);
    private static final Pattern AWS_PATTERN = Pattern.compile("(.+)\\.([a-z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private String database;
    private Options options = null;
    private List<HostAddress> addresses;
    private HaMode haMode;
    private String initialUrl;
    private boolean multiMaster;
    private CredentialPlugin credentialPlugin;
    private String tnsServiceName;
    public static final String DBNAME_PROPERTY_KEY = "DBNAME";
    private String extendDescription;
    private ConfigParser.OcpApi ocpApi;
    private String connectedUsername;

    public static String getPropertyDbName(Properties props) {
        return props.getProperty(DBNAME_PROPERTY_KEY);
    }

    private UrlParser() {
    }

    public UrlParser(String database, List<HostAddress> addresses, Options options, HaMode haMode) throws SQLException {
        this.options = options;
        this.database = database;
        this.addresses = addresses;
        this.haMode = haMode;
        if (haMode == HaMode.AURORA) {
            for (HostAddress hostAddress : addresses) {
                hostAddress.type = null;
            }
        } else {
            for (HostAddress hostAddress : addresses) {
                if (hostAddress.type != null) continue;
                hostAddress.type = "master";
            }
        }
        this.credentialPlugin = CredentialPluginLoader.get(options.credentialType);
        DefaultOptions.postOptionProcess(options, this.credentialPlugin);
        this.setInitialUrl();
        this.loadMultiMasterValue();
    }

    public static boolean acceptsUrl(String url) {
        return url != null && url.startsWith("jdbc:oceanbase:") && !url.contains(DISABLE_MYSQL_URL);
    }

    public static UrlParser parse(String url) throws SQLException {
        return UrlParser.parse(url, new Properties());
    }

    public static UrlParser parse(String url, Properties prop) throws SQLException {
        if (url != null && url.startsWith("jdbc:oceanbase:") && !url.contains(DISABLE_MYSQL_URL)) {
            UrlParser urlParser = new UrlParser();
            UrlParser.parseInternal(urlParser, url, prop == null ? new Properties() : prop);
            return urlParser;
        }
        return null;
    }

    private static void parseInternal(UrlParser urlParser, String url, Properties properties) throws SQLException {
        try {
            String additionalParameters;
            String hostAddressesString;
            int paramIndex;
            urlParser.initialUrl = url;
            int separator = url.indexOf("//");
            if (separator == -1) {
                throw new IllegalArgumentException("url parsing error : '//' is not present in the url " + url);
            }
            urlParser.haMode = UrlParser.parseHaMode(url, separator);
            String urlSecondPart = url.substring(separator + 2);
            int dbIndex = urlSecondPart.indexOf("/");
            if (dbIndex < (paramIndex = urlSecondPart.indexOf("?")) && dbIndex < 0 || dbIndex > paramIndex && paramIndex > -1) {
                hostAddressesString = urlSecondPart.substring(0, paramIndex);
                additionalParameters = urlSecondPart.substring(paramIndex);
            } else if (dbIndex < paramIndex && dbIndex > -1 || dbIndex > paramIndex && paramIndex < 0) {
                hostAddressesString = urlSecondPart.substring(0, dbIndex);
                additionalParameters = urlSecondPart.substring(dbIndex);
            } else {
                hostAddressesString = urlSecondPart;
                additionalParameters = null;
            }
            UrlParser.defineUrlParserParameters(urlParser, properties, hostAddressesString, additionalParameters);
            UrlParser.setDefaultHostAddressType(urlParser);
            urlParser.loadMultiMasterValue();
        }
        catch (IllegalArgumentException i) {
            throw new SQLException("error parsing url : " + i.getMessage(), i);
        }
    }

    private static void defineUrlParserParameters(UrlParser urlParser, Properties properties, String hostAddressesString, String additionalParameters) throws SQLException {
        if (additionalParameters != null) {
            Matcher matcher = URL_PARAMETER.matcher(additionalParameters);
            matcher.find();
            urlParser.database = matcher.group(2);
            urlParser.options = DefaultOptions.parse(urlParser.haMode, matcher.group(4), properties, urlParser.options);
            if (urlParser.database != null && urlParser.database.isEmpty()) {
                urlParser.database = null;
            }
        } else {
            urlParser.database = null;
            urlParser.options = DefaultOptions.parse(urlParser.haMode, "", properties, urlParser.options);
        }
        urlParser.database = UrlParser.getPropertyDbName(properties) == null ? urlParser.database : UrlParser.getPropertyDbName(properties);
        urlParser.credentialPlugin = CredentialPluginLoader.get(urlParser.options.credentialType);
        DefaultOptions.postOptionProcess(urlParser.options, urlParser.credentialPlugin);
        LoggerFactory.init(urlParser.options.log || urlParser.options.profileSql || urlParser.options.slowQueryThresholdNanos != null);
        if (hostAddressesString.indexOf(64) == 0 && urlParser.haMode == HaMode.LOADBALANCE) {
            String extendDescription = hostAddressesString.substring(1);
            if (extendDescription.indexOf(40) == 0) {
                urlParser.extendDescription = extendDescription;
            } else if (extendDescription.startsWith("ocpApi=")) {
                urlParser.setOcpApi(extendDescription.substring(extendDescription.indexOf(61) + 1));
            } else {
                urlParser.addresses = new ArrayList<HostAddress>();
                urlParser.tnsServiceName = hostAddressesString.substring(1);
            }
        } else {
            urlParser.addresses = HostAddress.parse(hostAddressesString, urlParser.haMode);
            if (properties.get("port") != null) {
                urlParser.addresses.forEach(address -> {
                    address.port = Integer.parseInt((String)properties.get("port"));
                });
            }
        }
    }

    private static HaMode parseHaMode(String url, int separator) {
        int firstColonPos = url.indexOf(58);
        int secondColonPos = url.indexOf(58, firstColonPos + 1);
        int thirdColonPos = url.indexOf(58, secondColonPos + 1);
        int forthColonPos = url.indexOf(58, thirdColonPos + 1);
        if (thirdColonPos > separator || thirdColonPos == -1) {
            if (secondColonPos == separator - 1) {
                return HaMode.NONE;
            }
            thirdColonPos = separator;
        }
        if (forthColonPos > separator || forthColonPos == -1) {
            forthColonPos = separator;
        }
        try {
            String haModeString = url.substring(secondColonPos + 1, thirdColonPos).toUpperCase(Locale.ROOT);
            if ("ORACLE".equals(haModeString)) {
                haModeString = url.substring(thirdColonPos + 1, forthColonPos).toUpperCase(Locale.ROOT);
            }
            if ("".equals(haModeString)) {
                return HaMode.NONE;
            }
            if ("FAILOVER".equals(haModeString)) {
                haModeString = "LOADBALANCE";
            }
            return HaMode.valueOf(haModeString);
        }
        catch (IllegalArgumentException i) {
            throw new IllegalArgumentException("wrong failover parameter format in connection String " + url);
        }
    }

    private static void setDefaultHostAddressType(UrlParser urlParser) {
        block3: {
            block2: {
                if (urlParser.haMode != HaMode.AURORA) break block2;
                for (HostAddress hostAddress : urlParser.addresses) {
                    hostAddress.type = null;
                }
                break block3;
            }
            if (urlParser.addresses == null || urlParser.extendDescription == null) break block3;
            for (HostAddress hostAddress : urlParser.addresses) {
                if (hostAddress.type != null) continue;
                hostAddress.type = "master";
            }
        }
    }

    private void setInitialUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:oceanbase:");
        if (this.haMode != HaMode.NONE) {
            sb.append(this.haMode.toString().toLowerCase(Locale.ROOT)).append(":");
        }
        sb.append("//");
        for (int i = 0; i < this.addresses.size(); ++i) {
            HostAddress hostAddress = this.addresses.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append("address=(host=").append(hostAddress.host).append(")").append("(port=").append(hostAddress.port).append(")");
            if (hostAddress.type == null) continue;
            sb.append("(type=").append(hostAddress.type).append(")");
        }
        sb.append("/");
        if (this.database != null) {
            sb.append(this.database);
        }
        DefaultOptions.propertyString(this.options, this.haMode, sb);
        this.initialUrl = sb.toString();
    }

    public UrlParser auroraPipelineQuirks() {
        boolean disablePipeline = this.isAurora();
        if (this.options.useBatchMultiSend == null) {
            this.options.useBatchMultiSend = false;
        }
        if (this.options.usePipelineAuth == null) {
            this.options.usePipelineAuth = false;
        }
        return this;
    }

    public boolean isAurora() {
        if (this.haMode == HaMode.AURORA) {
            return true;
        }
        if (this.addresses != null) {
            for (HostAddress hostAddress : this.addresses) {
                Matcher matcher = AWS_PATTERN.matcher(hostAddress.host);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    public void parseUrl(String url) throws SQLException {
        if (UrlParser.acceptsUrl(url)) {
            UrlParser.parseInternal(this, url, new Properties());
        }
    }

    public String getUsername() {
        return this.options.user;
    }

    public void setUsername(String username) {
        this.options.user = username;
    }

    public String getPassword() {
        return this.options.password;
    }

    public void setPassword(String password) {
        this.options.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public List<HostAddress> getHostAddresses() {
        return this.addresses;
    }

    public Options getOptions() {
        return this.options;
    }

    protected void setProperties(String urlParameters) {
        DefaultOptions.parse(this.haMode, urlParameters, this.options);
        this.setInitialUrl();
    }

    public CredentialPlugin getCredentialPlugin() {
        return this.credentialPlugin;
    }

    public String toString() {
        return this.initialUrl;
    }

    public String getInitialUrl() {
        return this.initialUrl;
    }

    public HaMode getHaMode() {
        return this.haMode;
    }

    public String getTnsServiceName() {
        return this.tnsServiceName;
    }

    public boolean equals(Object parser) {
        if (this == parser) {
            return true;
        }
        if (!(parser instanceof UrlParser)) {
            return false;
        }
        UrlParser urlParser = (UrlParser)parser;
        return (this.initialUrl != null ? this.initialUrl.equals(urlParser.getInitialUrl()) : urlParser.getInitialUrl() == null) && (this.getUsername() != null ? this.getUsername().equals(urlParser.getUsername()) : urlParser.getUsername() == null) && (this.getPassword() != null ? this.getPassword().equals(urlParser.getPassword()) : urlParser.getPassword() == null);
    }

    public int hashCode() {
        int result = this.options.password != null ? this.options.password.hashCode() : 0;
        result = 31 * result + (this.options.user != null ? this.options.user.hashCode() : 0);
        result = 31 * result + this.initialUrl.hashCode();
        return result;
    }

    private void loadMultiMasterValue() {
        if (this.haMode == HaMode.SEQUENTIAL || this.haMode == HaMode.REPLICATION || this.haMode == HaMode.LOADBALANCE) {
            boolean firstMaster = false;
            if (this.addresses != null && this.extendDescription != null) {
                for (HostAddress host : this.addresses) {
                    if (!host.type.equals("master")) continue;
                    if (firstMaster) {
                        this.multiMaster = true;
                        return;
                    }
                    firstMaster = true;
                }
            }
        }
        this.multiMaster = false;
    }

    public boolean isMultiMaster() {
        return this.multiMaster;
    }

    public Object clone() throws CloneNotSupportedException {
        UrlParser tmpUrlParser = (UrlParser)super.clone();
        tmpUrlParser.options = (Options)this.options.clone();
        tmpUrlParser.addresses = new ArrayList<HostAddress>();
        tmpUrlParser.addresses.addAll(this.addresses);
        return tmpUrlParser;
    }

    public String getExtendDescription() {
        return this.extendDescription;
    }

    public ConfigParser.OcpApi getOcpApi() {
        return this.ocpApi;
    }

    public void setOcpApi(String urlPart) {
        this.ocpApi = new ConfigParser.OcpApi();
        String[] info = urlPart.split(":");
        this.ocpApi.ip = info[0];
        this.ocpApi.port = info[1];
        this.ocpApi.appName = info[2];
    }

    public String getConnectedUsername() {
        return this.connectedUsername;
    }

    public void setConnectedUsername(String connectedUsername) {
        this.connectedUsername = connectedUsername;
    }
}

