/*
 * Decompiled with CFR 0.152.
 */
package com.pyx4j.maven.plugin.junction;

import com.pyx4j.maven.plugin.junction.BaseJunctionMojo;
import com.pyx4j.maven.plugin.junction.ExecuteJunction;
import com.pyx4j.maven.plugin.junction.Link;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JunctionMojo
extends BaseJunctionMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        ExecuteJunction exe = new ExecuteJunction(this.pluginArtifacts);
        this.getLog().debug((CharSequence)("junction exe " + exe));
        Vector runLinks = new Vector();
        if (this.links != null) {
            runLinks.addAll(this.links);
        }
        if (this.composeClasses != null) {
            if (!this.composeClasses.dst.exists()) {
                if (this.composeClasses.dstCreate) {
                    try {
                        FileUtils.forceMkdir((File)this.composeClasses.dst);
                    }
                    catch (IOException e) {
                        throw new MojoFailureException("Can't create src  [" + this.composeClasses.dst + "]");
                    }
                } else {
                    throw new MojoFailureException("junction composeClasses dst [" + this.composeClasses.dst + "] does not exists");
                }
            }
            runLinks.addAll(this.composeClasses.getlinks());
        }
        Iterator i = runLinks.iterator();
        while (i.hasNext()) {
            Link link = (Link)i.next();
            this.getLog().debug((CharSequence)("link " + link.getSrc() + " -> " + link.getDst()));
            this.executeLink(link, exe);
        }
    }

    private void executeLink(Link link, ExecuteJunction exe) throws MojoFailureException {
        if (!link.getSrc().exists()) {
            if (link.isSrcCreate()) {
                try {
                    FileUtils.forceMkdir((File)link.getSrc());
                }
                catch (IOException e) {
                    throw new MojoFailureException("Can't create src  [" + link.getSrc().getParentFile() + "]");
                }
            } else {
                if (link.isFailNoSrc()) {
                    throw new MojoFailureException("junction source [" + link.getSrc() + "] does not exists");
                }
                return;
            }
        }
        if (link.getDst().exists()) {
            this.getLog().debug((CharSequence)("removing link target first " + link.getDst()));
            exe.unlink(link.getDst().getAbsolutePath());
            if (link.getDst().exists() && !link.getDst().delete()) {
                throw new MojoFailureException("Can't remove junction target [" + link.getDst() + "]");
            }
        }
        if (!link.getDst().getParentFile().exists()) {
            try {
                FileUtils.forceMkdir((File)link.getDst().getParentFile());
            }
            catch (IOException e) {
                throw new MojoFailureException("Can't create target parent [" + link.getDst().getParentFile() + "]");
            }
        } else if (link.getDst().getParentFile().isFile()) {
            throw new MojoFailureException("File " + link.getDst().getParentFile() + " exists and is " + "not a directory. Unable to create directory.");
        }
        exe.link(link.getDst().getAbsolutePath(), link.getSrc().getAbsolutePath());
        if (!link.getDst().exists()) {
            throw new MojoFailureException("Can't create junction source [" + link.getSrc() + "] -> [" + link.getDst() + "]");
        }
    }
}

