/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.clowder.configsource;

import io.smallrye.config.ConfigValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class ClowderConfigSource
implements ConfigSource {
    public static final String CLOWDER_CONFIG_SOURCE = "ClowderConfigSource";
    Logger log = Logger.getLogger((String)this.getClass().getName());
    private final Map<String, ConfigValue> existingValues;
    JsonObject root;
    private boolean translate = true;

    public ClowderConfigSource(String configFile, Map<String, ConfigValue> exProp) {
        this.existingValues = exProp;
        File file = new File(configFile);
        if (!file.canRead()) {
            this.log.warn((Object)("Can't read clowder config from " + file.getAbsolutePath() + ", not doing translations."));
            this.translate = false;
        } else {
            try (FileInputStream fis = new FileInputStream(file);){
                JsonReader reader = Json.createReader((InputStream)fis);
                this.root = reader.readObject();
            }
            catch (IOException ioe) {
                this.log.warn((Object)("Reading the clowder config failed, not doing translations: " + ioe.getMessage()));
            }
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Set<Map.Entry<String, ConfigValue>> entries = this.existingValues.entrySet();
        for (Map.Entry<String, ConfigValue> entry : entries) {
            String newVal = this.getValue(entry.getKey());
            if (newVal == null) {
                newVal = entry.getValue().getValue();
            }
            props.put(entry.getKey(), newVal);
        }
        return props;
    }

    public Set<String> getPropertyNames() {
        return this.existingValues.keySet();
    }

    public int getOrdinal() {
        return 270;
    }

    public String getValue(String configKey) {
        if (this.translate) {
            if (configKey.equals("quarkus.http.port")) {
                JsonNumber webPort = this.root.getJsonNumber("webPort");
                return webPort.toString();
            }
            if (configKey.equals("kafka.bootstrap.servers")) {
                JsonArray brokers = this.root.getJsonObject("kafka").getJsonArray("brokers");
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < brokers.size(); ++i) {
                    JsonObject broker = brokers.getJsonObject(i);
                    String br = broker.getString("hostname") + ":" + broker.getJsonNumber("port").toString();
                    sb.append(br);
                    if (i >= brokers.size() - 1) continue;
                    sb.append(',');
                }
                return sb.toString();
            }
            if (configKey.startsWith("mp.messaging") && configKey.endsWith(".topic")) {
                String requested = this.existingValues.get(configKey).getValue();
                JsonArray topics = this.root.getJsonObject("kafka").getJsonArray("topics");
                for (int i = 0; i < topics.size(); ++i) {
                    JsonObject aTopic = topics.getJsonObject(i);
                    if (!aTopic.getString("requestedName").equals(requested)) continue;
                    String name = aTopic.getString("name");
                    return name;
                }
                return requested;
            }
            if (configKey.startsWith("quarkus.datasource")) {
                boolean useSsl;
                String item = configKey.substring("quarkus.datasource.".length());
                JsonObject dbObject = this.root.getJsonObject("database");
                if (item.equals("username")) {
                    return dbObject.getString("username");
                }
                String sslMode = dbObject.getString("sslMode");
                boolean bl = useSsl = !sslMode.equals("disable");
                if (item.equals("password")) {
                    return dbObject.getString("password");
                }
                if (item.equals("jdbc.url")) {
                    String url;
                    String hostPortDb = this.getHostPortDb(dbObject);
                    String tracing = "";
                    if (this.existingValues.containsKey("quarkus.datasource.jdbc.url") && (url = this.existingValues.get("quarkus.datasource.jdbc.url").getValue()).contains(":tracing:")) {
                        tracing = "tracing:";
                    }
                    Object jdbcUrl = String.format("jdbc:%s%s", tracing, hostPortDb);
                    if (useSsl) {
                        jdbcUrl = (String)jdbcUrl + "?sslmode=" + sslMode;
                    }
                    return jdbcUrl;
                }
                if (item.equals("reactive.url")) {
                    Object hostPortDb = this.getHostPortDb(dbObject);
                    if (useSsl) {
                        hostPortDb = (String)hostPortDb + "?sslmode=" + sslMode;
                    }
                    return hostPortDb;
                }
            }
        }
        if (this.existingValues.containsKey(configKey)) {
            return this.existingValues.get(configKey).getValue();
        }
        return null;
    }

    public String getName() {
        return CLOWDER_CONFIG_SOURCE;
    }

    private String getHostPortDb(JsonObject dbObject) {
        String host = dbObject.getString("hostname");
        int port = dbObject.getJsonNumber("port").intValue();
        String dbName = dbObject.getString("name");
        return String.format("postgresql://%s:%d/%s", host, port, dbName);
    }
}

