/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.clowder.configsource;

import io.smallrye.config.ConfigValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class ClowderConfigSource
implements ConfigSource {
    public static final String CLOWDER_CONFIG_SOURCE = "ClowderConfigSource";
    private static final String QUARKUS_LOG_CLOUDWATCH = "quarkus.log.cloudwatch";
    private static final String QUARKUS_DATASOURCE_JDBC_URL = "quarkus.datasource.jdbc.url";
    private static final String CLOWDER_ENDPOINTS = "clowder.endpoints.";
    Logger log = Logger.getLogger((String)this.getClass().getName());
    private final Map<String, ConfigValue> existingValues;
    JsonObject root;
    private boolean translate = true;

    public ClowderConfigSource(String configFile, Map<String, ConfigValue> exProp) {
        this.existingValues = exProp;
        File file = new File(configFile);
        if (!file.canRead()) {
            this.log.warn((Object)("Can't read clowder config from " + file.getAbsolutePath() + ", not doing translations."));
            this.translate = false;
        } else {
            try (FileInputStream fis = new FileInputStream(file);){
                JsonReader reader = Json.createReader((InputStream)fis);
                this.root = reader.readObject();
            }
            catch (IOException ioe) {
                this.log.warn((Object)("Reading the clowder config failed, not doing translations: " + ioe.getMessage()));
                this.translate = false;
            }
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Set<Map.Entry<String, ConfigValue>> entries = this.existingValues.entrySet();
        for (Map.Entry<String, ConfigValue> entry : entries) {
            String newVal = this.getValue(entry.getKey());
            if (newVal == null) {
                newVal = entry.getValue().getValue();
            }
            props.put(entry.getKey(), newVal);
        }
        return props;
    }

    public Set<String> getPropertyNames() {
        return this.existingValues.keySet();
    }

    public int getOrdinal() {
        return 270;
    }

    public String getValue(String configKey) {
        if (this.translate) {
            if (configKey.equals("quarkus.http.port")) {
                JsonNumber webPort = this.root.getJsonNumber("webPort");
                return webPort.toString();
            }
            JsonObject kafkaBase = this.root.getJsonObject("kafka");
            if (configKey.equals("kafka.bootstrap.servers")) {
                if (kafkaBase == null) {
                    throw new IllegalStateException("Kafka base object not present, can't set Kafka values");
                }
                JsonArray brokers = kafkaBase.getJsonArray("brokers");
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < brokers.size(); ++i) {
                    JsonObject broker = brokers.getJsonObject(i);
                    String br = broker.getString("hostname") + ":" + broker.getJsonNumber("port").toString();
                    sb.append(br);
                    if (i >= brokers.size() - 1) continue;
                    sb.append(',');
                }
                return sb.toString();
            }
            if (configKey.startsWith("mp.messaging") && configKey.endsWith(".topic")) {
                if (kafkaBase == null) {
                    throw new IllegalStateException("Kafka base object not present, can't set Kafka values");
                }
                String requested = this.existingValues.get(configKey).getValue();
                JsonArray topics = kafkaBase.getJsonArray("topics");
                for (int i = 0; i < topics.size(); ++i) {
                    JsonObject aTopic = topics.getJsonObject(i);
                    if (!aTopic.getString("requestedName").equals(requested)) continue;
                    String name = aTopic.getString("name");
                    return name;
                }
                return requested;
            }
            if (configKey.startsWith("quarkus.datasource")) {
                String item = configKey.substring("quarkus.datasource.".length());
                JsonObject dbObject = this.root.getJsonObject("database");
                if (dbObject == null) {
                    throw new IllegalStateException("No database section found");
                }
                if (item.equals("username")) {
                    return dbObject.getString("username");
                }
                String sslMode = dbObject.getString("sslMode");
                boolean useSsl = !sslMode.equals("disable");
                boolean verifyFull = sslMode.equals("verify-full");
                if (item.equals("password")) {
                    return dbObject.getString("password");
                }
                if (item.equals("jdbc.url")) {
                    String url;
                    String hostPortDb = this.getHostPortDb(dbObject);
                    String tracing = "";
                    if (this.existingValues.containsKey(QUARKUS_DATASOURCE_JDBC_URL) && (url = this.existingValues.get(QUARKUS_DATASOURCE_JDBC_URL).getValue()).contains(":tracing:")) {
                        tracing = "tracing:";
                    }
                    Object jdbcUrl = String.format("jdbc:%s%s", tracing, hostPortDb);
                    if (useSsl) {
                        jdbcUrl = (String)jdbcUrl + "?sslmode=" + sslMode;
                    }
                    if (verifyFull) {
                        jdbcUrl = (String)jdbcUrl + "&sslrootcert=" + this.createTempCertFile(dbObject);
                    }
                    return jdbcUrl;
                }
                if (item.equals("reactive.url")) {
                    Object hostPortDb = this.getHostPortDb(dbObject);
                    if (useSsl) {
                        hostPortDb = (String)hostPortDb + "?sslmode=" + sslMode;
                    }
                    if (verifyFull) {
                        hostPortDb = (String)hostPortDb + "&sslrootcert=" + this.createTempCertFile(dbObject);
                    }
                    return hostPortDb;
                }
            }
            if (configKey.startsWith(QUARKUS_LOG_CLOUDWATCH)) {
                String sub;
                JsonObject loggingObject = this.root.getJsonObject("logging");
                if (loggingObject == null) {
                    throw new IllegalStateException("No logging section found");
                }
                JsonObject cwObject = loggingObject.getJsonObject("cloudwatch");
                if (cwObject == null) {
                    throw new IllegalStateException("No cloudwatch section found in logging object");
                }
                int prefixLen = QUARKUS_LOG_CLOUDWATCH.length();
                switch (sub = configKey.substring(prefixLen + 1)) {
                    case "access-key-id": {
                        return cwObject.getString("accessKeyId");
                    }
                    case "access-key-secret": {
                        return cwObject.getString("secretAccessKey");
                    }
                    case "region": {
                        return cwObject.getString("region");
                    }
                    case "log-group": {
                        return cwObject.getString("logGroup");
                    }
                }
            }
            if (configKey.startsWith(CLOWDER_ENDPOINTS)) {
                try {
                    JsonArray endpoints = this.root.getJsonArray("endpoints");
                    if (endpoints == null) {
                        throw new IllegalStateException("No endpoints section found");
                    }
                    String requestedEndpoint = configKey.substring(CLOWDER_ENDPOINTS.length());
                    for (int i = 0; i < endpoints.size(); ++i) {
                        JsonObject endpoint = endpoints.getJsonObject(i);
                        String currentEndpoint = endpoint.getString("app") + "-" + endpoint.getString("name");
                        if (!currentEndpoint.equals(requestedEndpoint)) continue;
                        return endpoint.getString("hostname") + ":" + endpoint.getJsonNumber("port").intValue();
                    }
                    throw new IllegalStateException("Endpoint '" + requestedEndpoint + "' not found in the endpoints section");
                }
                catch (IllegalStateException e) {
                    this.log.errorf("Failed to load config key '%s' from the Clowder configuration: %s", (Object)configKey, (Object)e.getMessage());
                    throw e;
                }
            }
        }
        if (this.existingValues.containsKey(configKey)) {
            return this.existingValues.get(configKey).getValue();
        }
        return null;
    }

    public String getName() {
        return CLOWDER_CONFIG_SOURCE;
    }

    private String getHostPortDb(JsonObject dbObject) {
        String host = dbObject.getString("hostname");
        int port = dbObject.getJsonNumber("port").intValue();
        String dbName = dbObject.getString("name");
        return String.format("postgresql://%s:%d/%s", host, port, dbName);
    }

    private String createTempCertFile(JsonObject dbObject) {
        if (dbObject.containsKey((Object)"rdsCa")) {
            byte[] cert = dbObject.getString("rdsCa").getBytes(StandardCharsets.UTF_8);
            try {
                File certFile = File.createTempFile("rds-ca-root", ".crt");
                try {
                    certFile.deleteOnExit();
                }
                catch (SecurityException e) {
                    this.log.warn((Object)"Delete on exit of the RDS cert file denied by the security manager", (Throwable)e);
                }
                return Files.write(Path.of(certFile.getAbsolutePath(), new String[0]), cert, new OpenOption[0]).toString();
            }
            catch (IOException e) {
                throw new UncheckedIOException("RDS certificate file creation failed", e);
            }
        }
        throw new IllegalStateException("'database.sslMode' is set to 'verify-full' in the Clowder config but the 'database.rdsCa' field is missing");
    }
}

