/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.clowder.configsource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.cloud.common.clowder.configsource.BrokerConfig;
import com.redhat.cloud.common.clowder.configsource.ClowderConfig;
import com.redhat.cloud.common.clowder.configsource.DatabaseConfig;
import com.redhat.cloud.common.clowder.configsource.EndpointConfig;
import com.redhat.cloud.common.clowder.configsource.TopicConfig;
import io.smallrye.config.ConfigValue;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class ClowderConfigSource
implements ConfigSource {
    public static final String CLOWDER_CONFIG_SOURCE = "ClowderConfigSource";
    public static final String KAFKA_SASL_MECHANISM = "SCRAM-SHA-512";
    public static final String KAFKA_SASL_SECURITY_PROTOCOL = "SASL_SSL";
    private static final String QUARKUS_LOG_CLOUDWATCH = "quarkus.log.cloudwatch";
    private static final String QUARKUS_DATASOURCE_JDBC_URL = "quarkus.datasource.jdbc.url";
    private static final String CLOWDER_ENDPOINTS = "clowder.endpoints.";
    private static List<String> KAFKA_SASL_KEYS = List.of("kafka.sasl.jaas.config", "kafka.sasl.mechanism", "kafka.security.protocol", "kafka.ssl.truststore.location");
    Logger log = Logger.getLogger((String)this.getClass().getName());
    private final Map<String, ConfigValue> existingValues;
    private ClowderConfig root;
    private boolean translate = true;

    public ClowderConfigSource(String configFile, Map<String, ConfigValue> exProp) {
        this.existingValues = exProp;
        File file = new File(configFile);
        if (!file.canRead()) {
            this.log.warn((Object)("Can't read clowder config from " + file.getAbsolutePath() + ", not doing translations."));
            this.translate = false;
        } else {
            try {
                String configJson = Files.readString(file.toPath());
                this.root = (ClowderConfig)new ObjectMapper().readValue(configJson, ClowderConfig.class);
            }
            catch (IOException e) {
                this.log.warn((Object)"Reading the clowder config failed, not doing translations", (Throwable)e);
                this.translate = false;
            }
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Set<Map.Entry<String, ConfigValue>> entries = this.existingValues.entrySet();
        for (Map.Entry<String, ConfigValue> entry : entries) {
            String newVal = this.getValue(entry.getKey());
            if (newVal == null) {
                newVal = entry.getValue().getValue();
            }
            props.put(entry.getKey(), newVal);
        }
        return props;
    }

    public Set<String> getPropertyNames() {
        return this.existingValues.keySet();
    }

    public int getOrdinal() {
        return 270;
    }

    public String getValue(String configKey) {
        if (this.translate) {
            if (configKey.equals("quarkus.http.port")) {
                return String.valueOf(this.root.webPort);
            }
            if (configKey.equals("kafka.bootstrap.servers")) {
                if (this.root.kafka == null) {
                    throw new IllegalStateException("Kafka base object not present, can't set Kafka values");
                }
                StringBuilder sb = new StringBuilder();
                for (BrokerConfig broker2 : this.root.kafka.brokers) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(broker2.hostname + ":" + broker2.port);
                }
                return sb.toString();
            }
            if (configKey.startsWith("mp.messaging") && configKey.endsWith(".topic")) {
                if (this.root.kafka == null) {
                    throw new IllegalStateException("Kafka base object not present, can't set Kafka values");
                }
                String requested = this.existingValues.get(configKey).getValue();
                for (TopicConfig topic : this.root.kafka.topics) {
                    if (!topic.requestedName.equals(requested)) continue;
                    return topic.name;
                }
                return requested;
            }
            if (KAFKA_SASL_KEYS.contains(configKey)) {
                if (this.root.kafka == null) {
                    throw new IllegalStateException("Kafka base object not present, can't set Kafka values");
                }
                Optional<BrokerConfig> saslBroker = this.root.kafka.brokers.stream().filter(broker -> "sasl".equals(broker.authtype)).findAny();
                if (saslBroker.isPresent()) {
                    switch (configKey) {
                        case "kafka.sasl.jaas.config": {
                            String username = saslBroker.get().sasl.username;
                            String password = saslBroker.get().sasl.password;
                            return "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"" + username + "\" password=\"" + password + "\";";
                        }
                        case "kafka.sasl.mechanism": {
                            return KAFKA_SASL_MECHANISM;
                        }
                        case "kafka.security.protocol": {
                            return KAFKA_SASL_SECURITY_PROTOCOL;
                        }
                        case "kafka.ssl.truststore.location": {
                            return saslBroker.get().cacert;
                        }
                    }
                }
            }
            if (configKey.startsWith("quarkus.datasource")) {
                String item = configKey.substring("quarkus.datasource.".length());
                if (this.root.database == null) {
                    throw new IllegalStateException("No database section found");
                }
                if (item.equals("username")) {
                    return this.root.database.username;
                }
                String sslMode = this.root.database.sslMode;
                boolean useSsl = !sslMode.equals("disable");
                int verifyFull = sslMode.equals("verify-full") ? 1 : 0;
                if (item.equals("password")) {
                    return this.root.database.password;
                }
                if (item.equals("jdbc.url")) {
                    String url;
                    String hostPortDb = this.getHostPortDb(this.root.database);
                    String tracing = "";
                    if (this.existingValues.containsKey(QUARKUS_DATASOURCE_JDBC_URL) && (url = this.existingValues.get(QUARKUS_DATASOURCE_JDBC_URL).getValue()).contains(":tracing:")) {
                        tracing = "tracing:";
                    }
                    Object jdbcUrl = String.format("jdbc:%s%s", tracing, hostPortDb);
                    if (useSsl) {
                        jdbcUrl = (String)jdbcUrl + "?sslmode=" + sslMode;
                    }
                    if (verifyFull != 0) {
                        jdbcUrl = (String)jdbcUrl + "&sslrootcert=" + this.createTempCertFile(this.root.database);
                    }
                    return jdbcUrl;
                }
                if (item.startsWith("reactive.")) {
                    if (item.equals("reactive.url")) {
                        return this.getHostPortDb(this.root.database);
                    }
                    if (item.equals("reactive.postgresql.ssl-mode")) {
                        return sslMode;
                    }
                    if (verifyFull != 0) {
                        if (item.equals("reactive.hostname-verification-algorithm")) {
                            return "HTTPS";
                        }
                        if (item.equals("reactive.trust-certificate-pem")) {
                            return "true";
                        }
                        if (item.equals("reactive.trust-certificate-pem.certs")) {
                            return this.createTempCertFile(this.root.database);
                        }
                    }
                }
            }
            if (configKey.startsWith(QUARKUS_LOG_CLOUDWATCH)) {
                String sub;
                if (this.root.logging == null) {
                    throw new IllegalStateException("No logging section found");
                }
                if (this.root.logging.cloudwatch == null) {
                    throw new IllegalStateException("No cloudwatch section found in logging object");
                }
                int prefixLen = QUARKUS_LOG_CLOUDWATCH.length();
                switch (sub = configKey.substring(prefixLen + 1)) {
                    case "access-key-id": {
                        return this.root.logging.cloudwatch.accessKeyId;
                    }
                    case "access-key-secret": {
                        return this.root.logging.cloudwatch.secretAccessKey;
                    }
                    case "region": {
                        return this.root.logging.cloudwatch.region;
                    }
                    case "log-group": {
                        return this.root.logging.cloudwatch.logGroup;
                    }
                }
            }
            if (configKey.startsWith(CLOWDER_ENDPOINTS)) {
                try {
                    if (this.root.endpoints == null) {
                        throw new IllegalStateException("No endpoints section found");
                    }
                    String requestedEndpoint = configKey.substring(CLOWDER_ENDPOINTS.length());
                    for (EndpointConfig endpoint : this.root.endpoints) {
                        String currentEndpoint = endpoint.app + "-" + endpoint.name;
                        if (!currentEndpoint.equals(requestedEndpoint)) continue;
                        return "http://" + endpoint.hostname + ":" + endpoint.port;
                    }
                    throw new IllegalStateException("Endpoint '" + requestedEndpoint + "' not found in the endpoints section");
                }
                catch (IllegalStateException e) {
                    this.log.errorf("Failed to load config key '%s' from the Clowder configuration: %s", (Object)configKey, (Object)e.getMessage());
                    throw e;
                }
            }
        }
        if (this.existingValues.containsKey(configKey)) {
            return this.existingValues.get(configKey).getValue();
        }
        return null;
    }

    public String getName() {
        return CLOWDER_CONFIG_SOURCE;
    }

    private String getHostPortDb(DatabaseConfig database) {
        return String.format("postgresql://%s:%d/%s", database.hostname, database.port, database.name);
    }

    private String createTempCertFile(DatabaseConfig database) {
        if (database.rdsCa != null) {
            byte[] cert = database.rdsCa.getBytes(StandardCharsets.UTF_8);
            try {
                File certFile = File.createTempFile("rds-ca-root", ".crt");
                try {
                    certFile.deleteOnExit();
                }
                catch (SecurityException e) {
                    this.log.warn((Object)"Delete on exit of the RDS cert file denied by the security manager", (Throwable)e);
                }
                return Files.write(Path.of(certFile.getAbsolutePath(), new String[0]), cert, new OpenOption[0]).toString();
            }
            catch (IOException e) {
                throw new UncheckedIOException("RDS certificate file creation failed", e);
            }
        }
        throw new IllegalStateException("'database.sslMode' is set to 'verify-full' in the Clowder config but the 'database.rdsCa' field is missing");
    }
}

