/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.clowder.configsource;

import com.redhat.cloud.common.clowder.configsource.ClowderConfigSource;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Expressions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.OptionalInt;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class ClowderConfigSourceFactory
implements ConfigSourceFactory {
    Logger log = Logger.getLogger((String)this.getClass().getName());

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext configSourceContext) {
        ConfigValue cv = configSourceContext.getValue("acg.config");
        String clowderConfig = cv != null && cv.getValue() != null ? cv.getValue() : "/cdapp/cdappconfig.json";
        this.log.info((Object)("Using ClowderConfigSource with config at " + clowderConfig));
        HashMap<String, ConfigValue> exProp = new HashMap<String, ConfigValue>();
        Iterator stringIterator = configSourceContext.iterateNames();
        Expressions.withoutExpansion(() -> {
            while (stringIterator.hasNext()) {
                String key = (String)stringIterator.next();
                ConfigValue value = configSourceContext.getValue(key);
                exProp.put(key, value);
            }
        });
        return Collections.singletonList(new ClowderConfigSource(clowderConfig, exProp));
    }

    public OptionalInt getPriority() {
        return OptionalInt.of(270);
    }
}

