/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.clowder.configsource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.cloud.common.clowder.configsource.BrokerConfig;
import com.redhat.cloud.common.clowder.configsource.ClowderConfig;
import com.redhat.cloud.common.clowder.configsource.DatabaseConfig;
import com.redhat.cloud.common.clowder.configsource.EndpointConfig;
import com.redhat.cloud.common.clowder.configsource.TopicConfig;
import io.smallrye.config.ConfigValue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class ClowderConfigSource
implements ConfigSource {
    public static final String CLOWDER_CONFIG_SOURCE = "ClowderConfigSource";
    public static final String KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";
    public static final String KAFKA_SASL_JAAS_CONFIG_KEY = "kafka.sasl.jaas.config";
    public static final String KAFKA_SASL_MECHANISM_KEY = "kafka.sasl.mechanism";
    public static final String KAFKA_SECURITY_PROTOCOL_KEY = "kafka.security.protocol";
    public static final String KAFKA_SSL_TRUSTSTORE_LOCATION_KEY = "kafka.ssl.truststore.location";
    public static final String KAFKA_SSL_TRUSTSTORE_TYPE_KEY = "kafka.ssl.truststore.type";
    public static final String CAMEL_KAFKA_BROKERS = "camel.component.kafka.brokers";
    public static final String CAMEL_KAFKA_SASL_JAAS_CONFIG_KEY = "camel.component.kafka.sasl-jaas-config";
    public static final String CAMEL_KAFKA_SASL_MECHANISM_KEY = "camel.component.kafka.sasl-mechanism";
    public static final String CAMEL_KAFKA_SECURITY_PROTOCOL_KEY = "camel.component.kafka.security-protocol";
    public static final String CAMEL_KAFKA_SSL_TRUSTSTORE_LOCATION_KEY = "camel.component.kafka.ssl-truststore-location";
    public static final String CAMEL_KAFKA_SSL_TRUSTSTORE_TYPE_KEY = "camel.component.kafka.ssl-truststore-type";
    public static final String KAFKA_SSL_TRUSTSTORE_TYPE_VALUE = "PEM";
    private static final String QUARKUS_LOG_CLOUDWATCH = "quarkus.log.cloudwatch";
    private static final String QUARKUS_DATASOURCE_JDBC_URL = "quarkus.datasource.jdbc.url";
    private static final String CLOWDER_ENDPOINTS = "clowder.endpoints.";
    private static final String CLOWDER_PRIVATE_ENDPOINTS = "clowder.private-endpoints.";
    private static final String CLOWDER_OPTIONAL_ENDPOINTS = "clowder.optional-endpoints.";
    private static final String CLOWDER_OPTIONAL_PRIVATE_ENDPOINTS = "clowder.optional-private-endpoints.";
    private static final String CLOWDER_ENDPOINTS_PARAM_URL = "url";
    private static final String CLOWDER_ENDPOINT_STORE_TYPE = "PKCS12";
    private static final String CLOWDER_ENDPOINTS_PARAM_TRUST_STORE_PATH = "trust-store-path";
    private static final String CLOWDER_ENDPOINTS_PARAM_TRUST_STORE_PASSWORD = "trust-store-password";
    private static final String CLOWDER_ENDPOINTS_PARAM_TRUST_STORE_TYPE = "trust-store-type";
    private static List<String> KAFKA_SASL_KEYS = List.of("kafka.sasl.jaas.config", "kafka.sasl.mechanism", "kafka.security.protocol", "kafka.ssl.truststore.location", "kafka.ssl.truststore.type", "camel.component.kafka.sasl-jaas-config", "camel.component.kafka.sasl-mechanism", "camel.component.kafka.security-protocol", "camel.component.kafka.ssl-truststore-location", "camel.component.kafka.ssl-truststore-type");
    private static final int DEFAULT_PASSWORD_LENGTH = 33;
    private static final Integer PORT_NOT_SET = 0;
    Logger log = Logger.getLogger((String)this.getClass().getName());
    private final Map<String, ConfigValue> existingValues;
    private ClowderConfig root;
    private boolean translate = true;
    private String trustStorePath;
    private String trustStorePassword;
    private boolean exposeKafkaSslConfigKeys;

    public ClowderConfigSource(String configFile, Map<String, ConfigValue> exProp, boolean exposeKafkaSslConfigKeys) {
        this.existingValues = exProp;
        this.exposeKafkaSslConfigKeys = exposeKafkaSslConfigKeys;
        File file = new File(configFile);
        if (!file.canRead()) {
            this.log.warn((Object)("Can't read clowder config from " + file.getAbsolutePath() + ", not doing translations."));
            this.translate = false;
        } else {
            try {
                String configJson = Files.readString(file.toPath());
                this.root = (ClowderConfig)new ObjectMapper().readValue(configJson, ClowderConfig.class);
            }
            catch (IOException e) {
                this.log.warn((Object)"Reading the clowder config failed, not doing translations", (Throwable)e);
                this.translate = false;
            }
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Set<Map.Entry<String, ConfigValue>> entries = this.existingValues.entrySet();
        for (Map.Entry<String, ConfigValue> entry : entries) {
            String newVal = this.getValue(entry.getKey());
            if (newVal == null) {
                newVal = entry.getValue().getValue();
            }
            props.put(entry.getKey(), newVal);
        }
        return props;
    }

    public Set<String> getPropertyNames() {
        HashSet<String> availableProperties = new HashSet<String>(this.existingValues.keySet());
        if (this.exposeKafkaSslConfigKeys) {
            for (String key : KAFKA_SASL_KEYS) {
                String value = this.getValue(key);
                if (value == null || value.isBlank()) continue;
                availableProperties.add(key);
            }
        }
        return availableProperties;
    }

    public int getOrdinal() {
        return 270;
    }

    public String getValue(String configKey) {
        if (this.translate) {
            if (configKey.equals("quarkus.http.port")) {
                return String.valueOf(this.root.webPort);
            }
            if (configKey.equals(KAFKA_BOOTSTRAP_SERVERS) || configKey.equals(CAMEL_KAFKA_BROKERS)) {
                if (this.root.kafka == null) {
                    throw new IllegalStateException("Kafka base object not present, can't set Kafka values");
                }
                StringBuilder sb = new StringBuilder();
                for (BrokerConfig broker2 : this.root.kafka.brokers) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(broker2.hostname + ":" + broker2.port);
                }
                return sb.toString();
            }
            if (configKey.startsWith("mp.messaging") && configKey.endsWith(".topic")) {
                if (this.root.kafka == null) {
                    throw new IllegalStateException("Kafka base object not present, can't set Kafka values");
                }
                String requested = this.existingValues.get(configKey).getValue();
                for (TopicConfig topic : this.root.kafka.topics) {
                    if (!topic.requestedName.equals(requested)) continue;
                    return topic.name;
                }
                return requested;
            }
            if (KAFKA_SASL_KEYS.contains(configKey)) {
                if (this.root.kafka == null) {
                    throw new IllegalStateException("Kafka base object not present, can't set Kafka values");
                }
                Optional<BrokerConfig> saslBroker = this.root.kafka.brokers.stream().filter(broker -> "sasl".equals(broker.authtype)).findAny();
                if (saslBroker.isPresent()) {
                    switch (configKey) {
                        case "kafka.sasl.jaas.config": 
                        case "camel.component.kafka.sasl-jaas-config": {
                            String username = saslBroker.get().sasl.username;
                            String password = saslBroker.get().sasl.password;
                            switch (saslBroker.get().sasl.saslMechanism) {
                                case "PLAIN": {
                                    return "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + username + "\" password=\"" + password + "\";";
                                }
                                case "SCRAM-SHA-512": {
                                    return "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"" + username + "\" password=\"" + password + "\";";
                                }
                            }
                        }
                        case "kafka.sasl.mechanism": 
                        case "camel.component.kafka.sasl-mechanism": {
                            return saslBroker.get().sasl.saslMechanism;
                        }
                        case "kafka.security.protocol": 
                        case "camel.component.kafka.security-protocol": {
                            return saslBroker.get().sasl.securityProtocol;
                        }
                        case "kafka.ssl.truststore.location": 
                        case "camel.component.kafka.ssl-truststore-location": {
                            return this.createTempKafkaCertFile(saslBroker.get().cacert);
                        }
                        case "kafka.ssl.truststore.type": 
                        case "camel.component.kafka.ssl-truststore-type": {
                            return KAFKA_SSL_TRUSTSTORE_TYPE_VALUE;
                        }
                    }
                    throw new IllegalStateException("Unexpected Kafka SASL config key: " + configKey);
                }
            }
            if (configKey.startsWith("quarkus.datasource")) {
                String item = configKey.substring("quarkus.datasource.".length());
                if (this.root.database == null) {
                    throw new IllegalStateException("No database section found");
                }
                if (item.equals("username")) {
                    return this.root.database.username;
                }
                String sslMode = this.root.database.sslMode;
                boolean useSsl = !sslMode.equals("disable");
                boolean verifyFull = sslMode.equals("verify-full");
                if (item.equals("password")) {
                    return this.root.database.password;
                }
                if (item.equals("jdbc.url")) {
                    String hostPortDb = this.getHostPortDb(this.root.database);
                    String tracing = "";
                    if (this.existingValues.containsKey(QUARKUS_DATASOURCE_JDBC_URL)) {
                        String url = this.existingValues.get(QUARKUS_DATASOURCE_JDBC_URL).getValue();
                        if (url.contains(":tracing:")) {
                            this.log.warn((Object)"The support of OpenTracing in this library is deprecated and will be removed soon. Please consider switching to OpenTelemetry.");
                            tracing = "tracing:";
                        } else if (url.contains(":otel:")) {
                            tracing = "otel:";
                        }
                    }
                    Object jdbcUrl = String.format("jdbc:%s%s", tracing, hostPortDb);
                    if (useSsl) {
                        jdbcUrl = (String)jdbcUrl + "?sslmode=" + sslMode;
                    }
                    if (verifyFull) {
                        jdbcUrl = (String)jdbcUrl + "&sslrootcert=" + this.createTempRdsCertFile(this.root.database.rdsCa);
                    }
                    return jdbcUrl;
                }
                if (item.startsWith("reactive.")) {
                    if (item.equals("reactive.url")) {
                        return this.getHostPortDb(this.root.database);
                    }
                    if (item.equals("reactive.postgresql.ssl-mode")) {
                        return sslMode;
                    }
                    if (verifyFull) {
                        if (item.equals("reactive.hostname-verification-algorithm")) {
                            return "HTTPS";
                        }
                        if (item.equals("reactive.trust-certificate-pem")) {
                            return "true";
                        }
                        if (item.equals("reactive.trust-certificate-pem.certs")) {
                            return this.createTempRdsCertFile(this.root.database.rdsCa);
                        }
                    }
                }
            }
            if (configKey.startsWith(QUARKUS_LOG_CLOUDWATCH)) {
                if (this.root.logging == null) {
                    throw new IllegalStateException("No logging section found");
                }
                if (this.root.logging.cloudwatch == null) {
                    throw new IllegalStateException("No cloudwatch section found in logging object");
                }
                if (this.root.logging.type != null && !this.root.logging.type.equals("null")) {
                    String sub;
                    int prefixLen = QUARKUS_LOG_CLOUDWATCH.length();
                    switch (sub = configKey.substring(prefixLen + 1)) {
                        case "access-key-id": {
                            return this.root.logging.cloudwatch.accessKeyId;
                        }
                        case "access-key-secret": {
                            return this.root.logging.cloudwatch.secretAccessKey;
                        }
                        case "region": {
                            return this.root.logging.cloudwatch.region;
                        }
                        case "log-group": {
                            return this.root.logging.cloudwatch.logGroup;
                        }
                    }
                } else if (configKey.equals("quarkus.log.cloudwatch.enabled")) {
                    return "false";
                }
            }
            if (configKey.startsWith(CLOWDER_ENDPOINTS)) {
                try {
                    if (this.root.endpoints == null) {
                        throw new IllegalStateException("No endpoints section found");
                    }
                    return this.processEndpoints(this.root.endpoints, configKey, CLOWDER_ENDPOINTS, "Endpoint");
                }
                catch (IllegalStateException e) {
                    this.log.errorf("Failed to load config key '%s' from the Clowder configuration: %s", (Object)configKey, (Object)e.getMessage());
                    throw e;
                }
            }
            if (configKey.startsWith(CLOWDER_OPTIONAL_ENDPOINTS)) {
                try {
                    if (this.root.endpoints == null) {
                        this.log.infof("No endpoints section found. Returning empty string for the \"%s\" configuration key", (Object)configKey);
                        return "";
                    }
                    return this.processEndpoints(this.root.endpoints, configKey, CLOWDER_OPTIONAL_ENDPOINTS, "Endpoint");
                }
                catch (IllegalStateException e) {
                    this.log.errorf("Failed to load config key '%s' from the Clowder configuration: %s", (Object)configKey, (Object)e.getMessage());
                    throw e;
                }
            }
            if (configKey.startsWith(CLOWDER_OPTIONAL_PRIVATE_ENDPOINTS)) {
                try {
                    if (this.root.privateEndpoints == null) {
                        this.log.infof("No private endpoints section found. Returning empty string for the \"%s\" configuration key", (Object)configKey);
                        return "";
                    }
                    return this.processEndpoints(this.root.privateEndpoints, configKey, CLOWDER_OPTIONAL_PRIVATE_ENDPOINTS, "Private endpoint");
                }
                catch (IllegalStateException e) {
                    this.log.errorf("Failed to load config key '%s' from the Clowder configuration: %s", (Object)configKey, (Object)e.getMessage());
                    throw e;
                }
            }
            if (configKey.startsWith(CLOWDER_PRIVATE_ENDPOINTS)) {
                try {
                    if (this.root.privateEndpoints == null) {
                        throw new IllegalStateException("No private endpoints section found");
                    }
                    return this.processEndpoints(this.root.privateEndpoints, configKey, CLOWDER_PRIVATE_ENDPOINTS, "Private endpoint");
                }
                catch (IllegalStateException e) {
                    this.log.errorf("Failed to load config key '%s' from the Clowder configuration: %s", (Object)configKey, (Object)e.getMessage());
                    throw e;
                }
            }
        }
        if (this.existingValues.containsKey(configKey)) {
            return this.existingValues.get(configKey).getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String processEndpoints(List<? extends EndpointConfig> endpointConfigs, String configKey, String clowderKey, String endpointType) {
        void var12_18;
        String param;
        String requestedEndpoint;
        String requestedEndpointConfig = configKey.substring(clowderKey.length());
        String[] configPath = requestedEndpointConfig.split("\\.");
        String FORMAT_EXAMPLE = String.format("[%s].[url|trust-store-path|trust-store-password|trust-store-type]", endpointType);
        if (configPath.length == 1) {
            this.log.warnf("%s '%s' is using the old format. Please move to the new one: %s", (Object)endpointType, (Object)requestedEndpointConfig, (Object)FORMAT_EXAMPLE);
            requestedEndpoint = configPath[0];
            param = CLOWDER_ENDPOINTS_PARAM_URL;
        } else {
            if (configPath.length != 2) {
                throw new IllegalArgumentException(String.format("%s '%s' expects a different format: %s", endpointType, requestedEndpointConfig, FORMAT_EXAMPLE));
            }
            requestedEndpoint = configPath[0];
            param = configPath[1];
        }
        EndpointConfig endpointConfig = null;
        for (EndpointConfig endpointConfig2 : endpointConfigs) {
            String currentEndpoint = String.format("%s-%s", endpointConfig2.app, endpointConfig2.name);
            if (!currentEndpoint.equals(requestedEndpoint)) continue;
            endpointConfig = endpointConfig2;
            break;
        }
        if (endpointConfig == null) {
            this.log.warnf("%s '%s' not found in the %s section", (Object)endpointType, (Object)requestedEndpoint, (Object)clowderKey.substring(0, clowderKey.length() - 1));
            return null;
        }
        String string = param;
        int n = -1;
        switch (string.hashCode()) {
            case 116079: {
                if (!string.equals(CLOWDER_ENDPOINTS_PARAM_URL)) break;
                boolean bl = false;
                break;
            }
            case 1978284070: {
                if (!string.equals(CLOWDER_ENDPOINTS_PARAM_TRUST_STORE_PATH)) break;
                boolean bl = true;
                break;
            }
            case -2025609700: {
                if (!string.equals(CLOWDER_ENDPOINTS_PARAM_TRUST_STORE_PASSWORD)) break;
                int n2 = 2;
                break;
            }
            case 1978426171: {
                if (!string.equals(CLOWDER_ENDPOINTS_PARAM_TRUST_STORE_TYPE)) break;
                int n3 = 3;
            }
        }
        switch (var12_18) {
            case 0: {
                if (this.usesTls(endpointConfig)) {
                    return String.format("https://%s:%s", endpointConfig.hostname, endpointConfig.tlsPort);
                }
                return String.format("http://%s:%s", endpointConfig.hostname, endpointConfig.port);
            }
            case 1: {
                if (this.usesTls(endpointConfig)) {
                    this.ensureTlsCertPathIsPresent();
                    this.createTruststoreFile(this.root.tlsCAPath);
                    return this.trustStorePath;
                }
                return null;
            }
            case 2: {
                if (this.usesTls(endpointConfig)) {
                    this.ensureTlsCertPathIsPresent();
                    this.createTruststoreFile(this.root.tlsCAPath);
                    return this.trustStorePassword;
                }
                return null;
            }
            case 3: {
                if (this.usesTls(endpointConfig)) {
                    this.ensureTlsCertPathIsPresent();
                    return CLOWDER_ENDPOINT_STORE_TYPE;
                }
                return null;
            }
        }
        this.log.warnf("%s '%s' requested an unknown param: '%s'", (Object)endpointType, (Object)requestedEndpoint, (Object)param);
        return null;
    }

    public String getName() {
        return CLOWDER_CONFIG_SOURCE;
    }

    private String getHostPortDb(DatabaseConfig database) {
        return String.format("postgresql://%s:%d/%s", database.hostname, database.port, database.name);
    }

    private boolean usesTls(EndpointConfig endpointConfig) {
        return endpointConfig.tlsPort != null && !endpointConfig.tlsPort.equals(PORT_NOT_SET);
    }

    private void ensureTlsCertPathIsPresent() {
        if (this.root.tlsCAPath == null || this.root.tlsCAPath.isBlank()) {
            throw new IllegalStateException("Requested tls port for endpoint but did not provide tlsCAPath");
        }
    }

    private void createTruststoreFile(String certPath) {
        if (this.trustStorePath != null) {
            return;
        }
        try {
            String certContent = Files.readString(new File(certPath).toPath(), StandardCharsets.UTF_8);
            List<String> base64Certs = ClowderConfigSource.readCerts(certContent);
            List certificates = this.parsePemCert(base64Certs).stream().map(this::buildX509Cert).collect(Collectors.toList());
            if (certificates.size() < 1) {
                throw new IllegalStateException("Could not parse any certificate in the file");
            }
            KeyStore truststore = KeyStore.getInstance(CLOWDER_ENDPOINT_STORE_TYPE);
            truststore.load(null);
            for (int i = 0; i < certificates.size(); ++i) {
                truststore.setCertificateEntry("cert-" + i, (Certificate)certificates.get(i));
            }
            char[] password = this.buildPassword(base64Certs.get(0));
            this.trustStorePath = this.writeTruststore(truststore, password);
            this.trustStorePassword = new String(password);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Couldn't load the certificate, but we were requested a truststore", ioe);
        }
        catch (KeyStoreException kse) {
            throw new IllegalStateException("Couldn't load the keystore format PKCS12", kse);
        }
        catch (NoSuchAlgorithmException | CertificateException ce) {
            throw new IllegalStateException("Couldn't configure the keystore", ce);
        }
    }

    static List<String> readCerts(String certString) {
        return Arrays.stream(certString.split("-----BEGIN CERTIFICATE-----")).filter(s -> !s.isEmpty()).map(s -> Arrays.stream(s.split("-----END CERTIFICATE-----")).filter(s2 -> !s2.isEmpty()).findFirst().orElseThrow(() -> new IllegalStateException("Invalid certificate found"))).map(String::trim).map(s -> s.replaceAll("\n", "")).collect(Collectors.toList());
    }

    private List<byte[]> parsePemCert(List<String> base64Certs) {
        return base64Certs.stream().map(cert -> Base64.getDecoder().decode(cert.getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList());
    }

    private X509Certificate buildX509Cert(byte[] cert) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(cert));
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException("Couldn't load the x509 certificate factory", certificateException);
        }
    }

    private String writeTruststore(KeyStore keyStore, char[] password) {
        try {
            File file = this.createTempFile("truststore", ".trust");
            keyStore.store(new FileOutputStream(file), password);
            return file.getAbsolutePath();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("Truststore creation failed", e);
        }
    }

    private char[] buildPassword(String seed) {
        int size = Math.min(33, seed.length());
        char[] password = new char[size];
        seed.getChars(0, size, password, 0);
        return password;
    }

    private String createTempRdsCertFile(String certData) {
        if (certData != null) {
            return this.createTempCertFile("rds-ca-root", certData);
        }
        throw new IllegalStateException("'database.sslMode' is set to 'verify-full' in the Clowder config but the 'database.rdsCa' field is missing");
    }

    private String createTempKafkaCertFile(String certData) {
        if (certData != null) {
            return this.createTempCertFile("kafka-cacert", certData);
        }
        return null;
    }

    private String createTempCertFile(String fileName, String certData) {
        byte[] cert = certData.getBytes(StandardCharsets.UTF_8);
        try {
            File certFile = this.createTempFile(fileName, ".crt");
            return Files.write(Path.of(certFile.getAbsolutePath(), new String[0]), cert, new OpenOption[0]).toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Certificate file creation failed", e);
        }
    }

    private File createTempFile(String fileName, String suffix) throws IOException {
        File file = File.createTempFile(fileName, suffix);
        try {
            file.deleteOnExit();
        }
        catch (SecurityException e) {
            this.log.warnf((Throwable)e, "Delete on exit of the '%s' cert file denied by the security manager", (Object)fileName);
        }
        return file;
    }
}

