/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.clowder.configsource.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ComputedPropertiesUtils {
    public static final String PROPERTY_START = "${";
    public static final String PROPERTY_END = "}";

    private ComputedPropertiesUtils() {
    }

    public static boolean hasComputedProperties(String rawValue) {
        return ComputedPropertiesUtils.isNotNullOrEmpty(rawValue) && rawValue.contains(PROPERTY_START);
    }

    public static String getPropertyFromSystem(String propertyName, String defaultValue) {
        String value = Optional.ofNullable(System.getProperty(propertyName)).orElseGet(() -> System.getenv(propertyName));
        return ComputedPropertiesUtils.isNullOrEmpty(value) ? defaultValue : value;
    }

    public static List<String> getComputedProperties(String str) {
        int end;
        int start;
        if (ComputedPropertiesUtils.isNullOrEmpty(str)) {
            return Collections.emptyList();
        }
        int closeLen = PROPERTY_END.length();
        int openLen = PROPERTY_START.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < str.length() - closeLen && (start = str.indexOf(PROPERTY_START, pos)) >= 0 && (end = str.indexOf(PROPERTY_END, start += openLen)) >= 0) {
            String currentStr = str.substring(start);
            String tentative = currentStr.substring(0, end - start);
            while (ComputedPropertiesUtils.countMatches(tentative, PROPERTY_START) != ComputedPropertiesUtils.countMatches(tentative, PROPERTY_END) && ++end < str.length()) {
                tentative = currentStr.substring(0, end - start);
            }
            list.add(tentative);
            pos = end + closeLen;
        }
        return list;
    }

    private static int countMatches(String str, String sub) {
        if (!ComputedPropertiesUtils.isNullOrEmpty(str) && !ComputedPropertiesUtils.isNullOrEmpty(sub)) {
            int count = 0;
            int idx = 0;
            while ((idx = str.indexOf(sub, idx)) != -1) {
                ++count;
                idx += sub.length();
            }
            return count;
        }
        return 0;
    }

    private static boolean isNotNullOrEmpty(String str) {
        return !ComputedPropertiesUtils.isNullOrEmpty(str);
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

