/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.ingress;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.redhat.cloud.notifications.ingress.Context;
import com.redhat.cloud.notifications.ingress.Event;
import com.redhat.cloud.notifications.ingress.Recipient;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "id", "bundle", "application", "event_type", "timestamp", "account_id", "org_id", "context", "events", "recipients"})
public class Action {
    @JsonProperty(value="version")
    private String version = "2.0.0";
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="bundle")
    @JsonPropertyDescription(value="Bundle name as used during application registration")
    private String bundle;
    @JsonProperty(value="application")
    @JsonPropertyDescription(value="Application name as used during application registration")
    private String application;
    @JsonProperty(value="event_type")
    @JsonPropertyDescription(value="Event type name as used during application registration")
    private String eventType;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="ISO-8601 formatted date (per platform convention) when the message was sent in UTC. Dates with timezones/offsets are rejected.")
    private LocalDateTime timestamp;
    @JsonProperty(value="account_id")
    private String accountId;
    @JsonProperty(value="org_id")
    private String orgId;
    @JsonProperty(value="context")
    @JsonPropertyDescription(value="Extra information common to all events sent.")
    private Context context;
    @JsonProperty(value="events")
    private List<Event> events = new ArrayList<Event>();
    @JsonProperty(value="recipients")
    @JsonPropertyDescription(value="Applications can add extra email recipients by adding entries to this array. This setting extends whatever the Administrators configured in their Notifications settings. This won't override notification's administrator settings - this will extend the settings.")
    private List<Recipient> recipients = new ArrayList<Recipient>();

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    @JsonProperty(value="bundle")
    public String getBundle() {
        return this.bundle;
    }

    @JsonProperty(value="bundle")
    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    @JsonProperty(value="application")
    public String getApplication() {
        return this.application;
    }

    @JsonProperty(value="application")
    public void setApplication(String application) {
        this.application = application;
    }

    @JsonProperty(value="event_type")
    public String getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="event_type")
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @JsonProperty(value="timestamp")
    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="account_id")
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @JsonProperty(value="org_id")
    public String getOrgId() {
        return this.orgId;
    }

    @JsonProperty(value="org_id")
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @JsonProperty(value="context")
    public Context getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    public void setContext(Context context) {
        this.context = context;
    }

    @JsonProperty(value="events")
    public List<Event> getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    public void setEvents(List<Event> events) {
        this.events = events;
    }

    @JsonProperty(value="recipients")
    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    @JsonProperty(value="recipients")
    public void setRecipients(List<Recipient> recipients) {
        this.recipients = recipients;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Action.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("bundle");
        sb.append('=');
        sb.append(this.bundle == null ? "<null>" : this.bundle);
        sb.append(',');
        sb.append("application");
        sb.append('=');
        sb.append(this.application == null ? "<null>" : this.application);
        sb.append(',');
        sb.append("eventType");
        sb.append('=');
        sb.append(this.eventType == null ? "<null>" : this.eventType);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("accountId");
        sb.append('=');
        sb.append(this.accountId == null ? "<null>" : this.accountId);
        sb.append(',');
        sb.append("orgId");
        sb.append('=');
        sb.append(this.orgId == null ? "<null>" : this.orgId);
        sb.append(',');
        sb.append("context");
        sb.append('=');
        sb.append(this.context == null ? "<null>" : this.context);
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(this.events == null ? "<null>" : this.events);
        sb.append(',');
        sb.append("recipients");
        sb.append('=');
        sb.append(this.recipients == null ? "<null>" : this.recipients);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.accountId == null ? 0 : this.accountId.hashCode());
        result = result * 31 + (this.application == null ? 0 : this.application.hashCode());
        result = result * 31 + (this.recipients == null ? 0 : this.recipients.hashCode());
        result = result * 31 + (this.context == null ? 0 : this.context.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.bundle == null ? 0 : this.bundle.hashCode());
        result = result * 31 + (this.orgId == null ? 0 : this.orgId.hashCode());
        result = result * 31 + (this.events == null ? 0 : this.events.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Action)) {
            return false;
        }
        Action rhs = (Action)other;
        return (this.accountId == rhs.accountId || this.accountId != null && this.accountId.equals(rhs.accountId)) && (this.application == rhs.application || this.application != null && this.application.equals(rhs.application)) && (this.recipients == rhs.recipients || this.recipients != null && this.recipients.equals(rhs.recipients)) && (this.context == rhs.context || this.context != null && this.context.equals(rhs.context)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.eventType == rhs.eventType || this.eventType != null && this.eventType.equals(rhs.eventType)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.bundle == rhs.bundle || this.bundle != null && this.bundle.equals(rhs.bundle)) && (this.orgId == rhs.orgId || this.orgId != null && this.orgId.equals(rhs.orgId)) && (this.events == rhs.events || this.events != null && this.events.equals(rhs.events)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }

    public static abstract class ActionBuilderBase<T extends Action> {
        protected T instance;

        public ActionBuilderBase() {
            if (this.getClass().equals(ActionBuilder.class)) {
                this.instance = new Action();
            }
        }

        public T build() {
            T result = this.instance;
            this.instance = null;
            return result;
        }

        public ActionBuilderBase withVersion(String version) {
            ((Action)this.instance).version = version;
            return this;
        }

        public ActionBuilderBase withId(UUID id) {
            ((Action)this.instance).id = id;
            return this;
        }

        public ActionBuilderBase withBundle(String bundle) {
            ((Action)this.instance).bundle = bundle;
            return this;
        }

        public ActionBuilderBase withApplication(String application) {
            ((Action)this.instance).application = application;
            return this;
        }

        public ActionBuilderBase withEventType(String eventType) {
            ((Action)this.instance).eventType = eventType;
            return this;
        }

        public ActionBuilderBase withTimestamp(LocalDateTime timestamp) {
            ((Action)this.instance).timestamp = timestamp;
            return this;
        }

        public ActionBuilderBase withAccountId(String accountId) {
            ((Action)this.instance).accountId = accountId;
            return this;
        }

        public ActionBuilderBase withOrgId(String orgId) {
            ((Action)this.instance).orgId = orgId;
            return this;
        }

        public ActionBuilderBase withContext(Context context) {
            ((Action)this.instance).context = context;
            return this;
        }

        public ActionBuilderBase withEvents(List<Event> events) {
            ((Action)this.instance).events = events;
            return this;
        }

        public ActionBuilderBase withRecipients(List<Recipient> recipients) {
            ((Action)this.instance).recipients = recipients;
            return this;
        }
    }

    public static class ActionBuilder
    extends ActionBuilderBase<Action> {
    }
}

