/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.ingress;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.ApplyDefaultsStrategy;
import com.networknt.schema.Format;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.NonValidationKeyword;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorTypeCode;
import com.redhat.cloud.notifications.ingress.Action;
import com.redhat.cloud.notifications.ingress.ParsingException;
import com.redhat.cloud.notifications.jackson.LocalDateTimeModule;
import com.redhat.cloud.notifications.validator.LocalDateTimeValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;

public class Parser {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final JsonSchema jsonSchema = Parser.getJsonSchema();
    private static final String CONTEXT_FIELD = "context";
    private static final String EVENTS_FIELD = "events";
    private static final String PAYLOAD_FIELD = "payload";

    public static Action decode(String actionJson) {
        try {
            JsonNode action = objectMapper.readTree(actionJson);
            Parser.updateContextAndPayload(action, objectMapper);
            Parser.validate(action, jsonSchema);
            return (Action)objectMapper.treeToValue((TreeNode)action, Action.class);
        }
        catch (JsonProcessingException exception) {
            throw new UncheckedIOException("Unable to decode action", (IOException)((Object)exception));
        }
    }

    public static String encode(Action action) {
        try {
            JsonNode asNode = objectMapper.valueToTree((Object)action);
            Parser.validate(asNode, jsonSchema);
            return objectMapper.writeValueAsString((Object)asNode);
        }
        catch (JsonProcessingException exception) {
            throw new UncheckedIOException("Unable to encode action", (IOException)((Object)exception));
        }
    }

    public static void validate(Action action) {
        Parser.validate(objectMapper.valueToTree((Object)action), jsonSchema);
    }

    public static void validate(String actionJson) {
        try {
            JsonNode action = objectMapper.readTree(actionJson);
            Parser.validate(action, jsonSchema);
        }
        catch (JsonProcessingException exception) {
            throw new UncheckedIOException("Unable to decode action", (IOException)((Object)exception));
        }
    }

    public static void validate(JsonNode action, JsonSchema jsonSchema) {
        ValidationResult result = jsonSchema.walk(action, true);
        if (result.getValidationMessages().size() > 0) {
            throw new ParsingException(result.getValidationMessages());
        }
    }

    private static void updateContextAndPayload(JsonNode action, ObjectMapper objectMapper) throws JsonProcessingException {
        JsonNode events;
        Parser.parseFieldIfNeeded(action, CONTEXT_FIELD, objectMapper);
        if (action.has(EVENTS_FIELD) && (events = action.get(EVENTS_FIELD)).getNodeType() == JsonNodeType.ARRAY) {
            for (int i = 0; i < events.size(); ++i) {
                Parser.parseFieldIfNeeded(events.get(i), PAYLOAD_FIELD, objectMapper);
            }
        }
    }

    private static void parseFieldIfNeeded(JsonNode container, String field, ObjectMapper objectMapper) throws JsonProcessingException {
        JsonNode target;
        if (container.has(field) && (target = container.get(field)).getNodeType() == JsonNodeType.STRING) {
            ((ObjectNode)container).replace(field, objectMapper.readTree(target.asText()));
        }
    }

    private static JsonSchema getJsonSchema() {
        JsonSchema jsonSchema;
        block8: {
            SchemaValidatorsConfig schemaValidatorsConfig = new SchemaValidatorsConfig();
            schemaValidatorsConfig.setApplyDefaultsStrategy(new ApplyDefaultsStrategy(true, true, true));
            InputStream jsonSchemaStream = Parser.class.getResourceAsStream("/schemas/Action.json");
            try {
                JsonNode schema = objectMapper.readTree(jsonSchemaStream);
                jsonSchema = Parser.jsonSchemaFactory().getSchema(schema, schemaValidatorsConfig);
                if (jsonSchemaStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonSchemaStream != null) {
                        try {
                            jsonSchemaStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new JsonSchemaException((Throwable)ioe);
                }
            }
            jsonSchemaStream.close();
        }
        return jsonSchema;
    }

    private static JsonSchemaFactory jsonSchemaFactory() {
        String ID = "$id";
        JsonMetaSchema overrideDateTimeValidator = new JsonMetaSchema.Builder(JsonMetaSchema.getV7().getUri()).idKeyword(ID).addKeywords((Collection)ValidatorTypeCode.getNonFormatKeywords((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7)).addKeywords(List.of(new NonValidationKeyword("title"), new NonValidationKeyword("$comment"), new NonValidationKeyword("description"), new NonValidationKeyword("default"))).addFormats((Collection)JsonMetaSchema.COMMON_BUILTIN_FORMATS).addFormat((Format)new LocalDateTimeValidator()).build();
        return new JsonSchemaFactory.Builder().defaultMetaSchemaURI(overrideDateTimeValidator.getUri()).addMetaSchema(overrideDateTimeValidator).build();
    }

    static {
        objectMapper.registerModule((Module)new LocalDateTimeModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }
}

