/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.ingress;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"only_admins", "ignore_user_preferences", "users", "groups"})
public class Recipient {
    @JsonProperty(value="only_admins")
    @JsonPropertyDescription(value="Setting to true sends an email to the administrators of the account. Setting to false sends an email to all users of the account. Note that this does not ignore the user preferences.")
    private Boolean onlyAdmins = false;
    @JsonProperty(value="ignore_user_preferences")
    @JsonPropertyDescription(value="Setting to true ignores all the user preferences on this Recipient setting (It doesn't affect other configuration that an Administrator sets on their Notification settings). Setting to false (default) honors the user preferences.")
    private Boolean ignoreUserPreferences = false;
    @JsonProperty(value="users")
    @JsonPropertyDescription(value="List of users to direct the notification to. Note that this does not ignore the user preferences.")
    private List<String> users = new ArrayList<String>();
    @JsonProperty(value="groups")
    @JsonPropertyDescription(value="List of group ids to direct the notification to. Note that this does not ignore the user preferences.")
    private List<String> groups = new ArrayList<String>();

    @JsonProperty(value="only_admins")
    public Boolean getOnlyAdmins() {
        return this.onlyAdmins;
    }

    @JsonProperty(value="only_admins")
    public void setOnlyAdmins(Boolean onlyAdmins) {
        this.onlyAdmins = onlyAdmins;
    }

    @JsonProperty(value="ignore_user_preferences")
    public Boolean getIgnoreUserPreferences() {
        return this.ignoreUserPreferences;
    }

    @JsonProperty(value="ignore_user_preferences")
    public void setIgnoreUserPreferences(Boolean ignoreUserPreferences) {
        this.ignoreUserPreferences = ignoreUserPreferences;
    }

    @JsonProperty(value="users")
    public List<String> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(List<String> users) {
        this.users = users;
    }

    @JsonProperty(value="groups")
    public List<String> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Recipient.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("onlyAdmins");
        sb.append('=');
        sb.append(this.onlyAdmins == null ? "<null>" : this.onlyAdmins);
        sb.append(',');
        sb.append("ignoreUserPreferences");
        sb.append('=');
        sb.append(this.ignoreUserPreferences == null ? "<null>" : this.ignoreUserPreferences);
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(this.users == null ? "<null>" : this.users);
        sb.append(',');
        sb.append("groups");
        sb.append('=');
        sb.append(this.groups == null ? "<null>" : this.groups);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.onlyAdmins == null ? 0 : this.onlyAdmins.hashCode());
        result = result * 31 + (this.groups == null ? 0 : this.groups.hashCode());
        result = result * 31 + (this.ignoreUserPreferences == null ? 0 : this.ignoreUserPreferences.hashCode());
        result = result * 31 + (this.users == null ? 0 : this.users.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Recipient)) {
            return false;
        }
        Recipient rhs = (Recipient)other;
        return (this.onlyAdmins == rhs.onlyAdmins || this.onlyAdmins != null && this.onlyAdmins.equals(rhs.onlyAdmins)) && (this.groups == rhs.groups || this.groups != null && this.groups.equals(rhs.groups)) && (this.ignoreUserPreferences == rhs.ignoreUserPreferences || this.ignoreUserPreferences != null && this.ignoreUserPreferences.equals(rhs.ignoreUserPreferences)) && (this.users == rhs.users || this.users != null && this.users.equals(rhs.users));
    }

    public static abstract class RecipientBuilderBase<T extends Recipient> {
        protected T instance;

        public RecipientBuilderBase() {
            if (this.getClass().equals(RecipientBuilder.class)) {
                this.instance = new Recipient();
            }
        }

        public T build() {
            T result = this.instance;
            this.instance = null;
            return result;
        }

        public RecipientBuilderBase withOnlyAdmins(Boolean onlyAdmins) {
            ((Recipient)this.instance).onlyAdmins = onlyAdmins;
            return this;
        }

        public RecipientBuilderBase withIgnoreUserPreferences(Boolean ignoreUserPreferences) {
            ((Recipient)this.instance).ignoreUserPreferences = ignoreUserPreferences;
            return this;
        }

        public RecipientBuilderBase withUsers(List<String> users) {
            ((Recipient)this.instance).users = users;
            return this;
        }

        public RecipientBuilderBase withGroups(List<String> groups) {
            ((Recipient)this.instance).groups = groups;
            return this;
        }
    }

    public static class RecipientBuilder
    extends RecipientBuilderBase<Recipient> {
    }
}

