/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.avro;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.cloud.notifications.avro.JsonObjectLogicalType;
import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;

public class JsonObjectConversion
extends Conversion<Map> {
    private final ObjectMapper mapper = new ObjectMapper();

    public Schema getRecommendedSchema() {
        return JsonObjectLogicalType.INSTANCE.addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
    }

    public Class<Map> getConvertedType() {
        return Map.class;
    }

    public String getLogicalTypeName() {
        return "json-object";
    }

    public Map fromCharSequence(CharSequence value, Schema schema, LogicalType type) {
        try {
            return (Map)this.mapper.readValue(value.toString(), Map.class);
        }
        catch (JsonProcessingException jpe) {
            throw new IllegalArgumentException(String.format("Unable to convert '%s' to JsonObject", value), jpe);
        }
    }

    public CharSequence toCharSequence(Map value, Schema schema, LogicalType type) {
        try {
            return this.mapper.writeValueAsString((Object)value);
        }
        catch (JsonProcessingException jpe) {
            throw new IllegalArgumentException(String.format("Unable to convert '%s' to String", value), jpe);
        }
    }
}

