/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.ingress;

import com.redhat.cloud.notifications.avro.AvroInit;
import com.redhat.cloud.notifications.avro.Iso8601Conversion;
import com.redhat.cloud.notifications.avro.JsonObjectConversion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Action
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -3675686353663277755L;
    public static final Schema SCHEMA$;
    private static SpecificData MODEL$;
    private static final BinaryMessageEncoder<Action> ENCODER;
    private static final BinaryMessageDecoder<Action> DECODER;
    private String bundle;
    private String application;
    private String event_type;
    private LocalDateTime timestamp;
    private String account_id;
    private Map payload;
    private static final Conversion<?>[] conversions;
    private static final DatumWriter<Action> WRITER$;
    private static final DatumReader<Action> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<Action> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<Action> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Action> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Action fromByteBuffer(ByteBuffer b) throws IOException {
        return (Action)((Object)DECODER.decode(b));
    }

    public Action() {
    }

    public Action(String bundle, String application, String event_type, LocalDateTime timestamp, String account_id, Map payload) {
        this.bundle = bundle;
        this.application = application;
        this.event_type = event_type;
        this.timestamp = timestamp;
        this.account_id = account_id;
        this.payload = payload;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.bundle;
            }
            case 1: {
                return this.application;
            }
            case 2: {
                return this.event_type;
            }
            case 3: {
                return this.timestamp;
            }
            case 4: {
                return this.account_id;
            }
            case 5: {
                return this.payload;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public Conversion<?> getConversion(int field) {
        return conversions[field];
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.bundle = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.application = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.event_type = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.timestamp = (LocalDateTime)value$;
                break;
            }
            case 4: {
                this.account_id = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.payload = (Map)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String value) {
        this.bundle = value;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String value) {
        this.application = value;
    }

    public String getEventType() {
        return this.event_type;
    }

    public void setEventType(String value) {
        this.event_type = value;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime value) {
        this.timestamp = value;
    }

    public String getAccountId() {
        return this.account_id;
    }

    public void setAccountId(String value) {
        this.account_id = value;
    }

    public Map getPayload() {
        return this.payload;
    }

    public void setPayload(Map value) {
        this.payload = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(Action other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    static {
        if (SCHEMA$ != null) {
            throw new RuntimeException("Application was not able to update before initializing the SCHEMA");
        }
        AvroInit.init();
        SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Action\",\"namespace\":\"com.redhat.cloud.notifications.ingress\",\"fields\":[{\"name\":\"bundle\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"application\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"event_type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"timestamp\",\"type\":{\"type\":\"string\",\"logicalType\":\"iso-8601\"}},{\"name\":\"account_id\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"payload\",\"type\":{\"type\":\"string\",\"logicalType\":\"json-object\"},\"default\":\"{}\"}]}");
        MODEL$ = new SpecificData();
        MODEL$.addLogicalTypeConversion((Conversion)new JsonObjectConversion());
        MODEL$.addLogicalTypeConversion((Conversion)new TimeConversions.LocalTimestampMillisConversion());
        ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
        conversions = new Conversion[]{null, null, null, new Iso8601Conversion(), null, new JsonObjectConversion(), null};
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<Action>
    implements RecordBuilder<Action> {
        private String bundle;
        private String application;
        private String event_type;
        private LocalDateTime timestamp;
        private String account_id;
        private Map payload;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.bundle)) {
                this.bundle = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.bundle);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.application)) {
                this.application = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.application);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.event_type)) {
                this.event_type = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.event_type);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.timestamp)) {
                this.timestamp = (LocalDateTime)this.data().deepCopy(this.fields()[3].schema(), (Object)other.timestamp);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.account_id)) {
                this.account_id = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.account_id);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.payload)) {
                this.payload = (Map)this.data().deepCopy(this.fields()[5].schema(), (Object)other.payload);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(Action other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.bundle)) {
                this.bundle = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.bundle);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.application)) {
                this.application = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.application);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.event_type)) {
                this.event_type = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.event_type);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.timestamp)) {
                this.timestamp = (LocalDateTime)this.data().deepCopy(this.fields()[3].schema(), (Object)other.timestamp);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.account_id)) {
                this.account_id = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.account_id);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.payload)) {
                this.payload = (Map)this.data().deepCopy(this.fields()[5].schema(), (Object)other.payload);
                this.fieldSetFlags()[5] = true;
            }
        }

        public String getBundle() {
            return this.bundle;
        }

        public Builder setBundle(String value) {
            this.validate(this.fields()[0], value);
            this.bundle = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasBundle() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearBundle() {
            this.bundle = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getApplication() {
            return this.application;
        }

        public Builder setApplication(String value) {
            this.validate(this.fields()[1], value);
            this.application = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasApplication() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearApplication() {
            this.application = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getEventType() {
            return this.event_type;
        }

        public Builder setEventType(String value) {
            this.validate(this.fields()[2], value);
            this.event_type = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasEventType() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearEventType() {
            this.event_type = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        public Builder setTimestamp(LocalDateTime value) {
            this.validate(this.fields()[3], value);
            this.timestamp = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasTimestamp() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearTimestamp() {
            this.timestamp = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getAccountId() {
            return this.account_id;
        }

        public Builder setAccountId(String value) {
            this.validate(this.fields()[4], value);
            this.account_id = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasAccountId() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearAccountId() {
            this.account_id = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Map getPayload() {
            return this.payload;
        }

        public Builder setPayload(Map value) {
            this.validate(this.fields()[5], value);
            this.payload = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasPayload() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearPayload() {
            this.payload = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Action build() {
            try {
                Action record = new Action();
                record.bundle = this.fieldSetFlags()[0] ? this.bundle : (String)this.defaultValue(this.fields()[0]);
                record.application = this.fieldSetFlags()[1] ? this.application : (String)this.defaultValue(this.fields()[1]);
                record.event_type = this.fieldSetFlags()[2] ? this.event_type : (String)this.defaultValue(this.fields()[2]);
                record.timestamp = this.fieldSetFlags()[3] ? this.timestamp : (LocalDateTime)this.defaultValue(this.fields()[3]);
                record.account_id = this.fieldSetFlags()[4] ? this.account_id : (String)this.defaultValue(this.fields()[4]);
                record.payload = this.fieldSetFlags()[5] ? this.payload : (Map)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

