/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.ingress;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.redhat.cloud.notifications.ingress.Metadata;
import com.redhat.cloud.notifications.ingress.Payload;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"metadata", "payload"})
public class Event {
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Placeholder for future details we might need")
    private Metadata metadata;
    @JsonProperty(value="payload")
    @JsonPropertyDescription(value="Your application payload. All the data required by the app to compose the various messages (Email, webhook, etc) after transformation")
    private Payload payload;

    public static EventBuilderBase builder() {
        return new EventBuilder();
    }

    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="payload")
    public Payload getPayload() {
        return this.payload;
    }

    @JsonProperty(value="payload")
    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Event.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        sb.append("payload");
        sb.append('=');
        sb.append(this.payload == null ? "<null>" : this.payload);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.payload == null ? 0 : this.payload.hashCode());
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Event)) {
            return false;
        }
        Event rhs = (Event)other;
        return (this.payload == rhs.payload || this.payload != null && this.payload.equals(rhs.payload)) && (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata));
    }

    public static class EventBuilder
    extends EventBuilderBase<Event> {
    }

    public static abstract class EventBuilderBase<T extends Event> {
        protected T instance;

        public EventBuilderBase() {
            if (this.getClass().equals(EventBuilder.class)) {
                this.instance = new Event();
            }
        }

        public T build() {
            T result = this.instance;
            this.instance = null;
            return result;
        }

        public EventBuilderBase withMetadata(Metadata metadata) {
            ((Event)this.instance).metadata = metadata;
            return this;
        }

        public EventBuilderBase withPayload(Payload payload) {
            ((Event)this.instance).payload = payload;
            return this;
        }
    }
}

