/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.ingress;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.ApplyDefaultsStrategy;
import com.networknt.schema.Format;
import com.networknt.schema.Formats;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.NonValidationKeyword;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorTypeCode;
import com.redhat.cloud.notifications.ingress.Action;
import com.redhat.cloud.notifications.ingress.ActionOut;
import com.redhat.cloud.notifications.ingress.ParsingException;
import com.redhat.cloud.notifications.jackson.LocalDateTimeModule;
import com.redhat.cloud.notifications.validator.LocalDateTimeValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;

public class Parser {
    static final ObjectMapper objectMapper = new ObjectMapper();
    private static final JsonSchema jsonSchema = Parser.getJsonSchema("/schemas/Action.json");
    private static final String ACTION_SCHEMA_PATH = "/schemas/Action.json";
    private static final String ACTION_OUT_SCHEMA_PATH = "/schemas/Action-out.json";
    private static final String CONTEXT_FIELD = "context";
    private static final String EVENTS_FIELD = "events";
    private static final String PAYLOAD_FIELD = "payload";

    public static Action decode(String actionJson) {
        try {
            JsonNode action = objectMapper.readTree(actionJson);
            Parser.updateContextAndPayload(action, objectMapper);
            Parser.validate(action, jsonSchema);
            return (Action)objectMapper.treeToValue((TreeNode)action, Action.class);
        }
        catch (JsonProcessingException exception) {
            throw new UncheckedIOException("Unable to decode action", (IOException)((Object)exception));
        }
    }

    public static String encode(Action action) {
        try {
            JsonNode asNode = objectMapper.valueToTree((Object)action);
            Parser.validate(asNode, jsonSchema);
            return objectMapper.writeValueAsString((Object)asNode);
        }
        catch (JsonProcessingException exception) {
            throw new UncheckedIOException("Unable to encode action", (IOException)((Object)exception));
        }
    }

    public static void validate(Action action) {
        Parser.validate(objectMapper.valueToTree((Object)action), jsonSchema);
    }

    public static void validate(String actionJson) {
        try {
            JsonNode action = objectMapper.readTree(actionJson);
            Parser.validate(action, jsonSchema);
        }
        catch (JsonProcessingException exception) {
            throw new UncheckedIOException("Unable to decode action", (IOException)((Object)exception));
        }
    }

    public static void validate(JsonNode action, JsonSchema jsonSchema) {
        ValidationResult result = jsonSchema.walk(action, true);
        if (!result.getValidationMessages().isEmpty()) {
            throw new ParsingException(result.getValidationMessages());
        }
    }

    public static void validate(ActionOut actionOut) {
        JsonSchema actionOutJsonSchema = Parser.getJsonSchema(ACTION_OUT_SCHEMA_PATH);
        Parser.validate(objectMapper.valueToTree((Object)actionOut), actionOutJsonSchema);
    }

    private static void updateContextAndPayload(JsonNode action, ObjectMapper objectMapper) throws JsonProcessingException {
        JsonNode events;
        Parser.parseFieldIfNeeded(action, CONTEXT_FIELD, objectMapper);
        if (action.has(EVENTS_FIELD) && (events = action.get(EVENTS_FIELD)).getNodeType() == JsonNodeType.ARRAY) {
            for (int i = 0; i < events.size(); ++i) {
                Parser.parseFieldIfNeeded(events.get(i), PAYLOAD_FIELD, objectMapper);
            }
        }
    }

    private static void parseFieldIfNeeded(JsonNode container, String field, ObjectMapper objectMapper) throws JsonProcessingException {
        JsonNode target;
        if (container.has(field) && (target = container.get(field)).getNodeType() == JsonNodeType.STRING) {
            ((ObjectNode)container).replace(field, objectMapper.readTree(target.asText()));
        }
    }

    private static JsonSchema getJsonSchema(String schemaPath) {
        JsonSchema jsonSchema;
        block8: {
            SchemaValidatorsConfig schemaValidatorsConfig = SchemaValidatorsConfig.builder().pathType(PathType.LEGACY).errorMessageKeyword("message").nullableKeywordEnabled(true).applyDefaultsStrategy(new ApplyDefaultsStrategy(true, true, true)).build();
            InputStream jsonSchemaStream = Parser.class.getResourceAsStream(schemaPath);
            try {
                JsonNode schema = objectMapper.readTree(jsonSchemaStream);
                jsonSchema = Parser.jsonSchemaFactory().getSchema(schema, schemaValidatorsConfig);
                if (jsonSchemaStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonSchemaStream != null) {
                        try {
                            jsonSchemaStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new JsonSchemaException((Throwable)ioe);
                }
            }
            jsonSchemaStream.close();
        }
        return jsonSchema;
    }

    private static JsonSchemaFactory jsonSchemaFactory() {
        String ID = "$id";
        JsonMetaSchema overrideDateTimeValidator = new JsonMetaSchema.Builder(JsonMetaSchema.getV7().getIri()).idKeyword(ID).keywords((Collection)ValidatorTypeCode.getKeywords((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7)).keywords(List.of(new NonValidationKeyword("title"), new NonValidationKeyword("$comment"), new NonValidationKeyword("description"), new NonValidationKeyword("default"))).formats((Collection)Formats.DEFAULT).format((Format)new LocalDateTimeValidator()).specification(SpecVersion.VersionFlag.V7).build();
        return new JsonSchemaFactory.Builder().defaultMetaSchemaIri(overrideDateTimeValidator.getIri()).metaSchema(overrideDateTimeValidator).build();
    }

    static {
        objectMapper.registerModule((Module)new LocalDateTimeModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }
}

