/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.ingress;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.redhat.cloud.notifications.ingress.Application;
import com.redhat.cloud.notifications.ingress.Bundle;
import com.redhat.cloud.notifications.ingress.EventType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"application", "bundle", "event_type"})
public class Source {
    @JsonProperty(value="application")
    @JsonPropertyDescription(value="Represents the extra information for the application object")
    private Application application;
    @JsonProperty(value="bundle")
    @JsonPropertyDescription(value="Represents the extra information for the bundle object")
    private Bundle bundle;
    @JsonProperty(value="event_type")
    @JsonPropertyDescription(value="Represents the extra information for the event type object")
    private EventType eventType;

    public static SourceBuilderBase builder() {
        return new SourceBuilder();
    }

    @JsonProperty(value="application")
    public Application getApplication() {
        return this.application;
    }

    @JsonProperty(value="application")
    public void setApplication(Application application) {
        this.application = application;
    }

    @JsonProperty(value="bundle")
    public Bundle getBundle() {
        return this.bundle;
    }

    @JsonProperty(value="bundle")
    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    @JsonProperty(value="event_type")
    public EventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="event_type")
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Source.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("application");
        sb.append('=');
        sb.append(this.application == null ? "<null>" : this.application);
        sb.append(',');
        sb.append("bundle");
        sb.append('=');
        sb.append(this.bundle == null ? "<null>" : this.bundle);
        sb.append(',');
        sb.append("eventType");
        sb.append('=');
        sb.append(this.eventType == null ? "<null>" : this.eventType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.application == null ? 0 : this.application.hashCode());
        result = result * 31 + (this.bundle == null ? 0 : this.bundle.hashCode());
        result = result * 31 + (this.eventType == null ? 0 : this.eventType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Source)) {
            return false;
        }
        Source rhs = (Source)other;
        return (this.application == rhs.application || this.application != null && this.application.equals(rhs.application)) && (this.bundle == rhs.bundle || this.bundle != null && this.bundle.equals(rhs.bundle)) && (this.eventType == rhs.eventType || this.eventType != null && this.eventType.equals(rhs.eventType));
    }

    public static class SourceBuilder
    extends SourceBuilderBase<Source> {
    }

    public static abstract class SourceBuilderBase<T extends Source> {
        protected T instance;

        public SourceBuilderBase() {
            if (this.getClass().equals(SourceBuilder.class)) {
                this.instance = new Source();
            }
        }

        public T build() {
            T result = this.instance;
            this.instance = null;
            return result;
        }

        public SourceBuilderBase withApplication(Application application) {
            ((Source)this.instance).application = application;
            return this;
        }

        public SourceBuilderBase withBundle(Bundle bundle) {
            ((Source)this.instance).bundle = bundle;
            return this;
        }

        public SourceBuilderBase withEventType(EventType eventType) {
            ((Source)this.instance).eventType = eventType;
            return this;
        }
    }
}

