/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.notifications.avro;

import com.redhat.cloud.notifications.avro.Iso8601LogicalType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;

public class Iso8601Conversion
extends Conversion<LocalDateTime> {
    public Schema getRecommendedSchema() {
        return Iso8601LogicalType.INSTANCE.addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
    }

    public Class<LocalDateTime> getConvertedType() {
        return LocalDateTime.class;
    }

    public String getLogicalTypeName() {
        return "iso-8601";
    }

    public LocalDateTime fromCharSequence(CharSequence value, Schema schema, LogicalType type) {
        return LocalDateTime.parse(value.toString(), DateTimeFormatter.ISO_DATE_TIME);
    }

    public CharSequence toCharSequence(LocalDateTime value, Schema schema, LogicalType type) {
        return value.format(DateTimeFormatter.ISO_DATE_TIME);
    }
}

